/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.legacyjavafixer;

import com.google.common.base.Throwables;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.launcher.FMLInjectionAndSortingTweaker;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class LegacyJavaFixer
implements ITweaker {
    public LegacyJavaFixer() {
        ListIterator<SortReplacement> itr = ((List)Launch.blackboard.get("Tweaks")).listIterator();
        SortReplacement replacement = new SortReplacement();
        while (itr.hasNext()) {
            ITweaker t = (ITweaker)itr.next();
            FMLRelaunchLog.info((String)("[LegacyJavaFixer] Tweaker: " + t), (Object[])new Object[0]);
            if (!(t instanceof FMLInjectionAndSortingTweaker)) continue;
            itr.set(replacement);
            FMLRelaunchLog.info((String)"[LegacyJavaFixer] Replacing tweaker %s with %s", (Object[])new Object[]{t, replacement});
        }
    }

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
    }

    public String[] getLaunchArguments() {
        return new String[0];
    }

    public String getLaunchTarget() {
        return "";
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
    }

    public static class SortReplacement
    implements ITweaker {
        private boolean hasRun = false;
        Class<?> wrapperCls = null;
        Field wrapperField = null;
        Map<String, Integer> tweakSorting = null;

        SortReplacement() {
            try {
                this.wrapperCls = Class.forName("cpw.mods.fml.relauncher.CoreModManager$FMLPluginWrapper", false, SortReplacement.class.getClassLoader());
                this.wrapperField = this.wrapperCls.getDeclaredField("sortIndex");
                this.wrapperField.setAccessible(true);
                this.tweakSorting = (Map)ReflectionHelper.getPrivateValue(CoreModManager.class, null, (String[])new String[]{"tweakSorting"});
            }
            catch (Exception e) {
                e.printStackTrace();
                Throwables.propagate((Throwable)e);
            }
        }

        public void injectIntoClassLoader(LaunchClassLoader classLoader) {
            if (!this.hasRun) {
                FMLRelaunchLog.info((String)"[LegacyJavaFixer] Replacing sort", (Object[])new Object[0]);
                this.sort();
                URL is = FMLInjectionAndSortingTweaker.class.getResource("/cpw/mods/fml/common/launcher/TerminalTweaker.class");
                if (is != null) {
                    FMLRelaunchLog.info((String)"[LegacyJavaFixer] Detected TerminalTweaker", (Object[])new Object[0]);
                    List newTweaks = (List)Launch.blackboard.get("TweakClasses");
                    newTweaks.add("cpw.mods.fml.common.launcher.TerminalTweaker");
                }
            }
            this.hasRun = true;
        }

        private void sort() {
            List tweakers = (List)Launch.blackboard.get("Tweaks");
            ITweaker[] toSort = tweakers.toArray(new ITweaker[tweakers.size()]);
            Arrays.sort(toSort, new Comparator<ITweaker>(){

                @Override
                public int compare(ITweaker o1, ITweaker o2) {
                    return Ints.saturatedCast((long)((long)this.getIndex(o1) - (long)this.getIndex(o2)));
                }

                private int getIndex(ITweaker t) {
                    try {
                        if (t instanceof SortReplacement) {
                            return Integer.MIN_VALUE;
                        }
                        if (SortReplacement.this.wrapperCls.isInstance(t)) {
                            return SortReplacement.this.wrapperField.getInt(t);
                        }
                        if (SortReplacement.this.tweakSorting.containsKey(t.getClass().getName())) {
                            return SortReplacement.this.tweakSorting.get(t.getClass().getName());
                        }
                    }
                    catch (Exception e) {
                        Throwables.propagate((Throwable)e);
                    }
                    return 0;
                }
            });
            for (int j = 0; j < toSort.length; ++j) {
                tweakers.set(j, toSort[j]);
            }
        }

        public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        }

        public String[] getLaunchArguments() {
            return new String[0];
        }

        public String getLaunchTarget() {
            return "";
        }
    }
}

