/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import tsteelworks.blocks.logic.DeepTankLogic;
import tsteelworks.client.gui.TSContainerGui;
import tsteelworks.inventory.TSActiveContainer;
import tsteelworks.lib.Repo;

public class DeepTankGui
extends TSContainerGui {
    public DeepTankLogic logic;
    String username;
    boolean wasClicking;
    private static final ResourceLocation background = new ResourceLocation("tsteelworks", "textures/gui/deeptank.png");
    private static final ResourceLocation terrain = new ResourceLocation("terrain.png");

    public DeepTankGui(InventoryPlayer inventoryplayer, DeepTankLogic tank, World world, int x, int y, int z) {
        super((TSActiveContainer)tank.getGuiContainer(inventoryplayer, world, x, y, z));
        this.logic = tank;
        this.username = inventoryplayer.field_70458_d.field_71092_bJ;
        this.xSize = 248;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float par3) {
        super.func_73863_a(mouseX, mouseY, par3);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        String title = StatCollector.func_74838_a((String)"tank.DeepTank");
        this.field_73886_k.func_78276_b(title, this.xSize / 2 - this.field_73886_k.func_78256_a(title) / 2, 17, 0x404040);
        int base = 0;
        int cornerX = (this.field_73880_f - this.xSize) / 2 + 20;
        int cornerY = (this.field_73881_g - this.ySize) / 2 + 12;
        for (FluidStack liquid : this.logic.fluidlist) {
            int total;
            int liquidLayers;
            int basePos = 54;
            boolean initialLiquidSize = false;
            int liquidSize = 0;
            if (this.logic.getCapacity() > 0 && (liquidLayers = ((total = this.logic.getTotalLiquid()) / this.logic.layerFluidCapacity() + 1) * this.logic.layerFluidCapacity()) > 0) {
                liquidSize = liquid.amount * 104 / liquidLayers;
                if (liquidSize == 0) {
                    liquidSize = 1;
                }
                base += liquidSize;
            }
            int leftX = cornerX + basePos;
            int topY = cornerY + 120 - base;
            int sizeX = 104;
            int sizeY = liquidSize;
            if (mouseX < leftX || mouseX > leftX + sizeX || mouseY < topY || mouseY >= topY + sizeY) continue;
            this.drawFluidStackTooltip(liquid, mouseX - cornerX + 36, mouseY - cornerY);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(background);
        int cornerX = (this.field_73880_f - this.xSize) / 2 + 20;
        int cornerY = (this.field_73881_g - this.ySize) / 2 + 12;
        this.func_73729_b(cornerX + 46, cornerY, 0, 0, 120, this.ySize);
        this.field_73882_e.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        int base = 0;
        for (FluidStack liquid : this.logic.fluidlist) {
            int total;
            int liquidLayers;
            Icon renderIndex = liquid.getFluid().getStillIcon();
            int basePos = 54;
            if (this.logic.getCapacity() <= 0 || (liquidLayers = ((total = this.logic.getTotalLiquid()) / this.logic.layerFluidCapacity() + 1) * this.logic.layerFluidCapacity()) <= 0) continue;
            int liquidSize = liquid.amount * 104 / liquidLayers;
            if (liquidSize == 0) {
                liquidSize = 1;
            }
            while (liquidSize > 0) {
                int size;
                int n = size = liquidSize >= 16 ? 16 : liquidSize;
                if (renderIndex != null) {
                    this.drawLiquidRect(cornerX + basePos, cornerY + 120 - size - base, renderIndex, 16, size);
                    this.drawLiquidRect(cornerX + basePos + 16, cornerY + 120 - size - base, renderIndex, 16, size);
                    this.drawLiquidRect(cornerX + basePos + 32, cornerY + 120 - size - base, renderIndex, 16, size);
                    this.drawLiquidRect(cornerX + basePos + 48, cornerY + 120 - size - base, renderIndex, 16, size);
                    this.drawLiquidRect(cornerX + basePos + 64, cornerY + 120 - size - base, renderIndex, 16, size);
                    this.drawLiquidRect(cornerX + basePos + 80, cornerY + 120 - size - base, renderIndex, 16, size);
                    this.drawLiquidRect(cornerX + basePos + 96, cornerY + 120 - size - base, renderIndex, 8, size);
                }
                liquidSize -= size;
                base += size;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(background);
        this.func_73729_b(cornerX + 54, cornerY + 16, 120, 0, 104, 104);
    }

    protected void drawFluidStackTooltip(FluidStack par1ItemStack, int par2, int par3) {
        this.field_73735_i = 100.0f;
        List list = this.getLiquidTooltip(par1ItemStack, this.field_73882_e.field_71474_y.field_82882_x);
        for (int k = 0; k < list.size(); ++k) {
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        this.drawToolTip(list, par2, par3);
        this.field_73735_i = 0.0f;
    }

    public List getLiquidTooltip(FluidStack liquid, boolean par2) {
        ArrayList<String> list = new ArrayList<String>();
        if (liquid.fluidID == -37) {
            list.add("\u00a7f" + StatCollector.func_74838_a((String)"gui.smeltery1"));
            list.add("mB: " + liquid.amount);
        } else {
            String name = StatCollector.func_74838_a((String)("fluid." + FluidRegistry.getFluidName((FluidStack)liquid)));
            list.add("\u00a7f" + name);
            if (name.equals("Liquified Emerald")) {
                list.add("Emeralds: " + (float)liquid.amount / 640.0f);
            } else if (name.equals("Molten Glass")) {
                int mB;
                int panels;
                int blocks = liquid.amount / 1000;
                if (blocks > 0) {
                    list.add("Blocks: " + blocks);
                }
                if ((panels = liquid.amount % 1000 / 250) > 0) {
                    list.add("Panels: " + panels);
                }
                if ((mB = liquid.amount % 1000 % 250) > 0) {
                    list.add("mB: " + mB);
                }
            } else if (name.contains("Molten")) {
                int mB;
                int ingots = liquid.amount / 144;
                if (ingots > 0) {
                    list.add("Ingots: " + ingots);
                }
                if ((mB = liquid.amount % 144) > 0) {
                    int nuggets = mB / 16;
                    int junk = mB % 16;
                    if (nuggets > 0) {
                        list.add("Nuggets: " + nuggets);
                    }
                    if (junk > 0) {
                        list.add("mB: " + junk);
                    }
                }
            } else if (name.equals("Seared Stone")) {
                int mB;
                int ingots = liquid.amount / 144;
                if (ingots > 0) {
                    list.add("Blocks: " + ingots);
                }
                if ((mB = liquid.amount % 144) > 0) {
                    list.add("mB: " + mB);
                }
            } else {
                list.add("mB: " + liquid.amount);
            }
        }
        return list;
    }

    protected void drawToolTip(List par1List, int par2, int par3) {
        if (!par1List.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                int l = this.field_73886_k.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.field_73880_f) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_73881_g) {
                j1 = this.field_73881_g - k1 - 6;
            }
            this.field_73735_i = 300.0f;
            DeepTankGui.itemRenderer.field_77023_b = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = (String)par1List.get(k2);
                this.field_73886_k.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            DeepTankGui.itemRenderer.field_77023_b = 0.0f;
        }
    }

    public void drawLiquidRect(int startU, int startV, Icon par3Icon, int endU, int endV) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(startU + 0), (double)(startV + endV), (double)this.field_73735_i, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(startU + endU), (double)(startV + endV), (double)this.field_73735_i, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(startU + endU), (double)(startV + 0), (double)this.field_73735_i, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94206_g());
        tessellator.func_78374_a((double)(startU + 0), (double)(startV + 0), (double)this.field_73735_i, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94206_g());
        tessellator.func_78381_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int base = 0;
        int cornerX = (this.field_73880_f - this.xSize) / 2 + 20;
        int cornerY = (this.field_73881_g - this.ySize) / 2 + 12;
        int fluidToBeBroughtUp = -1;
        for (FluidStack liquid : this.logic.fluidlist) {
            int total;
            int liquidLayers;
            int basePos = 54;
            boolean initialLiquidSize = false;
            int liquidSize = 0;
            if (this.logic.getCapacity() > 0 && (liquidLayers = ((total = this.logic.getTotalLiquid()) / this.logic.layerFluidCapacity() + 1) * this.logic.layerFluidCapacity()) > 0) {
                liquidSize = liquid.amount * 104 / liquidLayers;
                if (liquidSize == 0) {
                    liquidSize = 1;
                }
                base += liquidSize;
            }
            int leftX = cornerX + basePos;
            int topY = cornerY + 120 - base;
            int sizeX = 104;
            int sizeY = liquidSize;
            if (mouseX < leftX || mouseX > leftX + sizeX || mouseY < topY || mouseY >= topY + sizeY) continue;
            fluidToBeBroughtUp = liquid.fluidID;
            Packet250CustomPayload packet = new Packet250CustomPayload();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.write(Repo.tankPacketID);
                dos.writeInt(this.logic.field_70331_k.field_73011_w.field_76574_g);
                dos.writeInt(this.logic.field_70329_l);
                dos.writeInt(this.logic.field_70330_m);
                dos.writeInt(this.logic.field_70327_n);
                dos.writeBoolean(this.func_73877_p());
                dos.writeInt(fluidToBeBroughtUp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            packet.field_73630_a = "TSteelworks";
            packet.field_73629_c = bos.toByteArray();
            packet.field_73628_b = bos.size();
            PacketDispatcher.sendPacketToServer((Packet)packet);
        }
    }
}

