/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.blocks.logic;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tconstruct.library.util.CoordTuple;
import tconstruct.library.util.IMasterLogic;
import tconstruct.library.util.IServantLogic;
import tsteelworks.TSteelworks;
import tsteelworks.lib.IMaster;
import tsteelworks.lib.ITSMasterLogic;

public class TSMultiServantLogic
extends TileEntity
implements IServantLogic {
    private IMaster imaster;
    CoordTuple master;
    boolean hasMaster;
    short masterID;
    byte masterMeta;

    public boolean canUpdate() {
        return false;
    }

    public boolean hasValidMasterNEW() {
        if (this.imaster == null || !this.func_70309_m()) {
            return false;
        }
        CoordTuple coord = this.imaster.getCoord();
        TileEntity te = this.field_70331_k.func_72796_p(coord.x, coord.y, coord.z);
        if (te instanceof IMaster) {
            if (this.func_70314_l().func_72798_a(coord.x, coord.y, coord.z) == this.imaster.getBlockId() && this.func_70314_l().func_72805_g(coord.x, coord.y, coord.z) == this.imaster.getBlockMetadata()) {
                return this.imaster.isValid();
            }
            this.imaster = null;
            return false;
        }
        return false;
    }

    public boolean hasValidMaster() {
        if (!this.hasMaster) {
            return false;
        }
        if (this.field_70331_k.func_72798_a(this.master.x, this.master.y, this.master.z) == this.masterID && this.field_70331_k.func_72805_g(this.master.x, this.master.y, this.master.z) == this.masterMeta) {
            TileEntity te = this.field_70331_k.func_72796_p(this.master.x, this.master.y, this.master.z);
            if (te != null && te instanceof ITSMasterLogic) {
                ITSMasterLogic logic = (ITSMasterLogic)te;
                return logic.isValid();
            }
            return true;
        }
        this.hasMaster = false;
        this.master = null;
        return false;
    }

    public CoordTuple getMasterPositionNEW() {
        return this.imaster != null ? this.imaster.getCoord() : null;
    }

    public CoordTuple getMasterPosition() {
        return this.master;
    }

    public boolean overrideMasterNEW(int x, int y, int z) {
        TileEntity te = this.field_70331_k.func_72796_p(x, y, z);
        if (te instanceof IMaster) {
            this.imaster = (IMaster)te;
            return true;
        }
        this.imaster = null;
        TSteelworks.loginfo("TSMSLogic - overrideMaster - it's not a IMaster - " + te.getClass());
        return false;
    }

    public boolean overrideMaster(int x, int y, int z) {
        this.hasMaster = true;
        this.master = new CoordTuple(x, y, z);
        this.masterID = (short)this.field_70331_k.func_72798_a(x, y, z);
        this.masterMeta = (byte)this.field_70331_k.func_72805_g(x, y, z);
        return true;
    }

    public void removeMasterNEW() {
        this.imaster = null;
    }

    public void removeMaster() {
        this.hasMaster = false;
        this.master = null;
        this.masterID = 0;
        this.masterMeta = 0;
    }

    public void notifyMasterOfChangeNEW() {
        if (this.hasValidMaster()) {
            CoordTuple masterCoord = this.imaster.getCoord();
            IMasterLogic logic = (IMasterLogic)this.func_70314_l().func_72796_p(masterCoord.x, masterCoord.y, masterCoord.z);
            if (logic == null) {
                return;
            }
            logic.notifyChange((IServantLogic)this, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public void notifyMasterOfChange() {
        if (this.hasValidMaster()) {
            IMasterLogic logic = (IMasterLogic)this.field_70331_k.func_72796_p(this.master.x, this.master.y, this.master.z);
            logic.notifyChange((IServantLogic)this, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Deprecated
    public boolean verifyMaster(IMasterLogic logic, int x, int y, int z) {
        return this.verifyMaster(logic, null, x, y, z);
    }

    @Deprecated
    public boolean setMasterNEW(int x, int y, int z) {
        return !this.hasValidMasterNEW() ? this.overrideMaster(x, y, z) : false;
    }

    @Deprecated
    public boolean setMaster(int x, int y, int z) {
        if (!this.hasMaster || this.field_70331_k.func_72798_a(this.master.x, this.master.y, this.master.z) != this.masterID || this.field_70331_k.func_72805_g(this.master.x, this.master.y, this.master.z) != this.masterMeta) {
            this.overrideMaster(x, y, z);
            return true;
        }
        return false;
    }

    public boolean setPotentialMasterNEW(IMasterLogic master, World world, int x, int y, int z) {
        return this.imaster == null;
    }

    public boolean setPotentialMaster(IMasterLogic master, World world, int x, int y, int z) {
        return !this.hasMaster;
    }

    public boolean verifyMasterNEW(IMasterLogic logic, World world, int x, int y, int z) {
        if (this.imaster != null) {
            return this.hasValidMaster();
        }
        return this.overrideMaster(x, y, z);
    }

    public boolean verifyMaster(IMasterLogic logic, World world, int x, int y, int z) {
        return this.hasMaster ? this.hasValidMaster() : this.overrideMaster(x, y, z);
    }

    public void invalidateMasterNEW(IMasterLogic master, World world, int x, int y, int z) {
        this.imaster = null;
    }

    public void invalidateMaster(IMasterLogic master, World world, int x, int y, int z) {
        this.hasMaster = false;
        master = null;
    }

    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.readCustomNBT(tags);
    }

    public void readCustomNBT_NEW(NBTTagCompound tags) {
        boolean hasMaster = tags.func_74767_n("TiedToMaster");
        if (hasMaster) {
            int xCenter = tags.func_74762_e("xCenter");
            int yCenter = tags.func_74762_e("yCenter");
            int zCenter = tags.func_74762_e("zCenter");
            this.overrideMaster(xCenter, yCenter, zCenter);
        }
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.hasMaster = tags.func_74767_n("TiedToMaster");
        if (this.hasMaster) {
            int xCenter = tags.func_74762_e("xCenter");
            int yCenter = tags.func_74762_e("yCenter");
            int zCenter = tags.func_74762_e("zCenter");
            this.master = new CoordTuple(xCenter, yCenter, zCenter);
            this.masterID = tags.func_74765_d("MasterID");
            this.masterMeta = tags.func_74771_c("masterMeta");
        }
    }

    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        this.writeCustomNBT(tags);
    }

    public void writeCustomNBT_NEW(NBTTagCompound tags) {
        boolean hasMaster = this.imaster != null;
        tags.func_74757_a("TiedToMaster", hasMaster);
        if (hasMaster) {
            CoordTuple coord = this.imaster.getCoord();
            tags.func_74768_a("xCenter", coord.x);
            tags.func_74768_a("yCenter", coord.y);
            tags.func_74768_a("zCenter", coord.z);
            tags.func_74777_a("MasterID", (short)this.imaster.getBlockId());
            tags.func_74774_a("masterMeta", (byte)this.imaster.getBlockMetadata());
        }
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74757_a("TiedToMaster", this.hasMaster);
        if (this.hasMaster) {
            tags.func_74768_a("xCenter", this.master.x);
            tags.func_74768_a("yCenter", this.master.y);
            tags.func_74768_a("zCenter", this.master.z);
            tags.func_74777_a("MasterID", this.masterID);
            tags.func_74774_a("masterMeta", this.masterMeta);
        }
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.readCustomNBT(packet.field_73331_e);
        this.func_70314_l().func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }
}

