/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.blocks.logic;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import tconstruct.library.util.IFacingLogic;
import tsteelworks.blocks.logic.DeepTankLogic;
import tsteelworks.blocks.logic.HighOvenLogic;
import tsteelworks.blocks.logic.TSMultiServantLogic;

public class HighOvenDrainLogic
extends TSMultiServantLogic
implements IFluidHandler,
IFacingLogic {
    byte direction;

    @Override
    public boolean canUpdate() {
        return false;
    }

    public int getControllerLogicType() {
        int mx = this.getMasterPosition().x;
        int my = this.getMasterPosition().y;
        int mz = this.getMasterPosition().z;
        if (this.field_70331_k.func_72796_p(mx, my, mz) instanceof HighOvenLogic) {
            return 1;
        }
        if (this.field_70331_k.func_72796_p(mx, my, mz) instanceof DeepTankLogic) {
            return 2;
        }
        return 0;
    }

    public HighOvenLogic getHighOvenController() {
        int mx = this.getMasterPosition().x;
        int my = this.getMasterPosition().y;
        int mz = this.getMasterPosition().z;
        return (HighOvenLogic)this.field_70331_k.func_72796_p(mx, my, mz);
    }

    public DeepTankLogic getDeepTankController() {
        int mx = this.getMasterPosition().x;
        int my = this.getMasterPosition().y;
        int mz = this.getMasterPosition().z;
        return (DeepTankLogic)this.field_70331_k.func_72796_p(mx, my, mz);
    }

    public IFluidTank getControllerTank() {
        int type = this.getControllerLogicType();
        if (type == 1) {
            return this.getHighOvenController();
        }
        if (type == 2) {
            return this.getDeepTankController();
        }
        return null;
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        boolean containsFluid;
        boolean bl = containsFluid = fluid == null;
        if (fluid != null) {
            int type = this.getControllerLogicType();
            if (type == 1) {
                for (FluidStack fstack : this.getHighOvenController().moltenMetal) {
                    if (fstack.fluidID != fluid.getID()) continue;
                    containsFluid = true;
                    break;
                }
            }
            if (type == 2) {
                for (FluidStack fstack : this.getDeepTankController().fluidlist) {
                    if (fstack.fluidID != fluid.getID()) continue;
                    containsFluid = true;
                    break;
                }
            }
        }
        return containsFluid;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.hasValidMaster() && this.canDrain(from, null)) {
            return this.getControllerTank().drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (!this.hasValidMaster()) {
            return false;
        }
        int type = this.getControllerLogicType();
        if (type == 1 && this.getHighOvenController().getTotalFluidAmount() >= this.getHighOvenController().maxLiquid) {
            return false;
        }
        return type != 2 || this.getDeepTankController().getTotalFluidAmount() < this.getDeepTankController().maxLiquid;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.hasValidMaster() && resource != null && this.canFill(from, resource.getFluid())) {
            if (doFill) {
                return this.getControllerTank().fill(resource, doFill);
            }
            return resource.amount;
        }
        return 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.hasValidMaster() && (from == this.getForgeDirection() || from == this.getForgeDirection().getOpposite() || from == ForgeDirection.UNKNOWN)) {
            int type = this.getControllerLogicType();
            if (type == 1) {
                return new FluidTankInfo[]{this.getHighOvenController().getInfo()};
            }
            if (type == 2) {
                return new FluidTankInfo[]{this.getDeepTankController().getInfo()};
            }
            return null;
        }
        return null;
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.direction = tags.func_74771_c("Direction");
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        tags.func_74774_a("Direction", this.direction);
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }
}

