/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.common.TContent;
import tconstruct.library.util.CoordTuple;
import tconstruct.library.util.IFacingLogic;
import tconstruct.library.util.IMasterLogic;
import tconstruct.library.util.IServantLogic;
import tsteelworks.TSteelworks;
import tsteelworks.blocks.logic.DeepTankLogic;
import tsteelworks.blocks.logic.HighOvenDrainLogic;
import tsteelworks.blocks.logic.HighOvenDuctLogic;
import tsteelworks.blocks.logic.HighOvenLogic;
import tsteelworks.blocks.logic.TSMultiServantLogic;
import tsteelworks.client.block.DeepTankRender;
import tsteelworks.common.TSCommonProxy;
import tsteelworks.entity.HighGolem;
import tsteelworks.lib.TSteelworksRegistry;
import tsteelworks.lib.blocks.TSInventoryBlock;

public class HighOvenBlock
extends TSInventoryBlock {
    static ArrayList<CoordTuple> directions = new ArrayList(6);
    Random rand;
    String texturePrefix = "";

    public HighOvenBlock(int id) {
        super(id, Material.field_76246_e);
        this.func_71848_c(3.0f);
        this.func_71894_b(20.0f);
        this.func_71884_a(field_71977_i);
        this.rand = new Random();
        this.func_71849_a((CreativeTabs)TSteelworksRegistry.SteelworksCreativeTab);
        this.func_71864_b("tsteelworks.HighOven");
    }

    public HighOvenBlock(int id, String prefix) {
        this(id);
        this.texturePrefix = prefix;
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int blockID, int meta) {
        TileEntity logic = world.func_72796_p(x, y, z);
        if (logic instanceof IServantLogic) {
            ((IServantLogic)logic).notifyMasterOfChange();
        }
        if (logic instanceof HighOvenDuctLogic && logic != null) {
            for (int j1 = 0; j1 < ((HighOvenDuctLogic)logic).func_70302_i_(); ++j1) {
                ItemStack itemstack = ((HighOvenDuctLogic)logic).func_70301_a(j1);
                if (itemstack == null) continue;
                float f = this.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int k1 = this.rand.nextInt(21) + 10;
                    if (k1 > itemstack.field_77994_a) {
                        k1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= k1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.field_77993_c, k1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.rand.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.rand.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.rand.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_96440_m(x, y, z, blockID);
        }
        super.func_71852_a(world, x, y, z, blockID, meta);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.func_72796_p(x, y, z);
        return logic instanceof IMasterLogic;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        return false;
    }

    @Override
    public TileEntity func_72274_a(World world) {
        return null;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new HighOvenLogic();
            }
            case 1: {
                return new HighOvenDrainLogic();
            }
            case 12: {
                return new HighOvenDuctLogic();
            }
            case 13: {
                return new DeepTankLogic();
            }
        }
        return new TSMultiServantLogic();
    }

    @Override
    public int func_71899_b(int meta) {
        return meta;
    }

    public int func_71857_b() {
        return DeepTankRender.deeptankModel;
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.func_72796_p(x, y, z);
        int direction = logic instanceof IFacingLogic ? (int)((IFacingLogic)logic).getRenderDirection() : 0;
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            if (side == direction) {
                if (HighOvenBlock.isActive(world, x, y, z)) {
                    return this.icons[2];
                }
                return this.icons[1];
            }
            return this.icons[0];
        }
        if (meta == 1) {
            if (side == direction) {
                return this.icons[5];
            }
            if (side / 2 == direction / 2) {
                return this.icons[4];
            }
            return this.icons[3];
        }
        if (meta == 2) {
            return this.icons[6];
        }
        if (meta == 11 && (side == 0 || side == 1)) {
            return this.icons[9];
        }
        if (meta == 12) {
            if (side == direction) {
                return this.icons[15];
            }
            if (side / 2 == direction / 2) {
                return this.icons[4];
            }
            return this.icons[3];
        }
        if (meta == 13) {
            if (side == direction) {
                return this.icons[16];
            }
            return this.icons[0];
        }
        return this.icons[3 + meta];
    }

    @Override
    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        int meta = world.func_72805_g(x, y, z);
        world.func_72796_p(x, y, z);
        switch (meta) {
            case 0: {
                return TSCommonProxy.highovenGuiID;
            }
            case 12: {
                return TSCommonProxy.highovenDuctGuiID;
            }
            case 13: {
                return TSCommonProxy.deeptankGuiID;
            }
        }
        return null;
    }

    public Icon func_71858_a(int side, int meta) {
        if (meta < 2) {
            int sideTex = side == 3 ? 1 : 0;
            return this.icons[sideTex + meta * 3];
        }
        if (meta == 2) {
            return this.icons[6];
        }
        if (meta == 11) {
            if (side == 0 || side == 1) {
                return this.icons[9];
            }
        } else {
            if (meta == 12) {
                int sideTex = side == 3 ? 15 : 6;
                return this.icons[sideTex];
            }
            if (meta == 13) {
                int sideTex = side == 3 ? 16 : 6;
                return this.icons[sideTex];
            }
        }
        return this.icons[3 + meta];
    }

    public int getIndirectPowerLevelTo(World world, int x, int y, int z, int side) {
        if (world.func_72809_s(x, y, z)) {
            return world.func_94577_B(x, y, z);
        }
        int i1 = world.func_72798_a(x, y, z);
        return i1 == 0 ? 0 : Block.field_71973_m[i1].func_71865_a((IBlockAccess)world, x, y, z, side);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return !HighOvenBlock.isActive(world, x, y, z) ? 0 : 9;
    }

    @Override
    public Object getModInstance() {
        return TSteelworks.instance;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 14; ++iter) {
            if (iter == 3) continue;
            list.add(new ItemStack(id, 1, iter));
        }
    }

    @Override
    public String[] getTextureNames() {
        String[] textureNames = new String[]{"highoven_side", "highoven_inactive", "highoven_active", "drain_side", "drain_out", "drain_basin", "scorchedbrick", "scorchedstone", "scorchedcobble", "scorchedpaver", "scorchedbrickcracked", "scorchedroad", "scorchedbrickfancy", "scorchedbricksquare", "scorchedcreeper", "duct_out", "deeptank_controller"};
        if (!this.texturePrefix.equals("")) {
            for (int i = 0; i < textureNames.length; ++i) {
                textureNames[i] = this.texturePrefix + "_" + textureNames[i];
            }
        }
        return textureNames;
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        int meta = world.func_72805_g(x, y, z);
        if (player.func_70093_af()) {
            return false;
        }
        Integer integer = this.getGui(world, x, y, z, player);
        if (integer == null || integer == -1) {
            return false;
        }
        if (meta == 0 || meta == 12 || meta == 13) {
            player.openGui(this.getModInstance(), integer.intValue(), world, x, y, z);
            return true;
        }
        return false;
    }

    public void func_71861_g(World world, int x, int y, int z) {
        super.func_71861_g(world, x, y, z);
        if (world.func_72805_g(x, y, z) == 0) {
            this.spawnHighGolem(world, x, y, z);
        }
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        super.func_71860_a(world, x, y, z, entityliving, stack);
        if (world.func_72805_g(x, y, z) == 0 || world.func_72805_g(x, y, z) == 13) {
            this.onBlockPlacedElsewhere(world, x, y, z, entityliving);
        }
    }

    public void onBlockPlacedElsewhere(World world, int x, int y, int z, EntityLivingBase entityliving) {
        TileEntity logic;
        if (world.func_72805_g(x, y, z) == 0) {
            logic = (HighOvenLogic)world.func_72796_p(x, y, z);
            logic.checkValidPlacement();
        }
        if (world.func_72805_g(x, y, z) == 13) {
            logic = (DeepTankLogic)world.func_72796_p(x, y, z);
            logic.checkValidPlacement();
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int nBlockID) {
        TileEntity logic = world.func_72796_p(x, y, z);
        if (logic instanceof IServantLogic) {
            ((IServantLogic)logic).notifyMasterOfChange();
        } else if (logic instanceof IMasterLogic) {
            ((IMasterLogic)logic).notifyChange(null, x, y, z);
        }
        if (logic instanceof HighOvenLogic) {
            ((HighOvenLogic)logic).setRSmode(world.func_72864_z(x, y, z));
        }
        if (logic instanceof HighOvenDuctLogic) {
            ((HighOvenDuctLogic)logic).setRedstoneActive(world.func_72864_z(x, y, z));
        }
    }

    public int func_71925_a(Random random) {
        return 1;
    }

    public void func_71862_a(World world, int x, int y, int z, Random random) {
        if (HighOvenBlock.isActive((IBlockAccess)world, x, y, z)) {
            TileEntity logic = world.func_72796_p(x, y, z);
            byte face = 0;
            if (logic instanceof IFacingLogic) {
                face = ((IFacingLogic)logic).getRenderDirection();
            }
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.5f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            switch (face) {
                case 4: {
                    world.func_72869_a("smoke", (double)(f - 0.52f), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f - 0.52f), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 5: {
                    world.func_72869_a("smoke", (double)(f + 0.52f), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + 0.52f), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - 0.52f), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - 0.52f), 0.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 + 0.52f), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + 0.52f), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void func_94332_a(IconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new Icon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tsteelworks:" + textureNames[i]);
        }
    }

    private void spawnHighGolem(World world, int x, int y, int z) {
        boolean check2;
        boolean check1 = world.func_72798_a(x, y - 1, z) == TContent.smeltery.field_71990_ca && world.func_72805_g(x, y - 1, z) > 1;
        boolean bl = check2 = world.func_72798_a(x, y - 2, z) == TContent.smeltery.field_71990_ca && world.func_72805_g(x, y - 2, z) > 1;
        if (check1 && check2 && !world.field_72995_K) {
            world.func_72832_d(x, y, z, 0, 0, 2);
            world.func_72832_d(x, y - 1, z, 0, 0, 2);
            world.func_72832_d(x, y - 2, z, 0, 0, 2);
            HighGolem entityhighgolem = new HighGolem(world);
            entityhighgolem.func_70012_b((double)x + 0.5, (double)y - 1.95, (double)z + 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)entityhighgolem);
            world.func_72851_f(x, y, z, 0);
            world.func_72851_f(x, y - 1, z, 0);
            world.func_72851_f(x, y - 2, z, 0);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
            for (int l = 0; l < 120; ++l) {
                TSteelworks.proxy.spawnParticle("scorchedbrick", (double)x + world.field_73012_v.nextDouble(), (double)(y - 2) + world.field_73012_v.nextDouble() * 2.5, (double)z + world.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    boolean activeRedstone(World world, int x, int y, int z) {
        Block wire = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (wire != null && wire.field_71990_ca == Block.field_72075_av.field_71990_ca) {
            return world.func_72805_g(x, y, z) > 0;
        }
        return false;
    }

    static {
        directions.add(new CoordTuple(0, -1, 0));
        directions.add(new CoordTuple(0, 1, 0));
        directions.add(new CoordTuple(0, 0, -1));
        directions.add(new CoordTuple(0, 0, 1));
        directions.add(new CoordTuple(-1, 0, 0));
        directions.add(new CoordTuple(1, 0, 0));
    }
}

