/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.IRandomDisplayTick;
import codechicken.multipart.minecraft.McBlockPart;
import codechicken.multipart.minecraft.McSidedMetaPart;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;

public class TorchPart
extends McSidedMetaPart
implements IRandomDisplayTick {
    public static arg torch = (arg)aqz.av;
    public static int[] metaSideMap = new int[]{-1, 4, 5, 2, 3, 0};
    public static int[] sideMetaMap = new int[]{5, 0, 3, 4, 1, 2};

    public TorchPart() {
    }

    public TorchPart(int meta) {
        super(meta);
    }

    @Override
    public aqz getBlock() {
        return torch;
    }

    @Override
    public String getType() {
        return "mc_torch";
    }

    @Override
    public Cuboid6 getBounds() {
        return this.getBounds(this.meta);
    }

    public Cuboid6 getBounds(int meta) {
        double d = 0.15;
        if (meta == 1) {
            return new Cuboid6(0.0, 0.2, 0.5 - d, d * 2.0, 0.8, 0.5 + d);
        }
        if (meta == 2) {
            return new Cuboid6(1.0 - d * 2.0, 0.2, 0.5 - d, 1.0, 0.8, 0.5 + d);
        }
        if (meta == 3) {
            return new Cuboid6(0.5 - d, 0.2, 0.0, 0.5 + d, 0.8, d * 2.0);
        }
        if (meta == 4) {
            return new Cuboid6(0.5 - d, 0.2, 1.0 - d * 2.0, 0.5 + d, 0.8, 1.0);
        }
        d = 0.1;
        return new Cuboid6(0.5 - d, 0.0, 0.5 - d, 0.5 + d, 0.6, 0.5 + d);
    }

    @Override
    public int sideForMeta(int meta) {
        return metaSideMap[meta];
    }

    @Override
    public boolean canStay() {
        aqz block;
        if (this.sideForMeta(this.meta) == 0 && (block = aqz.s[this.world().a(this.x(), this.y() - 1, this.z())]) != null && block.canPlaceTorchOnTop(this.world(), this.x(), this.y() - 1, this.z())) {
            return true;
        }
        return super.canStay();
    }

    public static McBlockPart placement(abw world, BlockCoord pos, int side) {
        if (side == 0) {
            return null;
        }
        pos = pos.copy().offset(side ^ 1);
        if (!world.isBlockSolidOnSide(pos.x, pos.y, pos.z, ForgeDirection.getOrientation((int)side))) {
            if (side == 1) {
                aqz block = aqz.s[world.a(pos.x, pos.y, pos.z)];
                if (block == null || !block.canPlaceTorchOnTop(world, pos.x, pos.y, pos.z)) {
                    return null;
                }
            } else {
                return null;
            }
        }
        return new TorchPart(sideMetaMap[side ^ 1]);
    }

    @Override
    public void randomDisplayTick(Random random) {
        double d0 = (double)this.x() + 0.5;
        double d1 = (double)this.y() + 0.7;
        double d2 = (double)this.z() + 0.5;
        double d3 = 0.22;
        double d4 = 0.27;
        abw world = this.world();
        if (this.meta == 1) {
            world.a("smoke", d0 - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            world.a("flame", d0 - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
        } else if (this.meta == 2) {
            world.a("smoke", d0 + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            world.a("flame", d0 + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
        } else if (this.meta == 3) {
            world.a("smoke", d0, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
            world.a("flame", d0, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
        } else if (this.meta == 4) {
            world.a("smoke", d0, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
            world.a("flame", d0, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
        } else {
            world.a("smoke", d0, d1, d2, 0.0, 0.0, 0.0);
            world.a("flame", d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

