/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.blocks.tileentities;

import exnihilo.data.BlockData;
import exnihilo.registries.CrucibleRegistry;
import exnihilo.registries.HeatRegistry;
import exnihilo.registries.helpers.Meltable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityCrucible
extends TileEntity
implements IFluidHandler,
ISidedInventory {
    private static final float MIN_RENDER_CAPACITY = 0.2f;
    private static final float MAX_RENDER_CAPACITY = 0.95f;
    private static final int MAX_FLUID = 10000;
    private static final int UPDATE_INTERVAL = 10;
    private boolean needsUpdate = false;
    private int updateTimer = 0;
    public FluidStack fluid;
    private int contentID = 0;
    private int contentMeta = 0;
    private float solidVolume = 0.0f;
    private float airVolume = 0.0f;
    private float fluidVolume = 0.0f;
    public CrucibleMode mode = CrucibleMode.EMPTY;

    public TileEntityCrucible() {
        this.fluid = new FluidStack(FluidRegistry.WATER, 0);
    }

    public float getAdjustedVolume() {
        float volume = (this.solidVolume + this.fluidVolume + this.airVolume) / 10000.0f;
        float capacity = 0.75f;
        float adjusted = volume * capacity;
        return adjusted += 0.2f;
    }

    public Icon getContentIcon() {
        if (this.field_70331_k.field_72995_K) {
            Meltable meltable = CrucibleRegistry.getItem(this.contentID, this.contentMeta);
            if (meltable != null && meltable.getIcon() != null) {
                return meltable.getIcon();
            }
            return Block.field_71981_t.func_71858_a(0, 0);
        }
        return null;
    }

    public void func_70307_a(NBTTagCompound compound) {
        super.func_70307_a(compound);
        switch (compound.func_74762_e("mode")) {
            case 0: {
                this.mode = CrucibleMode.EMPTY;
                break;
            }
            case 1: {
                this.mode = CrucibleMode.USED;
            }
        }
        this.solidVolume = compound.func_74760_g("solidVolume");
        this.fluidVolume = compound.func_74760_g("fluidVolume");
        this.airVolume = compound.func_74760_g("airVolume");
        this.contentID = compound.func_74762_e("contentID");
        this.contentMeta = compound.func_74762_e("contentMeta");
        this.fluid = new FluidStack(FluidRegistry.getFluid((int)compound.func_74765_d("fluid")), Math.round(this.fluidVolume));
    }

    public void func_70310_b(NBTTagCompound compound) {
        super.func_70310_b(compound);
        compound.func_74768_a("mode", this.mode.value);
        compound.func_74776_a("solidVolume", this.solidVolume);
        compound.func_74776_a("fluidVolume", this.fluidVolume);
        compound.func_74776_a("airVolume", this.airVolume);
        compound.func_74768_a("contentID", this.contentID);
        compound.func_74768_a("contentMeta", this.contentMeta);
        compound.func_74777_a("fluid", (short)this.fluid.fluidID);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, BlockData.SIEVE_ID, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        NBTTagCompound tag = pkt.field_73331_e;
        this.func_70307_a(tag);
    }

    public boolean addItem(ItemStack item) {
        if (!CrucibleRegistry.containsItem(item.field_77993_c, item.func_77960_j())) {
            return false;
        }
        Meltable meltable = CrucibleRegistry.getItem(item.field_77993_c, item.func_77960_j());
        if (!this.field_70331_k.field_72995_K && this.getCapacity() >= meltable.solidVolume && this.isFluidValid(meltable.fluid)) {
            this.contentID = item.field_77993_c;
            this.contentMeta = item.func_77960_j();
            this.solidVolume += meltable.fluidVolume;
            this.airVolume += meltable.solidVolume - meltable.fluidVolume;
        } else {
            return false;
        }
        this.mode = CrucibleMode.USED;
        this.fluid = new FluidStack(meltable.fluid.getID(), (int)this.fluidVolume);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public void func_70316_g() {
        float speed = this.getMeltSpeed();
        if (this.airVolume > 0.0f) {
            this.airVolume -= this.airVolume * (speed / this.solidVolume);
            if (this.airVolume < 0.0f) {
                this.airVolume = 0.0f;
            }
        }
        if (this.solidVolume > 0.0f) {
            if (this.solidVolume - speed >= 0.0f) {
                this.fluidVolume += speed;
                this.solidVolume -= speed;
            } else {
                this.fluidVolume += this.solidVolume;
                this.solidVolume = 0.0f;
            }
            this.fluid.amount = Math.round(this.fluidVolume);
            this.needsUpdate = true;
        } else if (Math.round(this.getCapacity()) >= 10000) {
            this.mode = CrucibleMode.EMPTY;
            this.needsUpdate = true;
        }
        if (this.updateTimer >= 10) {
            this.updateTimer = 0;
            if (this.needsUpdate) {
                this.needsUpdate = false;
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        } else {
            ++this.updateTimer;
        }
    }

    public float getCapacity() {
        return 10000.0f - (this.solidVolume + this.fluidVolume + this.airVolume);
    }

    public float getMeltSpeed() {
        int targetMeta;
        int targetID = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        if (HeatRegistry.containsItem(targetID, targetMeta = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n))) {
            return HeatRegistry.getItem((int)targetID, (int)targetMeta).value;
        }
        return 0.0f;
    }

    public boolean hasSolids() {
        return this.solidVolume > 0.0f;
    }

    public boolean renderFluid() {
        return this.solidVolume < this.fluidVolume && this.fluid.getFluid().getID() != FluidRegistry.WATER.getID();
    }

    private boolean isFluidValid(Fluid fluid) {
        if (this.mode == CrucibleMode.EMPTY) {
            return true;
        }
        return this.mode == CrucibleMode.USED && fluid.getID() == this.fluid.fluidID;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int capacity = (int)this.getCapacity();
        if (!doFill) {
            if (this.mode == CrucibleMode.EMPTY) {
                return resource.amount;
            }
            if (this.mode == CrucibleMode.USED && resource.fluidID == this.fluid.fluidID) {
                if (capacity >= resource.amount) {
                    return resource.amount;
                }
                return capacity;
            }
        } else {
            if (this.mode == CrucibleMode.EMPTY) {
                if (resource.fluidID != this.fluid.fluidID) {
                    this.fluid = new FluidStack(FluidRegistry.getFluid((int)resource.fluidID), resource.amount);
                } else {
                    this.fluid.amount = resource.amount;
                }
                this.mode = CrucibleMode.USED;
                this.fluidVolume += (float)this.fluid.amount;
                this.needsUpdate = true;
                return resource.amount;
            }
            if (this.mode == CrucibleMode.USED && resource.fluidID == this.fluid.fluidID) {
                if (capacity >= resource.amount) {
                    this.fluidVolume += (float)resource.amount;
                    this.fluid.amount = (int)this.fluidVolume;
                    this.needsUpdate = true;
                    return resource.amount;
                }
                this.fluidVolume += (float)capacity;
                this.fluid.amount = (int)this.fluidVolume;
                this.needsUpdate = true;
                return capacity;
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || this.mode != CrucibleMode.USED || !resource.isFluidEqual(this.fluid)) {
            return null;
        }
        if (!doDrain) {
            if (this.fluid.amount >= resource.amount) {
                FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)resource.fluidID), resource.amount);
                return simulated;
            }
            FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)resource.fluidID), this.fluid.amount);
            return simulated;
        }
        if (this.fluid.amount > resource.amount) {
            FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)resource.fluidID), resource.amount);
            this.fluidVolume -= (float)resource.amount;
            this.fluid.amount = (int)this.fluidVolume;
            this.needsUpdate = true;
            return drained;
        }
        FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)resource.fluidID), this.fluid.amount);
        this.fluidVolume -= (float)this.fluid.amount;
        this.fluid.amount = 0;
        this.needsUpdate = true;
        return drained;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.mode != CrucibleMode.USED) {
            return null;
        }
        if (!doDrain) {
            if (this.fluid.amount >= maxDrain) {
                FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)this.fluid.fluidID), maxDrain);
                return simulated;
            }
            FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)this.fluid.fluidID), this.fluid.amount);
            return simulated;
        }
        if (this.fluid.amount > maxDrain) {
            FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)this.fluid.fluidID), maxDrain);
            this.fluidVolume -= (float)maxDrain;
            this.fluid.amount = (int)this.fluidVolume;
            this.needsUpdate = true;
            return drained;
        }
        FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)this.fluid.fluidID), this.fluid.amount);
        this.fluidVolume -= (float)this.fluid.amount;
        this.fluid.amount = 0;
        this.needsUpdate = true;
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo info = new FluidTankInfo(this.fluid, 10000);
        FluidTankInfo[] array = new FluidTankInfo[]{info};
        return array;
    }

    public int getLightLevel() {
        if (this.mode == CrucibleMode.USED) {
            float lumens = (float)this.fluid.getFluid().getLuminosity() * (this.fluidVolume / 10000.0f);
            return Math.round(lumens);
        }
        return 0;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        if (slot == 1 && CrucibleRegistry.containsItem(item.field_77993_c, item.func_77960_j())) {
            Meltable meltable = CrucibleRegistry.getItem(item.field_77993_c, item.func_77960_j());
            if (this.getCapacity() >= meltable.solidVolume && this.isFluidValid(meltable.fluid)) {
                this.addItem(item);
            }
        }
    }

    public String func_70303_b() {
        return null;
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (slot == 1 && CrucibleRegistry.containsItem(item.field_77993_c, item.func_77960_j())) {
            Meltable meltable = CrucibleRegistry.getItem(item.field_77993_c, item.func_77960_j());
            if (this.getCapacity() >= meltable.solidVolume && this.isFluidValid(meltable.fluid)) {
                return true;
            }
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        if (side == 1) {
            return new int[]{1};
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        if (side == 1 && slot == 1 && CrucibleRegistry.containsItem(item.field_77993_c, item.func_77960_j())) {
            Meltable meltable = CrucibleRegistry.getItem(item.field_77993_c, item.func_77960_j());
            if (this.getCapacity() >= meltable.solidVolume && this.isFluidValid(meltable.fluid)) {
                return true;
            }
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return false;
    }

    public static enum CrucibleMode {
        EMPTY(0),
        USED(1);

        public int value;

        private CrucibleMode(int v) {
            this.value = v;
        }
    }
}

