/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.blocks.renderers;

import exnihilo.blocks.models.ModelCrucible;
import exnihilo.blocks.models.ModelCrucibleInternal;
import exnihilo.blocks.tileentities.TileEntityCrucible;
import exnihilo.registries.ColorRegistry;
import exnihilo.registries.helpers.Color;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class RenderCrucible
extends TileEntitySpecialRenderer {
    private ModelCrucible model;
    private ModelCrucibleInternal internal;

    public RenderCrucible(ModelCrucible model) {
        this.model = model;
        this.internal = new ModelCrucibleInternal();
    }

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float f) {
        this.drawCrucible(tileentity, x, y, z, f);
        this.drawContents(tileentity, x, y, z, f);
    }

    private void drawCrucible(TileEntity tileentity, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.bindCrucibleTexture();
        this.model.simpleRender(0.0625f);
        GL11.glPopMatrix();
    }

    private void drawContents(TileEntity tileentity, double x, double y, double z, float f) {
        TileEntityCrucible crucible = (TileEntityCrucible)tileentity;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + crucible.getAdjustedVolume()), (float)((float)z + 0.5f));
        GL11.glScalef((float)0.92f, (float)1.0f, (float)0.92f);
        this.bindInternalTexture();
        if (crucible.hasSolids() && !crucible.renderFluid()) {
            this.renderSolid(tileentity);
        } else {
            switch (crucible.mode) {
                case EMPTY: {
                    break;
                }
                case USED: {
                    this.renderFluid(tileentity);
                    break;
                }
            }
        }
        GL11.glPopMatrix();
    }

    private void renderSolid(TileEntity tileentity) {
        TileEntityCrucible crucible = (TileEntityCrucible)tileentity;
        Icon icon = crucible.getContentIcon();
        Color color = ColorRegistry.color("white");
        this.internal.render(color, icon, false);
    }

    private void renderFluid(TileEntity tileentity) {
        TileEntityCrucible crucible = (TileEntityCrucible)tileentity;
        Fluid content = crucible.fluid.getFluid();
        Icon icon = content.getIcon();
        Color color = new Color(content.getColor());
        this.internal.render(color, icon, true);
    }

    public void bindCrucibleTexture() {
        this.func_110628_a(ModelCrucible.textures[0]);
    }

    public void bindInternalTexture() {
        ResourceLocation fluidTexture = TextureMap.field_110575_b;
        this.func_110628_a(fluidTexture);
    }
}

