/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMod;

public class ModRepair
extends ToolMod {
    public ModRepair() {
        super(new ItemStack[0], 0, "");
    }

    @Override
    public boolean matches(ItemStack[] input, ItemStack tool) {
        return this.canModify(tool, input);
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74762_e("Damage") > 0) {
            int headID = tags.func_74762_e("Head");
            boolean areInputsValid = true;
            for (ItemStack curInput : input) {
                if (curInput == null || headID == PatternBuilder.instance.getPartID(curInput)) continue;
                areInputsValid = false;
                break;
            }
            if (areInputsValid) {
                return this.calculateIfNecessary(tool, input);
            }
        }
        return false;
    }

    private boolean calculateIfNecessary(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        int damage = tags.func_74762_e("Damage");
        int numInputs = 0;
        int materialValue = 0;
        for (ItemStack curInput : input) {
            if (curInput == null) continue;
            materialValue += PatternBuilder.instance.getPartValue(curInput);
            ++numInputs;
        }
        if (numInputs == 0) {
            return false;
        }
        int totalRepairValue = this.calculateIncrease(tool, materialValue, numInputs);
        float averageRepairValue = totalRepairValue / numInputs;
        return numInputs == 1 || (float)(damage - totalRepairValue) >= -averageRepairValue;
    }

    private int calculateIncrease(ItemStack tool, int materialValue, int itemsUsed) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        int damage = tags.func_74762_e("Damage");
        int dur = tags.func_74762_e("BaseDurability");
        int increase = (int)((float)(50 * itemsUsed) + (float)dur * 0.4f * (float)materialValue);
        int modifiers = tags.func_74762_e("Modifiers");
        float mods = 1.0f;
        if (modifiers == 2) {
            mods = 0.9f;
        } else if (modifiers == 1) {
            mods = 0.8f;
        } else if (modifiers == 0) {
            mods = 0.7f;
        }
        increase = (int)((float)increase * mods);
        int repair = tags.func_74762_e("RepairCount");
        float repairCount = (float)(100 - repair) / 100.0f;
        if (repairCount < 0.5f) {
            repairCount = 0.5f;
        }
        increase = (int)((float)increase * repairCount);
        increase = (int)((float)increase / ((ToolCore)tool.func_77973_b()).getRepairCost());
        return increase;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        tags.func_74757_a("Broken", false);
        int damage = tags.func_74762_e("Damage");
        int dur = tags.func_74762_e("BaseDurability");
        int itemsUsed = 0;
        int materialValue = 0;
        for (ItemStack curInput : input) {
            if (curInput == null) continue;
            materialValue += PatternBuilder.instance.getPartValue(curInput);
            ++itemsUsed;
        }
        int increase = this.calculateIncrease(tool, materialValue, itemsUsed);
        int repair = tags.func_74762_e("RepairCount");
        tags.func_74768_a("RepairCount", repair += itemsUsed);
        if ((damage -= increase) < 0) {
            damage = 0;
        }
        tags.func_74768_a("Damage", damage);
        AbilityHelper.damageTool(tool, 0, null, true);
    }

    @Override
    public void addMatchingEffect(ItemStack tool) {
    }
}

