/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.armor;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tconstruct.library.armor.ArmorCore;
import tconstruct.library.armor.ArmorModTypeFilter;
import tconstruct.library.armor.EnumArmorPart;

public class AModMoveSpeed
extends ArmorModTypeFilter {
    final boolean modifierType;
    private static final UUID head = UUID.fromString("2ba6c8ae-4a19-49c6-aab4-ca3a5eb7c730");
    private static final UUID chest = UUID.fromString("2ba6c8ae-4a19-49c6-aab4-ca3a5eb7c731");
    private static final UUID pants = UUID.fromString("2ba6c8ae-4a19-49c6-aab4-ca3a5eb7c732");
    private static final UUID shoes = UUID.fromString("2ba6c8ae-4a19-49c6-aab4-ca3a5eb7c733");

    public AModMoveSpeed(int effect, EnumSet<EnumArmorPart> armorTypes, ItemStack[] items, int[] values, boolean type) {
        super(effect, "ExoSpeed" + (type ? "Percent" : "Flat"), armorTypes, items, values);
        this.modifierType = type;
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l(this.getTagName());
        int amount = this.matchingAmount(input);
        return tags.func_74762_e("Modifiers") >= amount;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack armor) {
        NBTTagList attributes;
        NBTTagCompound baseTag = armor.func_77978_p();
        NBTTagCompound armorTag = armor.func_77978_p().func_74775_l(this.getTagName());
        int modifiers = armorTag.func_74762_e("Modifiers");
        armorTag.func_74768_a("Modifiers", modifiers -= this.matchingAmount(input));
        int amount = this.matchingAmount(input);
        if (armorTag.func_74764_b(this.key)) {
            amount += armorTag.func_74762_e(this.key);
        }
        armorTag.func_74768_a(this.key, amount);
        if (baseTag.func_74764_b("AttributeModifiers")) {
            attributes = baseTag.func_74761_m("AttributeModifiers");
            for (int iter = 0; iter < attributes.func_74745_c(); ++iter) {
                NBTTagCompound tag = (NBTTagCompound)attributes.func_74743_b(iter);
                if (!tag.func_74779_i("AttributeName").equals("generic.movementSpeed")) continue;
                attributes.func_74744_a(iter);
            }
        } else {
            attributes = new NBTTagList();
            baseTag.func_74782_a("AttributeModifiers", (NBTBase)attributes);
        }
        attributes.func_74742_a((NBTBase)AModMoveSpeed.getAttributeTag("generic.movementSpeed", this.key, (double)amount / 100.0, this.modifierType, this.getUUIDFromItem(armor)));
    }

    UUID getUUIDFromItem(ItemStack stack) {
        ArmorCore item = (ArmorCore)stack.func_77973_b();
        switch (item.armorPart) {
            case HELMET: {
                return head;
            }
            case CHEST: {
                return chest;
            }
            case PANTS: {
                return pants;
            }
            case SHOES: {
                return shoes;
            }
        }
        return null;
    }
}

