/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolCore;

public abstract class HarvestTool
extends ToolCore {
    public HarvestTool(int itemID, int baseDamage) {
        super(itemID, baseDamage);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        World world = player.field_70170_p;
        int bID = player.field_70170_p.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        Block block = Block.field_71973_m[bID];
        if (block == null || bID < 1) {
            return false;
        }
        int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
        if (hlvl <= tags.func_74762_e("HarvestLevel")) {
            boolean cancelHarvest = false;
            for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                if (!mod.beforeBlockBreak(this, stack, x, y, z, (EntityLivingBase)player)) continue;
                cancelHarvest = true;
            }
            return cancelHarvest;
        }
        world.func_94571_i(x, y, z);
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_77660_a(stack, world, bID, x, y, z, (EntityLivingBase)player);
        }
        if (!world.field_72995_K) {
            world.func_72926_e(2001, x, y, z, bID + (meta << 12));
        }
        return true;
    }

    @Override
    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        if (!stack.func_77942_o()) {
            return 1.0f;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Broken")) {
            return 0.1f;
        }
        Material[] materials = this.getEffectiveMaterials();
        for (int i = 0; i < materials.length; ++i) {
            if (materials[i] != block.field_72018_cp) continue;
            return this.calculateStrength(tags, block, meta);
        }
        if (MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType()) > 0) {
            return this.calculateStrength(tags, block, meta);
        }
        return super.getStrVsBlock(stack, block, meta);
    }

    float calculateStrength(NBTTagCompound tags, Block block, int meta) {
        float mineSpeed = tags.func_74762_e("MiningSpeed");
        int heads = 1;
        if (tags.func_74764_b("MiningSpeed2")) {
            mineSpeed += (float)tags.func_74762_e("MiningSpeed2");
            ++heads;
        }
        if (tags.func_74764_b("MiningSpeedHandle")) {
            mineSpeed += (float)tags.func_74762_e("MiningSpeedHandle");
            ++heads;
        }
        if (tags.func_74764_b("MiningSpeedExtra")) {
            mineSpeed += (float)tags.func_74762_e("MiningSpeedExtra");
            ++heads;
        }
        float trueSpeed = mineSpeed / ((float)heads * 100.0f) * this.breakSpeedModifier();
        int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
        int durability = tags.func_74762_e("Damage");
        float stonebound = tags.func_74760_g("Shoddy");
        float bonusLog = (float)Math.log((float)durability / this.stoneboundModifier() + 1.0f) * 2.0f * stonebound;
        trueSpeed += bonusLog;
        if (hlvl <= tags.func_74762_e("HarvestLevel")) {
            return trueSpeed;
        }
        return 0.1f;
    }

    public float breakSpeedModifier() {
        return 1.0f;
    }

    public float stoneboundModifier() {
        return 72.0f;
    }

    public boolean func_77641_a(Block block) {
        if (block.field_72018_cp.func_76229_l()) {
            return true;
        }
        for (Material m : this.getEffectiveMaterials()) {
            if (m != block.field_72018_cp) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] toolCategories() {
        return new String[]{"harvest"};
    }

    protected abstract Material[] getEffectiveMaterials();

    protected abstract String getHarvestType();

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        Item item;
        boolean used = false;
        int hotbarSlot = player.field_71071_by.field_70461_c;
        int itemSlot = hotbarSlot == 0 ? 8 : hotbarSlot + 1;
        ItemStack nearbyStack = null;
        if (hotbarSlot < 8 && (nearbyStack = player.field_71071_by.func_70301_a(itemSlot)) != null && (item = nearbyStack.func_77973_b()) instanceof ItemBlock) {
            int posX = x;
            int posY = y;
            int posZ = z;
            int playerPosX = (int)Math.floor(player.field_70165_t);
            int playerPosY = (int)Math.floor(player.field_70163_u);
            int playerPosZ = (int)Math.floor(player.field_70161_v);
            if (side == 0) {
                --posY;
            }
            if (side == 1) {
                ++posY;
            }
            if (side == 2) {
                --posZ;
            }
            if (side == 3) {
                ++posZ;
            }
            if (side == 4) {
                --posX;
            }
            if (side == 5) {
                ++posX;
            }
            if (posX == playerPosX && (posY == playerPosY || posY == playerPosY + 1 || posY == playerPosY - 1) && posZ == playerPosZ) {
                return false;
            }
            used = item.func_77648_a(nearbyStack, player, world, x, y, z, side, clickX, clickY, clickZ);
            if (nearbyStack.field_77994_a < 1) {
                nearbyStack = null;
                player.field_71071_by.func_70299_a(itemSlot, null);
            }
        }
        return used;
    }
}

