/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import tconstruct.common.TContent;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.Weapon;

public class Scythe
extends Weapon {
    static Material[] materials = new Material[]{Material.field_76232_D, Material.field_76268_x, Material.field_76266_z, Material.field_76254_j, Material.field_76255_k, Material.field_76257_i};

    public Scythe(int itemID) {
        super(itemID, 4);
        this.func_77655_b("InfiTool.Scythe");
    }

    @Override
    protected Material[] getEffectiveMaterials() {
        return materials;
    }

    @Override
    public Item getHeadItem() {
        return TContent.scytheBlade;
    }

    @Override
    public Item getHandleItem() {
        return TContent.toughRod;
    }

    @Override
    public Item getAccessoryItem() {
        return TContent.toughBinding;
    }

    @Override
    public Item getExtraItem() {
        return TContent.toughRod;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 10;
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_scythe_head";
            }
            case 1: {
                return "_scythe_head_broken";
            }
            case 2: {
                return "_scythe_handle";
            }
            case 3: {
                return "_scythe_binding";
            }
            case 4: {
                return "_scythe_accessory";
            }
        }
        return "";
    }

    @Override
    public float getDurabilityModifier() {
        return 3.0f;
    }

    @Override
    public float getRepairCost() {
        return 4.0f;
    }

    @Override
    public String getEffectSuffix() {
        return "_scythe_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "scythe";
    }

    @Override
    public int durabilityTypeAccessory() {
        return 1;
    }

    @Override
    public int durabilityTypeExtra() {
        return 1;
    }

    @Override
    public float getDamageModifier() {
        return 0.75f;
    }

    @Override
    public String[] toolCategories() {
        return new String[]{"weapon", "melee", "harvest"};
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            return false;
        }
        World world = player.field_70170_p;
        int blockID = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        boolean butter = EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)stack) > 0;
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y - 1; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    float localHardness;
                    if (tags.func_74767_n("Broken")) continue;
                    boolean cancelHarvest = false;
                    for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                        if (!mod.beforeBlockBreak(this, stack, xPos, yPos, zPos, (EntityLivingBase)player)) continue;
                        cancelHarvest = true;
                    }
                    if (cancelHarvest) continue;
                    int localblockID = world.func_72798_a(xPos, yPos, zPos);
                    Block localBlock = Block.field_71973_m[localblockID];
                    int localMeta = world.func_72805_g(xPos, yPos, zPos);
                    float f = localHardness = localBlock == null ? Float.MAX_VALUE : localBlock.func_71934_m(world, xPos, yPos, zPos);
                    if (localBlock == null) continue;
                    for (int iter = 0; iter < materials.length; ++iter) {
                        if (materials[iter] != localBlock.field_72018_cp) continue;
                        if (!player.field_71075_bZ.field_75098_d) {
                            if (butter && localBlock instanceof IShearable && ((IShearable)localBlock).isShearable(stack, player.field_70170_p, x, y, z)) {
                                ArrayList drops = ((IShearable)localBlock).onSheared(stack, player.field_70170_p, x, y, z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack));
                                Random rand = new Random();
                                if (!world.field_72995_K) {
                                    for (ItemStack dropStack : drops) {
                                        float f2 = 0.7f;
                                        double d = (double)(rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
                                        double d1 = (double)(rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
                                        double d2 = (double)(rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
                                        EntityItem entityitem = new EntityItem(player.field_70170_p, (double)xPos + d, (double)yPos + d1, (double)zPos + d2, dropStack);
                                        entityitem.field_70293_c = 10;
                                        player.field_70170_p.func_72838_d((Entity)entityitem);
                                    }
                                }
                                if (localHardness > 0.0f) {
                                    this.func_77660_a(stack, world, localblockID, xPos, yPos, zPos, (EntityLivingBase)player);
                                }
                                player.func_71064_a(StatList.field_75934_C[localblockID], 1);
                                world.func_94571_i(xPos, yPos, zPos);
                                continue;
                            }
                            if (localBlock.removeBlockByPlayer(world, player, xPos, yPos, zPos)) {
                                localBlock.func_71898_d(world, xPos, yPos, zPos, localMeta);
                            }
                            localBlock.func_71893_a(world, player, xPos, yPos, zPos, localMeta);
                            localBlock.func_71846_a(world, xPos, yPos, zPos, localMeta, player);
                            if (!(localHardness > 0.0f)) continue;
                            this.func_77660_a(stack, world, localblockID, xPos, yPos, zPos, (EntityLivingBase)player);
                            continue;
                        }
                        world.func_94571_i(xPos, yPos, zPos);
                    }
                }
            }
        }
        if (!world.field_72995_K) {
            world.func_72926_e(2001, x, y, z, blockID + (meta << 12));
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        AxisAlignedBB box = AxisAlignedBB.func_72332_a().func_72299_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70165_t + 1.0, entity.field_70163_u + 1.0, entity.field_70161_v + 1.0).func_72314_b(1.0, 1.0, 1.0);
        List list = player.field_70170_p.func_72839_b((Entity)player, box);
        for (Object o : list) {
            AbilityHelper.onLeftClickEntity(stack, (EntityLivingBase)player, (Entity)o, this);
        }
        return true;
    }
}

