/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.logic;

import java.lang.ref.WeakReference;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import tconstruct.blocks.logic.FurnaceLogic;
import tconstruct.blocks.logic.PatternChestLogic;
import tconstruct.blocks.logic.ToolStationLogic;
import tconstruct.inventory.CraftingStationContainer;
import tconstruct.library.blocks.InventoryLogic;

public class CraftingStationLogic
extends InventoryLogic
implements ISidedInventory {
    public WeakReference<IInventory> chest;
    public WeakReference<IInventory> doubleChest;
    public WeakReference<IInventory> patternChest;
    public WeakReference<IInventory> furnace;
    public boolean tinkerTable;
    public boolean stencilTable;

    public CraftingStationLogic() {
        super(17);
    }

    @Override
    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        this.chest = null;
        this.doubleChest = null;
        this.patternChest = null;
        this.furnace = null;
        this.tinkerTable = false;
        for (int yPos = y - 1; yPos <= y + 1; ++yPos) {
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    TileEntity tile = world.func_72796_p(xPos, yPos, zPos);
                    if (this.chest == null && tile instanceof TileEntityChest) {
                        this.chest = new WeakReference<TileEntity>(tile);
                        this.checkForChest(world, xPos + 1, yPos, zPos);
                        this.checkForChest(world, xPos - 1, yPos, zPos);
                        this.checkForChest(world, xPos, yPos, zPos + 1);
                        this.checkForChest(world, xPos, yPos, zPos - 1);
                        continue;
                    }
                    if (this.patternChest == null && tile instanceof PatternChestLogic) {
                        this.patternChest = new WeakReference<TileEntity>(tile);
                        continue;
                    }
                    if (this.furnace == null && (tile instanceof TileEntityFurnace || tile instanceof FurnaceLogic)) {
                        this.furnace = new WeakReference<TileEntity>(tile);
                        continue;
                    }
                    if (this.tinkerTable || !(tile instanceof ToolStationLogic)) continue;
                    this.tinkerTable = true;
                }
            }
        }
        return new CraftingStationContainer(inventoryplayer, this, x, y, z);
    }

    void checkForChest(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileEntityChest) {
            this.doubleChest = new WeakReference<TileEntity>(tile);
        }
    }

    @Override
    protected String getDefaultName() {
        return "crafters.CraftingStation";
    }

    @Override
    public boolean canDropInventorySlot(int slot) {
        return slot != 0;
    }

    @Override
    public ItemStack func_70298_a(int slot, int quantity) {
        if (slot == 0) {
            for (int i = 1; i < this.func_70302_i_(); ++i) {
                this.func_70298_a(i, 1);
            }
        }
        return super.func_70298_a(slot, quantity);
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return i != 0;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }
}

