/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.bdew.neiaddons.NEIAddons;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import org.apache.commons.lang3.StringUtils;

public class ClientHandler
implements IPacketHandler,
ITickHandler {
    public static Set<String> enabledCommands = new HashSet<String>();
    private WorldClient oldworld;

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && world != this.oldworld) {
            this.reset();
        }
    }

    private void reset() {
        NEIAddons.logInfo("World changed, resetting", new Object[0]);
        this.oldworld = Minecraft.func_71410_x().field_71441_e;
        enabledCommands.clear();
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public String getLabel() {
        return "NEI Addons";
    }

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        try {
            NBTTagCompound data = CompressedStreamTools.func_74792_a((byte[])packet.field_73629_c);
            String cmd = data.func_74779_i("cmd");
            if (cmd.equals("hello")) {
                this.reset();
                if (data.func_74775_l("data").func_74762_e("version") != 1) {
                    NEIAddons.logWarning("Client/Server version mismatch! client=%d server=%d", data.func_74775_l("data").func_74762_e("version"), 1);
                    return;
                }
                String cmds = data.func_74775_l("data").func_74779_i("commands");
                NEIAddons.logInfo("Available server commands: %s", cmds);
                enabledCommands.addAll(Arrays.asList(StringUtils.split((String)cmds, (char)';')));
            } else {
                NEIAddons.logWarning("Uknown packet from server: %s", cmd);
            }
        }
        catch (Throwable e) {
            NEIAddons.logWarning("Error handling packet from server", new Object[0]);
            e.printStackTrace();
        }
    }
}

