/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.wires;

import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import javax.annotation.Nullable;
import malte0811.industrialwires.IWConfig;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.items.ItemIC2Coil;
import malte0811.industrialwires.util.ConversionUtil;
import malte0811.industrialwires.wires.EnergyType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MixedWireType
extends WireType {
    public static final String IC2_TIN_CAT = "IC_TIN";
    public static final String IC2_COPPER_CAT = "IC_COPPER";
    public static final String IC2_GOLD_CAT = "IC_GOLD";
    public static final String IC2_HV_CAT = "IC_HV";
    public static final String IC2_GLASS_CAT = "IC_GLASS";
    private final int type;
    private final int[] ic2Colors = new int[]{10861767, 12351813, 16711539, 12179161, 0xF1F1F1};
    private final String[] ic2Names = new String[]{"ic2Tin", "ic2Copper", "ic2Gold", "ic2Hv", "ic2Glass", "ic2TinIns", "ic2CopperIns", "ic2GoldIns"};
    private final double[] ic2RenderDiameter = new double[]{0.03125, 0.03125, 0.046875, 0.0625, 0.0234375, 0.0625, 0.0625, 0.09375};
    public static final MixedWireType TIN = new MixedWireType(0);
    public static final MixedWireType COPPER_IC2 = new MixedWireType(1);
    public static final MixedWireType GOLD = new MixedWireType(2);
    public static final MixedWireType HV = new MixedWireType(3);
    public static final MixedWireType GLASS = new MixedWireType(4);
    public static final MixedWireType TIN_INSULATED = new MixedWireType(5);
    public static final MixedWireType COPPER_IC2_INSULATED = new MixedWireType(6);
    public static final MixedWireType GOLD_INSULATED = new MixedWireType(7);
    public static final MixedWireType[] ALL = new MixedWireType[]{TIN, COPPER_IC2, GOLD, HV, GLASS, TIN_INSULATED, COPPER_IC2_INSULATED, GOLD_INSULATED};

    public MixedWireType(int ordinal) {
        this.type = ordinal;
        WireApi.registerWireType((WireType)this);
    }

    public double getLossRatio() {
        double lossPerBlockIF = this.getLossRateEU() * ConversionUtil.ifPerEu();
        return lossPerBlockIF / (this.getIORate() * ConversionUtil.ifPerJoule());
    }

    public double getLossRateEU() {
        return IWConfig.euLossPerBlock[this.type % 5];
    }

    public int getTransferRate() {
        return (int)(this.getIORate() * (double)this.getFactor());
    }

    public double getIORate() {
        return IWConfig.ioRatesEU[this.type % 5] * ConversionUtil.joulesPerEu();
    }

    public int getColour(ImmersiveNetHandler.Connection connection) {
        return this.type < 5 ? this.ic2Colors[this.type] : 0x2C2C2C;
    }

    public double getSlack() {
        return this.type % 5 == 2 ? 1.03 : 1.005;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getIcon(ImmersiveNetHandler.Connection connection) {
        return iconDefaultWire;
    }

    public int getMaxLength() {
        return IWConfig.maxLengthPerConn[this.type % 5];
    }

    public ItemStack getWireCoil(ImmersiveNetHandler.Connection con) {
        ItemStack ret = this.getWireCoil();
        ItemIC2Coil.setLength(ret, con.length);
        return ret;
    }

    public ItemStack getWireCoil() {
        return new ItemStack((Item)IndustrialWires.coil, 1, this.type);
    }

    public String getUniqueName() {
        return this.ic2Names[this.type];
    }

    public double getRenderDiameter() {
        return this.ic2RenderDiameter[this.type];
    }

    public boolean isEnergyWire() {
        return true;
    }

    public boolean canCauseDamage() {
        return this.type < 4;
    }

    public double getDamageRadius() {
        if (this.type >= 4) {
            return 0.0;
        }
        return 0.075 * (double)(this.type + 1);
    }

    @Nullable
    public String getCategory() {
        switch (this.type % 5) {
            case 0: {
                return IC2_TIN_CAT;
            }
            case 1: {
                return IC2_COPPER_CAT;
            }
            case 2: {
                return IC2_GOLD_CAT;
            }
            case 3: {
                return IC2_HV_CAT;
            }
            case 4: {
                return IC2_GLASS_CAT;
            }
        }
        return null;
    }

    public int getFactor() {
        return this.type < 5 ? 8 : 4;
    }

    public boolean isHV() {
        return this == HV || this == GLASS;
    }

    public double getLoss(EnergyType energyType) {
        switch (energyType) {
            case FE_AC: {
                return this.getLossRatio();
            }
            case EU_DC: {
                return this.getLossRateEU();
            }
        }
        return 10.0;
    }
}

