/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.mech_mb;

import com.google.common.collect.ImmutableList;
import java.util.List;
import malte0811.industrialwires.IWConfig;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.converter.MechanicalMBBlockType;
import malte0811.industrialwires.mech_mb.MechEnergy;
import malte0811.industrialwires.mech_mb.MechPartEnergyIO;
import malte0811.industrialwires.mech_mb.Waveform;
import malte0811.industrialwires.util.LocalSidedWorld;
import malte0811.industrialwires.util.MBSideConfig;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class MechPartCommutator
extends MechPartEnergyIO {
    public static ItemStack originalStack = ItemStack.field_190927_a;
    private static final ResourceLocation KINETIC_GEN_KEY = new ResourceLocation("ic2", "kinetic_generator");
    private static final List<MBSideConfig.BlockFace> outputs = ImmutableList.of((Object)new MBSideConfig.BlockFace(BlockPos.field_177992_a, EnumFacing.UP));

    @Override
    protected Waveform transform(Waveform wf, MechEnergy e) {
        return wf.getCommutated(e.getSpeed(), this.has4Phases());
    }

    @Override
    protected double getTransformationLimit(MechEnergy me) {
        double s = me.getSpeed();
        if (s < 5.0) {
            return 0.0;
        }
        if (s < 10.0) {
            return this.ramp(5.0, 10.0, s);
        }
        return 1.0;
    }

    private double ramp(double min, double max, double pos) {
        double diff = max - min;
        if (max > min) {
            return MathHelper.func_151237_a((double)((pos - min) * (pos - min) * (1.0 / (diff * diff) - 2.0 / (diff * diff * diff) * (pos - max))), (double)0.0, (double)1.0);
        }
        double tmp = max;
        max = min;
        min = tmp;
        return MathHelper.func_151237_a((double)(1.0 + (pos - min) * (pos - min) * (-1.0 / ((diff *= -1.0) * diff) + 2.0 / (diff * diff * diff) * (pos - max))), (double)0.0, (double)1.0);
    }

    @Override
    public double getInertia() {
        return 50.0;
    }

    @Override
    public double getMaxSpeed() {
        return IWConfig.MechConversion.allowMBEU() ? 100.0 : -1.0;
    }

    @Override
    public ResourceLocation getRotatingBaseModel() {
        return new ResourceLocation("industrialwires", "block/mech_mb/shaft_comm.obj");
    }

    @Override
    public boolean canForm(LocalSidedWorld w) {
        if (!IWConfig.MechConversion.allowMBEU()) {
            return false;
        }
        TileEntity te = w.getTileEntity(BlockPos.field_177992_a);
        if (te != null) {
            ResourceLocation loc = TileEntity.func_190559_a(te.getClass());
            return loc != null && loc.equals((Object)KINETIC_GEN_KEY);
        }
        return false;
    }

    @Override
    public short getFormPattern(int offset) {
        return 16;
    }

    @Override
    public void breakOnFailure(MechEnergy energy) {
    }

    @Override
    public ItemStack getOriginalItem(BlockPos pos) {
        return pos.equals((Object)BlockPos.field_177992_a) ? originalStack : super.getOriginalItem(pos);
    }

    @Override
    public void disassemble() {
        super.disassemble();
        if (IndustrialWires.ic2TeBlock != null) {
            NBTTagCompound dummyNbt = new NBTTagCompound();
            dummyNbt.func_74778_a("id", KINETIC_GEN_KEY.toString());
            this.world.setBlockState(BlockPos.field_177992_a, IndustrialWires.ic2TeBlock.func_176223_P());
            this.world.setTileEntity(BlockPos.field_177992_a, TileEntity.func_190200_a((World)this.world.getWorld(), (NBTTagCompound)dummyNbt));
        }
    }

    @Override
    public MechanicalMBBlockType getType() {
        return MechanicalMBBlockType.SHAFT_COMMUTATOR;
    }

    @Override
    protected double getMaxBuffer() {
        return 2500.0;
    }

    @Override
    protected boolean has4Phases() {
        return false;
    }

    @Override
    public List<MBSideConfig.BlockFace> getEnergyConnections() {
        return outputs;
    }

    @Override
    public AxisAlignedBB getBoundingBox(BlockPos offsetPart) {
        return new AxisAlignedBB(0.0, 0.34375, 0.0, 1.0, 1.0, 1.0);
    }
}

