/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.client.gui.GuiPanelCreator;
import malte0811.industrialwires.controlpanel.ControlPanelNetwork;
import malte0811.industrialwires.controlpanel.IConfigurableComponent;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class RGBIndicator
extends PanelComponent
implements IConfigurableComponent {
    @Nonnull
    private ControlPanelNetwork.RSChannel[] input = new ControlPanelNetwork.RSChannel[]{ControlPanelNetwork.RSChannel.DEFAULT_CHANNEL, ControlPanelNetwork.RSChannel.DEFAULT_CHANNEL, ControlPanelNetwork.RSChannel.DEFAULT_CHANNEL};
    private int rgbState;
    private static final float size = 0.0625f;

    public RGBIndicator() {
        super("rgb_led");
    }

    public RGBIndicator(@Nonnull ControlPanelNetwork.RSChannel[] input) {
        this();
        this.input = input;
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound nbt, boolean toItem) {
        NBTTagList channels = new NBTTagList();
        for (ControlPanelNetwork.RSChannel c : this.input) {
            NBTTagCompound ch = new NBTTagCompound();
            ch.func_74768_a("rsId", c.getController());
            ch.func_74774_a("rsChannel", c.getColor());
            channels.func_74742_a((NBTBase)ch);
        }
        nbt.func_74782_a("channels", (NBTBase)channels);
        if (!toItem) {
            nbt.func_74768_a("rgb", this.rgbState);
        }
    }

    @Override
    protected void readCustomNBT(NBTTagCompound nbt) {
        NBTTagList channels = nbt.func_150295_c("channels", 10);
        if (channels.func_74745_c() == 3) {
            ControlPanelNetwork.RSChannel[] in = new ControlPanelNetwork.RSChannel[channels.func_74745_c()];
            for (int i = 0; i < in.length; ++i) {
                NBTTagCompound ch = channels.func_150305_b(i);
                int rsController = ch.func_74762_e("rsId");
                byte rsColor = ch.func_74771_c("rsChannel");
                in[i] = new ControlPanelNetwork.RSChannel(rsController, rsColor);
            }
            this.input = in;
        }
        this.rgbState = nbt.func_74762_e("rgb");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<RawQuad> getQuads() {
        float[] color = new float[4];
        color[3] = 1.0f;
        for (int i = 0; i < 3; ++i) {
            color[i] = (float)(this.rgbState >> i * 8 & 0xFF) / 255.0f;
        }
        ArrayList<RawQuad> ret = new ArrayList<RawQuad>(1);
        PanelUtils.addColoredQuad(ret, new Vector3f(), new Vector3f(0.0f, 0.0f, 0.0625f), new Vector3f(0.0625f, 0.0f, 0.0625f), new Vector3f(0.0625f, 0.0f, 0.0f), EnumFacing.UP, color);
        if (this.rgbState > 0) {
            ((RawQuad)ret.get((int)(ret.size() - 1))).light = 1044735;
        }
        return ret;
    }

    @Override
    @Nonnull
    public PanelComponent copyOf() {
        RGBIndicator ret = new RGBIndicator(Arrays.copyOf(this.input, this.input.length));
        ret.rgbState = this.rgbState;
        ret.setX(this.x);
        ret.setY(this.y);
        ret.panelHeight = this.panelHeight;
        return ret;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBlockRelativeAABB() {
        if (this.aabb == null) {
            this.aabb = new AxisAlignedBB((double)this.x, 0.0, (double)this.y, (double)(this.x + 0.0625f), 0.0, (double)(this.y + 0.0625f));
        }
        return this.aabb;
    }

    @Override
    public void interactWith(Vec3d hitRelative, EntityPlayerMP player) {
    }

    @Override
    public void update() {
    }

    @Override
    public void setNetwork(ControlPanelNetwork net) {
        super.setNetwork(net);
        for (int i = 0; i < this.input.length; ++i) {
            int finalI = i;
            net.addListener(this, state -> {
                byte currState = (byte)(this.rgbState >> 8 * finalI + 4 & 0xF);
                if (state.getStrength() != currState) {
                    this.rgbState &= ~(255 << 8 * finalI);
                    this.rgbState |= state.getStrength() << 8 * finalI + 4;
                    this.panel.func_70296_d();
                    this.panel.triggerRenderUpdate();
                }
            }, this.input[i]);
        }
    }

    @Override
    public float getHeight() {
        return 0.0f;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RGBIndicator that = (RGBIndicator)o;
        return this.rgbState == that.rgbState;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.rgbState;
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInGUI(GuiPanelCreator gui) {
        AxisAlignedBB aabb = this.getBlockRelativeAABB();
        int left = (int)((double)gui.getX0() + aabb.field_72340_a * (double)gui.panelSize);
        int top = (int)((double)gui.getY0() + aabb.field_72339_c * (double)gui.panelSize);
        int right = (int)((double)gui.getX0() + aabb.field_72336_d * (double)gui.panelSize);
        int bottom = (int)((double)gui.getY0() + aabb.field_72334_f * (double)gui.panelSize);
        int width = right - left;
        int height = bottom - top;
        for (int colorId = 0; colorId < 3; ++colorId) {
            int color = 255 << colorId * 8 | 0xFF000000;
            for (int row = 0; row < 3; ++row) {
                int col = (row * (row + 1) + colorId) % 3;
                Gui.func_73734_a((int)Math.round((float)left + (float)(width * col) / 3.0f), (int)Math.round((float)top + (float)(height * row) / 3.0f), (int)Math.round((float)left + (float)(width * (col + 1)) / 3.0f), (int)Math.round((float)top + (float)(height * (row + 1)) / 3.0f), (int)color);
            }
        }
    }

    @Override
    public void applyConfigOption(IConfigurableComponent.ConfigType type, int id, NBTBase value) {
        switch (type) {
            case RS_CHANNEL: {
                this.input[id] = this.input[id].withColor(value);
                break;
            }
            case INT: {
                this.input[id] = this.input[id].withController(value);
            }
        }
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigName(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case FLOAT: {
                return I18n.func_135052_a((String)("industrialwires.desc." + (id == 0 ? "red" : (id == 1 ? "green" : "blue"))), (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigDescription(IConfigurableComponent.ConfigType type, int id) {
        String color = null;
        switch (id) {
            case 0: {
                color = "red";
                break;
            }
            case 1: {
                color = "green";
                break;
            }
            case 2: {
                color = "blue";
            }
        }
        switch (type) {
            case FLOAT: {
                return null;
            }
            case RS_CHANNEL: {
                return I18n.func_135052_a((String)("industrialwires.desc.rschannel_" + color), (Object[])new Object[0]);
            }
            case INT: {
                return I18n.func_135052_a((String)("industrialwires.desc.rsid_" + color), (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    public IConfigurableComponent.RSColorConfig[] getRSChannelOptions() {
        return new IConfigurableComponent.RSColorConfig[]{new IConfigurableComponent.RSColorConfig("channelR", 0, 10, this.input[0].getColor()), new IConfigurableComponent.RSColorConfig("channelG", 50, 10, this.input[1].getColor()), new IConfigurableComponent.RSColorConfig("channelB", 0, 70, this.input[2].getColor())};
    }

    @Override
    public IConfigurableComponent.IntConfig[] getIntegerOptions() {
        return new IConfigurableComponent.IntConfig[]{new IConfigurableComponent.IntConfig("rsIdR", 0, 0, this.input[0].getController(), 2, false), new IConfigurableComponent.IntConfig("rsIdG", 50, 0, this.input[1].getController(), 2, false), new IConfigurableComponent.IntConfig("rsIdB", 0, 60, this.input[2].getController(), 2, false)};
    }

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }
}

