/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.client.gui.GuiPanelCreator;
import malte0811.industrialwires.controlpanel.ControlPanelNetwork;
import malte0811.industrialwires.controlpanel.IConfigurableComponent;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import malte0811.industrialwires.items.ItemKey;
import net.minecraft.block.Block;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class Lock
extends PanelComponent
implements IConfigurableComponent {
    private static final Random rand = new Random();
    @Nullable
    private NBTTagCompound keyNBT;
    private boolean turned;
    private boolean latching = false;
    @Nonnull
    private ControlPanelNetwork.RSChannel outputChannel = ControlPanelNetwork.RSChannel.DEFAULT_CHANNEL;
    private int ticksTillOff;
    private int lockID;
    private static final float size = 0.0625f;
    private static final float keyWidth = 0.0078125f;
    private static final float yOffset = 0.03225f;
    private static final float xOffset = 0.02734375f;
    private static final float[] DARK_GRAY = new float[]{0.4f, 0.4f, 0.4f};
    private static final int DARK_GRAY_INT = -9934744;
    private static final float zOffset = 0.00390625f;
    private static final float keyOffset = 0.0078125f;
    private static final float zOffsetLowerKey = 0.015625f;

    public Lock() {
        super("lock");
        while (this.lockID == 0) {
            this.lockID = rand.nextInt();
        }
    }

    public Lock(boolean latching, @Nonnull ControlPanelNetwork.RSChannel out) {
        this();
        this.latching = latching;
        this.outputChannel = out;
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound nbt, boolean toItem) {
        if (!toItem) {
            nbt.func_74768_a("timeout", this.ticksTillOff);
            nbt.func_74757_a("turned", this.turned);
            if (this.keyNBT != null) {
                nbt.func_74782_a("key", (NBTBase)this.keyNBT);
            }
        }
        nbt.func_74768_a("lockId", this.lockID);
        nbt.func_74757_a("latching", this.latching);
        nbt.func_74774_a("rsChannel", this.outputChannel.getColor());
        nbt.func_74768_a("rsId", this.outputChannel.getController());
    }

    @Override
    protected void readCustomNBT(NBTTagCompound nbt) {
        this.ticksTillOff = nbt.func_74762_e("timeout");
        this.keyNBT = nbt.func_150297_b("key", 10) ? nbt.func_74775_l("key") : null;
        this.turned = nbt.func_74767_n("turned");
        if (nbt.func_74764_b("lockId")) {
            this.lockID = nbt.func_74762_e("lockId");
        }
        this.latching = nbt.func_74767_n("latching");
        int rsController = nbt.func_74762_e("rsChannel");
        byte rsColor = nbt.func_74771_c("rsId");
        this.outputChannel = new ControlPanelNetwork.RSChannel(rsController, rsColor);
    }

    @Override
    public void setNetwork(ControlPanelNetwork net) {
        super.setNetwork(net);
        net.setOutputs(this, new ControlPanelNetwork.RSChannelState(this.outputChannel, (byte)(this.turned ? 15 : 0)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<RawQuad> getQuads() {
        ArrayList<RawQuad> ret = new ArrayList<RawQuad>(5);
        PanelUtils.addColoredBox(GRAY, GRAY, null, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0625f, 0.03125f, 0.0625f), ret, false);
        if (this.keyNBT != null) {
            Matrix4 mat = null;
            if (this.turned) {
                mat = new Matrix4();
                mat.translate(0.03125, 0.0, 0.03125);
                mat.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                mat.translate(-0.03125, 0.0, -0.03125);
            }
            this.addKey(ret, mat);
        } else {
            PanelUtils.addColoredQuad(ret, new Vector3f(0.03515625f, 0.03225f, 0.015625f), new Vector3f(0.02734375f, 0.03225f, 0.015625f), new Vector3f(0.02734375f, 0.03225f, 0.046875f), new Vector3f(0.03515625f, 0.03225f, 0.046875f), EnumFacing.UP, DARK_GRAY);
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    private void addKey(List<RawQuad> out, Matrix4 mat) {
        PanelUtils.addColoredBox(DARK_GRAY, DARK_GRAY, null, new Vector3f(0.02734375f, 0.03125f, 0.015625f), new Vector3f(0.0078125f, 0.0078125f, 0.03125f), out, false, mat);
        PanelUtils.addColoredBox(DARK_GRAY, DARK_GRAY, null, new Vector3f(0.02734375f, 0.0390625f, 0.00390625f), new Vector3f(0.0078125f, 0.0625f, 0.0546875f), out, false, mat);
    }

    @Override
    @Nonnull
    public PanelComponent copyOf() {
        Lock ret = new Lock(this.latching, this.outputChannel);
        ret.turned = this.turned;
        ret.lockID = this.lockID;
        ret.keyNBT = this.keyNBT == null ? null : this.keyNBT.func_74737_b();
        ret.ticksTillOff = this.ticksTillOff;
        ret.setX(this.x);
        ret.setY(this.y);
        ret.panelHeight = this.panelHeight;
        return ret;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBlockRelativeAABB() {
        if (this.aabb == null) {
            this.aabb = new AxisAlignedBB((double)this.x, 0.0, (double)this.y, (double)(this.x + 0.0625f), (double)this.getHeight(), (double)(this.y + 0.0625f));
        }
        return this.aabb;
    }

    @Override
    public void interactWith(Vec3d hitRel, EntityPlayerMP player) {
        boolean update = false;
        if (this.keyNBT == null) {
            for (EnumHand hand : EnumHand.values()) {
                ItemStack held = player.func_184586_b(hand);
                if (held.func_77973_b() != IndustrialWires.key || ItemKey.idForKey(held) != this.lockID) continue;
                this.keyNBT = held.serializeNBT();
                player.func_184611_a(hand, ItemStack.field_190927_a);
                break;
            }
        } else if (!this.turned) {
            if (player.func_70093_af() && player.func_184614_ca().func_190926_b()) {
                player.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(this.keyNBT));
                this.keyNBT = null;
            } else {
                this.turned = true;
            }
            update = true;
        } else if (this.latching) {
            this.turned = false;
            update = true;
        } else {
            this.ticksTillOff = 10;
        }
        if (update) {
            this.setOut();
            if (!this.latching && this.turned) {
                this.ticksTillOff = 10;
            }
        }
        this.panel.func_70296_d();
        this.panel.triggerRenderUpdate();
    }

    @Override
    public void update() {
        if (!this.latching && this.ticksTillOff > 0) {
            --this.ticksTillOff;
            if (this.ticksTillOff == 0) {
                this.turned = false;
                this.panel.triggerRenderUpdate();
                this.setOut();
            }
            this.panel.func_70296_d();
        }
    }

    @Override
    public float getHeight() {
        return 0.03125f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInGUI(GuiPanelCreator gui) {
        this.renderInGUIDefault(gui, -3092272);
        AxisAlignedBB aabb = this.getBlockRelativeAABB();
        int left = (int)((double)gui.getX0() + (aabb.field_72340_a + 0.02734375) * (double)gui.panelSize);
        int top = (int)((double)gui.getY0() + (aabb.field_72339_c + 0.015625) * (double)gui.panelSize);
        int right = (int)((double)gui.getX0() + (aabb.field_72336_d - 0.02734375) * (double)gui.panelSize);
        int bottom = (int)((double)gui.getY0() + (aabb.field_72334_f - 0.015625) * (double)gui.panelSize);
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)-9934744);
    }

    private void setOut() {
        this.network.setOutputs(this, new ControlPanelNetwork.RSChannelState(this.outputChannel, (byte)(this.turned ? 15 : 0)));
    }

    @Override
    public void dropItems() {
        super.dropItems();
        if (this.keyNBT != null) {
            Block.func_180635_a((World)this.panel.func_145831_w(), (BlockPos)this.panel.getBlockPos(), (ItemStack)new ItemStack(this.keyNBT));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Lock lock = (Lock)o;
        if (this.turned != lock.turned) {
            return false;
        }
        if (this.latching != lock.latching) {
            return false;
        }
        if (this.ticksTillOff != lock.ticksTillOff) {
            return false;
        }
        if (this.lockID != lock.lockID) {
            return false;
        }
        if (this.keyNBT != null ? !this.keyNBT.equals((Object)lock.keyNBT) : lock.keyNBT != null) {
            return false;
        }
        return this.outputChannel.equals(lock.outputChannel);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.keyNBT != null ? this.keyNBT.hashCode() : 0);
        result = 31 * result + (this.turned ? 1 : 0);
        result = 31 * result + (this.latching ? 1 : 0);
        result = 31 * result + this.outputChannel.hashCode();
        result = 31 * result + this.ticksTillOff;
        result = 31 * result + this.lockID;
        return result;
    }

    @Override
    public void applyConfigOption(IConfigurableComponent.ConfigType type, int id, NBTBase value) {
        switch (type) {
            case BOOL: {
                if (id != 0) break;
                this.latching = ((NBTTagByte)value).func_150290_f() != 0;
                break;
            }
            case RS_CHANNEL: {
                if (id != 0) break;
                byte rsColor = ((NBTTagByte)value).func_150290_f();
                this.outputChannel = new ControlPanelNetwork.RSChannel(this.outputChannel.getController(), rsColor);
                break;
            }
            case INT: {
                if (id != 0) break;
                int rsController = ((NBTTagInt)value).func_150287_d();
                this.outputChannel = new ControlPanelNetwork.RSChannel(rsController, this.outputChannel.getColor());
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigName(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case BOOL: {
                return I18n.func_135052_a((String)"industrialwires.desc.latching", (Object[])new Object[0]);
            }
            case RS_CHANNEL: 
            case INT: {
                return null;
            }
        }
        return "INVALID";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigDescription(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case BOOL: {
                return I18n.func_135052_a((String)"industrialwires.desc.latching_info", (Object[])new Object[0]);
            }
            case RS_CHANNEL: {
                return I18n.func_135052_a((String)"industrialwires.desc.rschannel_info", (Object[])new Object[0]);
            }
            case INT: {
                return I18n.func_135052_a((String)"industrialwires.desc.rsid_info", (Object[])new Object[0]);
            }
        }
        return "INVALID?";
    }

    @Override
    public IConfigurableComponent.RSColorConfig[] getRSChannelOptions() {
        return new IConfigurableComponent.RSColorConfig[]{new IConfigurableComponent.RSColorConfig("channel", 0, 0, this.outputChannel.getColor())};
    }

    @Override
    public IConfigurableComponent.IntConfig[] getIntegerOptions() {
        return new IConfigurableComponent.IntConfig[]{new IConfigurableComponent.IntConfig("rsId", 0, 50, this.outputChannel.getController(), 2, false)};
    }

    @Override
    public IConfigurableComponent.BoolConfig[] getBooleanOptions() {
        return new IConfigurableComponent.BoolConfig[]{new IConfigurableComponent.BoolConfig("latching", 0, 70, this.latching)};
    }

    @Override
    public int getColor() {
        return -3092272;
    }

    public int getLockID() {
        return this.lockID;
    }
}

