/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.client.panelmodel;

import blusunrize.immersiveengineering.api.IEApi;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.blocks.controlpanel.BlockTypes_Panel;
import malte0811.industrialwires.blocks.controlpanel.TileEntityPanel;
import malte0811.industrialwires.blocks.controlpanel.TileEntityUnfinishedPanel;
import malte0811.industrialwires.controlpanel.PanelUtils;
import malte0811.industrialwires.controlpanel.PropertyComponents;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class PanelModel
implements IBakedModel {
    public static final Cache<PropertyComponents.PanelRenderProperties, AssembledBakedModel> modelCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(60L, TimeUnit.SECONDS).build();
    private static final PanelItemOverride INSTANCE;

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side != null) {
            return ImmutableList.of();
        }
        if (state instanceof IExtendedBlockState) {
            PropertyComponents.PanelRenderProperties cl = (PropertyComponents.PanelRenderProperties)((IExtendedBlockState)state).getValue((IUnlistedProperty)PropertyComponents.INSTANCE);
            if (cl == null) {
                return ImmutableList.of();
            }
            AssembledBakedModel m = (AssembledBakedModel)modelCache.getIfPresent((Object)cl);
            if (m == null) {
                m = new AssembledBakedModel(cl);
                modelCache.put((Object)cl.copyOf(), (Object)m);
            }
            return m.func_188616_a(state, null, rand);
        }
        return ImmutableList.of();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return PanelUtils.PANEL_TEXTURE;
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return INSTANCE;
    }

    static {
        IEApi.renderCacheClearers.add(() -> modelCache.invalidateAll());
        IEApi.renderCacheClearers.add(() -> ((Cache)PanelItemOverride.ITEM_MODEL_CACHE).invalidateAll());
        INSTANCE = new PanelItemOverride();
    }

    private static class PanelItemOverride
    extends ItemOverrideList {
        private static Cache<ItemStack, AssembledBakedModel> ITEM_MODEL_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(60L, TimeUnit.SECONDS).build();

        public PanelItemOverride() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            if (stack != null && stack.func_77973_b() == PanelUtils.PANEL_ITEM) {
                try {
                    return (IBakedModel)ITEM_MODEL_CACHE.get((Object)stack, () -> {
                        TileEntityPanel te = stack.func_77960_j() == BlockTypes_Panel.TOP.ordinal() ? new TileEntityPanel() : new TileEntityUnfinishedPanel();
                        te.readFromItemNBT(stack.func_77978_p());
                        return new AssembledBakedModel(te.getComponents());
                    });
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            return originalModel;
        }
    }

    public static class AssembledBakedModel
    implements IBakedModel {
        PropertyComponents.PanelRenderProperties components;
        List<BakedQuad> quadsDefault;
        ItemCameraTransforms transform = new ItemCameraTransforms(new ItemTransformVec3f(new Vector3f(45.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.2f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)), new ItemTransformVec3f(new Vector3f(45.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.2f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)), new ItemTransformVec3f(new Vector3f(), new Vector3f(0.0f, 0.2f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)), new ItemTransformVec3f(new Vector3f(), new Vector3f(0.0f, 0.2f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)), new ItemTransformVec3f(new Vector3f(), new Vector3f(), new Vector3f()), new ItemTransformVec3f(new Vector3f(30.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.125f, 0.0f), new Vector3f(0.6f, 0.6f, 0.6f)), new ItemTransformVec3f(new Vector3f(), new Vector3f(0.0f, 0.1f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new ItemTransformVec3f(new Vector3f(0.0f, 180.0f, 45.0f), new Vector3f(0.0f, 0.0f, -0.1875f), new Vector3f(0.5f, 0.5f, 0.5f)));

        public AssembledBakedModel(PropertyComponents.PanelRenderProperties comp) {
            this.components = comp;
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            if (this.quadsDefault == null) {
                this.quadsDefault = PanelUtils.generateQuads(this.components);
                this.quadsDefault = Collections.synchronizedList(this.quadsDefault);
            }
            return this.quadsDefault;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return PanelUtils.PANEL_TEXTURE;
        }

        @Nonnull
        public ItemCameraTransforms func_177552_f() {
            return this.transform;
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return INSTANCE;
        }
    }
}

