/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.controlpanel;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.energy.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.energy.wires.redstone.RedstoneWireNetwork;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.IBlockBoundsIW;
import malte0811.industrialwires.blocks.controlpanel.TileEntityRSPanel;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class TileEntityRSPanelIE
extends TileEntityRSPanel
implements IRedstoneConnector,
IEBlockInterfaces.IDirectionalTile,
IBlockBoundsIW {
    private EnumFacing facing = EnumFacing.NORTH;
    @Nonnull
    private RedstoneWireNetwork wireNetwork = new RedstoneWireNetwork().add((IRedstoneConnector)this);
    private boolean hasConn = false;
    private AxisAlignedBB aabb;

    @Override
    public void writeNBT(NBTTagCompound nbt, boolean updatePacket) {
        super.writeNBT(nbt, updatePacket);
        nbt.func_74757_a("hasConn", this.hasConn);
        nbt.func_74768_a("facing", this.facing.func_176745_a());
        if (updatePacket) {
            this.writeConnsToNBT(nbt);
        }
    }

    @Override
    public void readNBT(NBTTagCompound nbt, boolean updatePacket) {
        super.readNBT(nbt, updatePacket);
        if (nbt.func_150297_b("connectionList", 9)) {
            this.loadConnsFromNBT(nbt);
        }
        this.hasConn = nbt.func_74767_n("hasConn");
        this.facing = EnumFacing.field_82609_l[nbt.func_74762_e("facing")];
        this.aabb = null;
    }

    private void loadConnsFromNBT(NBTTagCompound nbt) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && !Minecraft.func_71410_x().func_71356_B() && nbt != null) {
            NBTTagList connectionList = nbt.func_150295_c("connectionList", 10);
            ImmersiveNetHandler.INSTANCE.clearConnectionsOriginatingFrom(Utils.toCC((Object)this), this.field_145850_b);
            for (int i = 0; i < connectionList.func_74745_c(); ++i) {
                NBTTagCompound conTag = connectionList.func_150305_b(i);
                ImmersiveNetHandler.Connection con = ImmersiveNetHandler.Connection.readFromNBT((NBTTagCompound)conTag);
                if (con != null) {
                    ImmersiveNetHandler.INSTANCE.addConnection(this.field_145850_b, Utils.toCC((Object)this), con);
                    continue;
                }
                IndustrialWires.logger.error("CLIENT read connection as null from {}", (Object)nbt);
            }
        }
    }

    private void writeConnsToNBT(NBTTagCompound nbt) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && nbt != null) {
            NBTTagList connectionList = new NBTTagList();
            Set conL = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC((Object)this));
            if (conL != null) {
                for (ImmersiveNetHandler.Connection con : conL) {
                    connectionList.func_74742_a((NBTBase)con.writeToNBT());
                }
            }
            nbt.func_74782_a("connectionList", (NBTBase)connectionList);
        }
    }

    @Override
    protected void updateOutput() {
        this.wireNetwork.updateValues();
    }

    @Override
    protected void updateInput() {
        this.updateInput(this.wireNetwork.channelValues);
    }

    public void setNetwork(@Nonnull RedstoneWireNetwork net) {
        this.wireNetwork = net;
    }

    @Nonnull
    public RedstoneWireNetwork getNetwork() {
        return this.wireNetwork;
    }

    public void onChange() {
        this.onInputChanged(this.wireNetwork.channelValues);
    }

    public void updateInput(byte[] currIn) {
        for (int i = 0; i < 16; ++i) {
            currIn[i] = (byte)Math.max(currIn[i], this.out[i]);
        }
    }

    public boolean canConnect() {
        return true;
    }

    public boolean isEnergyOutput() {
        return false;
    }

    public int outputEnergy(int amount, boolean simulate, int energyType) {
        return 0;
    }

    public BlockPos getConnectionMaster(@Nullable WireType wire, TargetingInfo target) {
        return this.field_174879_c;
    }

    public boolean canConnectCable(WireType wire, TargetingInfo targetingInfo, Vec3i offset) {
        return "REDSTONE".equals(wire.getCategory()) && !this.hasConn;
    }

    public void connectCable(WireType wireType, TargetingInfo targetingInfo, IImmersiveConnectable other) {
        this.hasConn = true;
        RedstoneWireNetwork.updateConnectors((BlockPos)this.field_174879_c, (World)this.field_145850_b, (RedstoneWireNetwork)this.wireNetwork);
    }

    public WireType getCableLimiter(TargetingInfo targetingInfo) {
        return WireType.REDSTONE;
    }

    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection connection) {
        return true;
    }

    public void removeCable(ImmersiveNetHandler.Connection connection) {
        this.hasConn = false;
        this.wireNetwork.removeFromNetwork((IRedstoneConnector)this);
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection connection) {
        EnumFacing side = this.facing.func_176734_d();
        double conRadius = connection.cableType.getRenderDiameter() / 2.0;
        return new Vec3d(0.5 - conRadius * (double)side.func_82601_c(), 0.5 - conRadius * (double)side.func_96559_d(), 0.5 - conRadius * (double)side.func_82599_e());
    }

    public World getConnectorWorld() {
        return this.field_145850_b;
    }

    @Nonnull
    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(@Nonnull EnumFacing facing) {
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 0;
    }

    public boolean mirrorFacingOnPlacement(@Nonnull EntityLivingBase placer) {
        return true;
    }

    public boolean canHammerRotate(@Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EntityLivingBase entity) {
        return false;
    }

    public boolean canRotate(@Nonnull EnumFacing axis) {
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        if (this.aabb == null) {
            double h = 0.5625;
            switch (this.facing) {
                case DOWN: {
                    this.aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, h, 1.0);
                    break;
                }
                case UP: {
                    this.aabb = new AxisAlignedBB(0.0, 1.0 - h, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case NORTH: {
                    this.aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, h);
                    break;
                }
                case SOUTH: {
                    this.aabb = new AxisAlignedBB(0.0, 0.0, 1.0 - h, 1.0, 1.0, 1.0);
                    break;
                }
                case WEST: {
                    this.aabb = new AxisAlignedBB(0.0, 0.0, 0.0, h, 1.0, 1.0);
                    break;
                }
                case EAST: {
                    this.aabb = new AxisAlignedBB(1.0 - h, 0.0, 0.0, 1.0, 1.0, 1.0);
                }
            }
        }
        return this.aabb;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K && !Minecraft.func_71410_x().func_71356_B()) {
            ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(this.field_174879_c, this.field_145850_b, (IImmersiveConnectable)this, false);
        }
    }
}

