/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shadows.placebo.Placebo;
import shadows.placebo.interfaces.IHarvestableEnum;
import shadows.placebo.interfaces.IPropertyEnum;
import shadows.placebo.util.PlaceboUtil;
import shadows.placebo.util.StackPrimer;
import shadows.plants2.block.BlockEnumDoubleFlower;
import shadows.plants2.block.BlockEnumHarvestBush;
import shadows.plants2.data.PlantConfig;
import shadows.plants2.data.PlantConstants;

public class BlockEnumDoubleHarvestBush<E extends Enum<E>>
extends BlockEnumHarvestBush<E> {
    public static final PropertyBool UPPER = BlockEnumDoubleFlower.UPPER;

    public BlockEnumDoubleHarvestBush(String name, EnumPlantType type, Class<E> enumClass, int predicate) {
        super(name, type, enumClass, predicate);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a()) && super.func_180671_f(world, pos, this.func_176223_P());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModels(ModelRegistryEvent e) {
        for (int i = 0; i < this.types.size(); ++i) {
            PlaceboUtil.sMRL((String)"double_harvest", (Block)this, (int)i, (String)("fruit=true," + this.property.func_177701_a() + "=" + ((IPropertyEnum)((Enum)this.types.get(i))).func_176610_l() + ",upper=true,zinventory=true"));
        }
        Placebo.PROXY.useRenamedMapper((Block)this, "double_harvest");
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!PlantConfig.harvests) {
            return false;
        }
        if (!world.field_72995_K) {
            StackPrimer[] drops = ((IHarvestableEnum)((Enum)this.types.get(((Enum)((Object)state.func_177229_b((IProperty)this.property))).ordinal() % 4))).getDrops();
            if (((Boolean)state.func_177229_b((IProperty)FRUIT)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
                for (StackPrimer s : drops) {
                    ItemStack i = s.genStack();
                    if (player.func_191521_c(i) || world.field_72995_K) continue;
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)i);
                }
                world.func_175656_a(pos, state.func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(false)));
                world.func_175656_a(pos.func_177977_b(), state.func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(false)));
                return true;
            }
            if (((Boolean)state.func_177229_b((IProperty)FRUIT)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
                for (StackPrimer s : drops) {
                    ItemStack i = s.genStack();
                    if (player.func_191521_c(i) || world.field_72995_K) continue;
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)i);
                }
                world.func_175656_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(false)));
                world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(false)));
                return true;
            }
        }
        return (Boolean)state.func_177229_b((IProperty)FRUIT);
    }

    protected void func_176475_e(World world, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(world, pos, state)) {
            boolean flag = (Boolean)state.func_177229_b((IProperty)UPPER);
            BlockPos otherPos = flag ? pos.func_177977_b() : pos.func_177984_a();
            world.func_175655_b(pos, !flag);
            world.func_175655_b(otherPos, flag);
        }
    }

    @Override
    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return super.func_180671_f(world, pos, state);
        }
        if (((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
            return world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        IBlockState iblockstate = world.func_180495_p(pos.func_177984_a());
        return iblockstate.func_177230_c() == this && super.func_180671_f(world, pos, iblockstate);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
            return null;
        }
        return Item.func_150898_a((Block)this);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true)), 2);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                if (player.field_71075_bZ.field_75098_d) {
                    world.func_175698_g(pos.func_177977_b());
                } else {
                    world.func_175655_b(pos.func_177977_b(), true);
                    if (world.field_72995_K) {
                        world.func_175698_g(pos.func_177977_b());
                    }
                }
            }
        } else if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_175698_g(pos.func_177984_a());
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (state.func_177230_c() == this && !((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue() && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_175698_g(pos.func_177984_a());
        }
        return world.func_175698_g(pos);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = ((Enum)((Object)state.func_177229_b((IProperty)this.property))).ordinal() % 4;
        i *= 4;
        if (((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)FRUIT)).booleanValue()) {
            i += 2;
        }
        return i;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        float i = meta;
        state = state.func_177226_a((IProperty)this.property, (Comparable)this.types.get((int)(i /= 4.0f)));
        if (i - 0.5f >= 0.0f) {
            state = state.func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(true));
            i -= 0.5f;
        }
        if (i - 0.25f >= 0.0f) {
            state = state.func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    public PropertyBool getInvProperty() {
        return PlantConstants.ZINV;
    }

    @Override
    public BlockStateContainer createStateContainer() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.property, FRUIT, UPPER, this.getInvProperty()});
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)FRUIT)).booleanValue()) {
            boolean couldGrow;
            boolean bl = couldGrow = rand.nextInt(PlantConfig.harvestGrowthChance) == 0;
            if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (boolean)couldGrow)) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true)), 3);
                world.func_180501_a(pos.func_177977_b(), state.func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)), 3);
                ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
            }
        }
    }

    @Override
    public boolean placeStateAt(IBlockState state, World world, BlockPos pos) {
        if (world.func_175623_d(pos.func_177984_a()) && world.func_175656_a(pos, state.func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)))) {
            this.func_180633_a(world, pos, state, null, null);
            return true;
        }
        return false;
    }

    @Override
    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(true)));
        if (!((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
            world.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(true)));
        } else {
            world.func_175656_a(pos.func_177977_b(), state.func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(true)));
        }
    }

    @Override
    protected int getMaxEnumValues() {
        return 4;
    }
}

