/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.Stack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import thebetweenlands.common.capability.base.AbstractCapability;

public class NBTHelper {
    public static NBTTagCompound getStackNBTSafe(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean areItemStackTagsEqualWithoutCapabilities(ItemStack a, ItemStack b, AbstractCapability<?, ?, ?> ... exclusions) {
        ArrayList<String> strExclusions = new ArrayList<String>();
        for (AbstractCapability<?, ?, ?> exclusion : exclusions) {
            strExclusions.add("ForgeCaps." + exclusion.getID().toString());
        }
        return NBTHelper.areItemStackTagsEqual(a, b, strExclusions);
    }

    public static boolean areItemStackTagsEqual(ItemStack a, ItemStack b, Collection<String> exclusions) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            if (a.func_77978_p() == null && b.func_77978_p() == null) {
                return true;
            }
            if (a.func_77978_p() == null ^ b.func_77978_p() == null) {
                return false;
            }
            return NBTHelper.areNBTCompoundsEquals(a.func_77978_p(), b.func_77978_p(), exclusions);
        }
        return false;
    }

    public static boolean areNBTCompoundsEquals(NBTTagCompound a, NBTTagCompound b, Collection<String> exclusions) {
        Stack<String> tagOwners = new Stack<String>();
        Stack<NBTTagCompound> aTagCompounds = new Stack<NBTTagCompound>();
        Stack<NBTTagCompound> bTagCompounds = new Stack<NBTTagCompound>();
        tagOwners.push("");
        aTagCompounds.push(a);
        bTagCompounds.push(b);
        while (!aTagCompounds.isEmpty()) {
            String tagOwner = (String)tagOwners.pop();
            NBTTagCompound aCurrentTagCompound = (NBTTagCompound)aTagCompounds.pop();
            NBTTagCompound bCurrentTagCompound = (NBTTagCompound)bTagCompounds.pop();
            Set aKeys = aCurrentTagCompound.func_150296_c();
            Set bKeys = bCurrentTagCompound.func_150296_c();
            for (String key : bKeys) {
                if (exclusions.contains(key) || aKeys.contains(key)) continue;
                return false;
            }
            for (String key : aKeys) {
                String totalKey;
                String string = totalKey = tagOwner == "" ? key : tagOwner + '.' + key;
                if (exclusions.contains(totalKey)) continue;
                NBTBase aTag = aCurrentTagCompound.func_74781_a(key);
                NBTBase bTag = bCurrentTagCompound.func_74781_a(key);
                if (aTag instanceof NBTTagCompound && bTag instanceof NBTTagCompound) {
                    tagOwners.push(totalKey);
                    aTagCompounds.push((NBTTagCompound)aTag);
                    bTagCompounds.push((NBTTagCompound)bTag);
                    continue;
                }
                if (aTag.equals((Object)bTag)) continue;
                return false;
            }
        }
        return true;
    }
}

