/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.compat.jei.recipes.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.api.item.ICorrodible;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.RecipeRegistry;
import thebetweenlands.compat.jei.BetweenlandsJEIPlugin;
import thebetweenlands.compat.jei.recipes.misc.CoatingRecipeJEI;

public class SapCleanRecipeJEI
implements ICraftingRecipeWrapper,
ICustomCraftingRecipeWrapper {
    private final ICraftingGridHelper craftingGridHelper;

    public SapCleanRecipeJEI(IGuiHelper guiHelper) {
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return RecipeRegistry.SAP_SPIT_CLEAN_TOOL;
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<List<Object>> inputLists = new ArrayList<List<Object>>();
        ArrayList outputLists = new ArrayList();
        ItemStack sap = new ItemStack(ItemRegistry.SAP_SPIT);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (ItemStack stack : CoatingRecipeJEI.coatableItems) {
            ItemStack corroded = stack.func_77946_l();
            ((ICorrodible)corroded.func_77973_b()).setCorrosion(corroded, ((ICorrodible)corroded.func_77973_b()).getMaxCorrosion(corroded));
            inputs.add(corroded);
            outputs.add(stack);
        }
        inputLists.add(inputs);
        outputLists.add(outputs);
        for (int i = 0; i < 8; ++i) {
            inputLists.add(Collections.singletonList(sap));
        }
        ingredients.setInputLists(VanillaTypes.ITEM, inputLists);
        ingredients.setOutputLists(VanillaTypes.ITEM, outputLists);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        IStackHelper stackHelper = BetweenlandsJEIPlugin.jeiHelper.getStackHelper();
        recipeLayout.setShapeless();
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IFocus focus = recipeLayout.getFocus();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        if (focus != null && focus.getValue() instanceof ItemStack && ((ItemStack)focus.getValue()).func_77973_b() instanceof ICorrodible) {
            if (focus.getMode() == IFocus.Mode.INPUT) {
                ((List)outputs.get(0)).removeIf(stack -> !stackHelper.isEquivalent((ItemStack)focus.getValue(), stack));
            } else {
                ((List)inputs.get(0)).removeIf(stack -> !stackHelper.isEquivalent((ItemStack)focus.getValue(), stack));
            }
        }
        this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
        guiItemStacks.set(0, (List)outputs.get(0));
        BetweenlandsJEIPlugin.addRecipeName(this.getRegistryName(), guiItemStacks, 0);
    }
}

