/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.location;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageID;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class LocationPortal
extends LocationStorage {
    private BlockPos portalPos;
    private BlockPos otherPortalPos;
    private int otherPortalDimension;
    private boolean targetDimensionSet;

    public LocationPortal(IWorldStorage worldStorage, StorageID id, @Nullable LocalRegion region) {
        super(worldStorage, id, region);
    }

    public LocationPortal(IWorldStorage worldStorage, StorageID id, @Nullable LocalRegion region, BlockPos pos) {
        super(worldStorage, id, region);
        this.portalPos = pos;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int currDim;
        super.readFromNBT(nbt);
        this.portalPos = BlockPos.func_177969_a((long)nbt.func_74763_f("PortalPos"));
        this.otherPortalPos = nbt.func_150297_b("OtherPortalPos", 4) ? BlockPos.func_177969_a((long)nbt.func_74763_f("OtherPortalPos")) : null;
        this.otherPortalDimension = nbt.func_150297_b("OtherPortalDimension", 3) ? nbt.func_74762_e("OtherPortalDimension") : ((currDim = this.getWorldStorage().getWorld().field_73011_w.getDimension()) == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId ? 0 : BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId);
        this.targetDimensionSet = nbt.func_74767_n("TargetDimSet");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        nbt.func_74772_a("PortalPos", this.portalPos.func_177986_g());
        if (this.otherPortalPos != null) {
            nbt.func_74772_a("OtherPortalPos", this.otherPortalPos.func_177986_g());
        }
        nbt.func_74768_a("OtherPortalDimension", this.otherPortalDimension);
        nbt.func_74757_a("TargetDimSet", this.targetDimensionSet);
        return nbt;
    }

    public BlockPos getPortalPosition() {
        return this.portalPos;
    }

    @Nullable
    public BlockPos getOtherPortalPosition() {
        return this.otherPortalPos;
    }

    public int getOtherPortalDimension() {
        return this.otherPortalDimension;
    }

    public void setOtherPortalPosition(int dim, @Nullable BlockPos pos) {
        this.otherPortalPos = pos;
        this.otherPortalDimension = dim;
        this.setDirty(true);
    }

    public void setTargetDimension(int dim) {
        this.otherPortalPos = null;
        this.otherPortalDimension = dim;
        this.targetDimensionSet = true;
        this.setDirty(true);
    }

    public boolean hasTargetDimension() {
        return this.targetDimensionSet;
    }

    public boolean validateAndRemove() {
        World world = this.getWorldStorage().getWorld();
        AxisAlignedBB bounds = this.getBoundingBox();
        for (BlockPos.MutableBlockPos checkPos : BlockPos.MutableBlockPos.func_177975_b((BlockPos)new BlockPos(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c), (BlockPos)new BlockPos(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f))) {
            if (world.func_180495_p((BlockPos)checkPos).func_177230_c() != BlockRegistry.TREE_PORTAL) continue;
            return false;
        }
        return this.getWorldStorage().getLocalStorageHandler().removeLocalStorage(this);
    }
}

