/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thebetweenlands.api.event.AttachChunkStorageCapabilitiesEvent;
import thebetweenlands.api.storage.IChunkStorage;
import thebetweenlands.api.storage.ILocalStorage;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.api.storage.LocalStorageReference;
import thebetweenlands.api.storage.StorageID;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.network.clientbound.MessageSyncChunkStorage;
import thebetweenlands.common.network.clientbound.MessageSyncLocalStorageReferences;

public abstract class ChunkStorageImpl
implements IChunkStorage,
ITickable {
    protected final IWorldStorage worldStorage;
    protected final World world;
    protected final Chunk chunk;
    private Set<EntityPlayerMP> watchers = new HashSet<EntityPlayerMP>();
    private boolean dirty = false;
    private CapabilityDispatcher capabilities;
    private final List<LocalStorageReference> localStorageReferences = new ArrayList<LocalStorageReference>();
    protected boolean syncStorageLinks = false;

    public ChunkStorageImpl(IWorldStorage worldStorage, Chunk chunk) {
        this.worldStorage = worldStorage;
        this.world = worldStorage.getWorld();
        this.chunk = chunk;
        AttachChunkStorageCapabilitiesEvent event = new AttachChunkStorageCapabilitiesEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.capabilities = event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities(), null) : null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.capabilities == null ? false : this.capabilities.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(this.capabilities == null ? null : this.capabilities.getCapability(capability, facing));
    }

    @Override
    public IWorldStorage getWorldStorage() {
        return this.worldStorage;
    }

    @Override
    public Chunk getChunk() {
        return this.chunk;
    }

    @Override
    public void init() {
    }

    @Override
    public void onUnload() {
        for (LocalStorageReference ref : this.localStorageReferences) {
            ILocalStorage localStorage = this.getWorldStorage().getLocalStorageHandler().getLocalStorage(ref.getID());
            if (localStorage == null) continue;
            localStorage.unloadReference(ref);
            if (!localStorage.getLoadedReferences().isEmpty()) continue;
            this.getWorldStorage().getLocalStorageHandler().unloadLocalStorage(localStorage);
        }
    }

    @Override
    public void setDefaults() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, boolean packet) {
        if (this.capabilities != null && nbt.func_74764_b("ForgeCaps")) {
            this.capabilities.deserializeNBT(nbt.func_74775_l("ForgeCaps"));
        }
        this.readLocalStorageReferences(nbt);
    }

    @Override
    public NBTTagCompound readLocalStorageReferences(NBTTagCompound nbt) {
        this.localStorageReferences.clear();
        NBTTagList localReferenceList = nbt.func_150295_c("LocalStorageReferences", 10);
        for (int i = 0; i < localReferenceList.func_74745_c(); ++i) {
            this.localStorageReferences.add(LocalStorageReference.readFromNBT((NBTTagCompound)localReferenceList.func_179238_g(i)));
        }
        Iterator<LocalStorageReference> refIT = this.localStorageReferences.iterator();
        while (refIT.hasNext()) {
            LocalStorageReference ref = refIT.next();
            ILocalStorage storage = this.worldStorage.getLocalStorageHandler().getLocalStorage(ref.getID());
            if (!this.worldStorage.getWorld().field_72995_K && storage == null) {
                storage = this.worldStorage.getLocalStorageHandler().loadLocalStorage(ref);
            }
            if (storage != null && storage.getLinkedChunks().contains(this.chunk.func_76632_l())) {
                storage.loadReference(ref);
                continue;
            }
            if (this.worldStorage.getWorld().field_72995_K) continue;
            refIT.remove();
        }
        return nbt;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt, boolean packet) {
        NBTTagCompound caps;
        if (this.capabilities != null && (caps = this.capabilities.serializeNBT()).func_186856_d() > 0) {
            nbt.func_74782_a("ForgeCaps", (NBTBase)caps);
        }
        this.writeLocalStorageReferences(nbt);
        return nbt;
    }

    @Override
    public NBTTagCompound writeLocalStorageReferences(NBTTagCompound nbt) {
        if (!this.localStorageReferences.isEmpty()) {
            NBTTagList localReferenceList = new NBTTagList();
            for (LocalStorageReference ref : this.localStorageReferences) {
                localReferenceList.func_74742_a((NBTBase)ref.writeToNBT(new NBTTagCompound()));
            }
            nbt.func_74782_a("LocalStorageReferences", (NBTBase)localReferenceList);
        }
        return nbt;
    }

    @Override
    public boolean addWatcher(EntityPlayerMP player) {
        if (this.watchers.add(player)) {
            this.onWatched(player);
            return true;
        }
        return false;
    }

    protected void onWatched(EntityPlayerMP player) {
        for (LocalStorageReference ref : this.localStorageReferences) {
            ILocalStorage localStorage = this.getWorldStorage().getLocalStorageHandler().getLocalStorage(ref.getID());
            if (localStorage == null) continue;
            localStorage.addWatcher(this, player);
        }
        TheBetweenlands.networkWrapper.sendTo((IMessage)new MessageSyncChunkStorage(this), player);
    }

    @Override
    public boolean removeWatcher(EntityPlayerMP player) {
        if (this.watchers.remove(player)) {
            this.onUnwatched(player);
            return true;
        }
        return false;
    }

    protected void onUnwatched(EntityPlayerMP player) {
        for (LocalStorageReference ref : this.localStorageReferences) {
            ILocalStorage localStorage = this.getWorldStorage().getLocalStorageHandler().getLocalStorage(ref.getID());
            if (localStorage == null) continue;
            localStorage.removeWatcher(this, player);
        }
    }

    public Set<EntityPlayerMP> getWatchers() {
        return Collections.unmodifiableSet(this.watchers);
    }

    @Override
    public void markDirty() {
        this.setDirty(true);
    }

    @Override
    public void setDirty(boolean dirty) {
        if (dirty) {
            this.chunk.func_177427_f(true);
        }
        this.dirty = dirty;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public LocalStorageReference getReference(StorageID id) {
        for (LocalStorageReference ref : this.localStorageReferences) {
            if (!id.equals(ref.getID())) continue;
            return ref;
        }
        return null;
    }

    @Override
    public boolean unlinkLocalStorage(ILocalStorage storage) {
        StorageID id = storage.getID();
        ArrayList<LocalStorageReference> unlinkedReferences = new ArrayList<LocalStorageReference>();
        Iterator<LocalStorageReference> referenceIT = this.localStorageReferences.iterator();
        while (referenceIT.hasNext()) {
            LocalStorageReference ref = referenceIT.next();
            if (!id.equals(ref.getID())) continue;
            unlinkedReferences.add(ref);
            referenceIT.remove();
        }
        if (!unlinkedReferences.isEmpty()) {
            for (LocalStorageReference ref : unlinkedReferences) {
                if (!storage.getLoadedReferences().contains(ref)) continue;
                storage.unlinkChunk(this.chunk);
            }
            this.markDirty();
            for (EntityPlayerMP watcher : this.getWatchers()) {
                storage.removeWatcher(this, watcher);
            }
            this.syncStorageLinks = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean linkLocalStorage(ILocalStorage storage) {
        StorageID id = storage.getID();
        for (LocalStorageReference ref : this.localStorageReferences) {
            if (!id.equals(ref.getID())) continue;
            return false;
        }
        LocalStorageReference ref = new LocalStorageReference(this.chunk.func_76632_l(), id, storage.getRegion());
        if (this.localStorageReferences.add(ref)) {
            this.markDirty();
            for (EntityPlayerMP watcher : this.getWatchers()) {
                storage.addWatcher(this, watcher);
            }
            this.syncStorageLinks = true;
            return true;
        }
        return false;
    }

    @Override
    public Collection<LocalStorageReference> getLocalStorageReferences() {
        return Collections.unmodifiableCollection(this.localStorageReferences);
    }

    public void func_73660_a() {
        if (this.syncStorageLinks) {
            this.syncStorageLinks = false;
            MessageSyncLocalStorageReferences message = new MessageSyncLocalStorageReferences(this);
            for (EntityPlayerMP watcher : this.watchers) {
                TheBetweenlands.networkWrapper.sendTo((IMessage)message, watcher);
            }
        }
    }
}

