/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.tree;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.block.terrain.BlockLeavesBetweenlands;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.storage.location.LocationSpiritTree;
import thebetweenlands.common.world.storage.location.guard.ILocationGuard;

public class WorldGenSpiritTree
extends WorldGenerator {
    private static final ImmutableList<EnumFacing> LEAVES_OFFSETS;
    private IBlockState log;
    private IBlockState leavesTop;
    private IBlockState leavesMiddle;
    private IBlockState leavesBottom;
    private IBlockState roots;
    @Nullable
    private ILocationGuard guard;
    @Nullable
    private LocationSpiritTree location;

    public WorldGenSpiritTree(@Nullable ILocationGuard guard, @Nullable LocationSpiritTree location) {
        this.guard = guard;
        this.location = location;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        int checkRadius = 9;
        for (int xx = -checkRadius; xx <= checkRadius; ++xx) {
            for (int zz = -checkRadius; zz <= checkRadius; ++zz) {
                for (int yy = 3; yy < 16; ++yy) {
                    if (world.func_175623_d(position.func_177982_a(xx, yy, zz)) || !world.func_180495_p(position.func_177982_a(xx, yy, zz)).func_185915_l()) continue;
                    return false;
                }
            }
        }
        this.log = BlockRegistry.LOG_SPIRIT_TREE.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        this.leavesTop = BlockRegistry.LEAVES_SPIRIT_TREE_TOP.func_176223_P().func_177226_a((IProperty)BlockLeavesBetweenlands.field_176236_b, (Comparable)Boolean.valueOf(false));
        this.leavesMiddle = BlockRegistry.LEAVES_SPIRIT_TREE_MIDDLE.func_176223_P().func_177226_a((IProperty)BlockLeavesBetweenlands.field_176236_b, (Comparable)Boolean.valueOf(false));
        this.leavesBottom = BlockRegistry.LEAVES_SPIRIT_TREE_BOTTOM.func_176223_P().func_177226_a((IProperty)BlockLeavesBetweenlands.field_176236_b, (Comparable)Boolean.valueOf(false));
        this.roots = BlockRegistry.ROOT.func_176223_P();
        int trunkX = position.func_177958_n();
        int trunkY = position.func_177956_o();
        int trunkZ = position.func_177952_p();
        int height = 8 + rand.nextInt(4);
        for (int yo = 0; yo < height; ++yo) {
            this.generateTrunkCrossSection(world, rand, trunkX, trunkY + yo, trunkZ, this.log, trunkX, trunkY, trunkZ);
            if (this.location == null) continue;
            this.location.addLargeFacePosition(new BlockPos(trunkX, trunkY + yo, trunkZ));
        }
        HashMap<List<BlockPos>, BlockPos> branches = new HashMap<List<BlockPos>, BlockPos>();
        BlockPos sideBranch = new BlockPos(trunkX + rand.nextInt(2), trunkY + height - 3, trunkZ);
        branches.put(this.generateSideBranch(world, rand, sideBranch, 0, trunkX, trunkY, trunkZ), sideBranch);
        sideBranch = new BlockPos(trunkX, trunkY + height - 3, trunkZ + rand.nextInt(2));
        branches.put(this.generateSideBranch(world, rand, sideBranch, 2, trunkX, trunkY, trunkZ), sideBranch);
        sideBranch = new BlockPos(trunkX + rand.nextInt(2), trunkY + height - 3, trunkZ + 1);
        branches.put(this.generateSideBranch(world, rand, sideBranch, 4, trunkX, trunkY, trunkZ), sideBranch);
        sideBranch = new BlockPos(trunkX + 1, trunkY + height - 3, trunkZ + rand.nextInt(2));
        branches.put(this.generateSideBranch(world, rand, sideBranch, 6, trunkX, trunkY, trunkZ), sideBranch);
        ArrayList<Integer> diagonals = new ArrayList<Integer>(Arrays.asList(1, 3, 5, 7));
        int numDiagonals = 1 + rand.nextInt(3);
        for (int i = 0; i < numDiagonals; ++i) {
            int dir = (Integer)diagonals.remove(rand.nextInt(diagonals.size()));
            int[] offset = this.getDirOffset(dir);
            int bx = trunkX + (offset[0] > 0 ? offset[0] * 2 : offset[0]);
            int bz = trunkZ + (offset[1] > 0 ? offset[1] * 2 : offset[1]);
            sideBranch = new BlockPos(bx, trunkY + height, bz);
            branches.put(this.generateSideBranch(world, rand, sideBranch, dir, trunkX, trunkY, trunkZ), sideBranch);
        }
        if (rand.nextBoolean()) {
            sideBranch = new BlockPos(trunkX, trunkY + height, trunkZ);
            branches.put(this.generateTopBranch(world, rand, sideBranch, 1, trunkX, trunkY, trunkZ), sideBranch);
            sideBranch = new BlockPos(trunkX + 1, trunkY + height, trunkZ + 1);
            branches.put(this.generateTopBranch(world, rand, sideBranch, 5, trunkX, trunkY, trunkZ), sideBranch);
        } else {
            sideBranch = new BlockPos(trunkX, trunkY + height, trunkZ + 1);
            branches.put(this.generateTopBranch(world, rand, sideBranch, 3, trunkX, trunkY, trunkZ), sideBranch);
            sideBranch = new BlockPos(trunkX + 1, trunkY + height, trunkZ);
            branches.put(this.generateTopBranch(world, rand, sideBranch, 7, trunkX, trunkY, trunkZ), sideBranch);
        }
        for (Map.Entry branch : branches.entrySet()) {
            this.generateBranchLeaves(world, rand, (BlockPos)branch.getValue(), (List)branch.getKey(), trunkX, trunkY, trunkZ);
        }
        ArrayList<BlockPos> rootBlocks = new ArrayList<BlockPos>();
        sideBranch = new BlockPos(trunkX + rand.nextInt(2), trunkY, trunkZ);
        rootBlocks.addAll(this.generateRoot(world, rand, sideBranch, 0, trunkX, trunkY, trunkZ));
        sideBranch = new BlockPos(trunkX, trunkY, trunkZ + rand.nextInt(2));
        rootBlocks.addAll(this.generateRoot(world, rand, sideBranch, 2, trunkX, trunkY, trunkZ));
        sideBranch = new BlockPos(trunkX + rand.nextInt(2), trunkY, trunkZ + 1);
        rootBlocks.addAll(this.generateRoot(world, rand, sideBranch, 4, trunkX, trunkY, trunkZ));
        sideBranch = new BlockPos(trunkX + 1, trunkY, trunkZ + rand.nextInt(2));
        rootBlocks.addAll(this.generateRoot(world, rand, sideBranch, 6, trunkX, trunkY, trunkZ));
        for (BlockPos rootBlock : rootBlocks) {
            BlockPos pos;
            if (rand.nextInt(4) != 0) continue;
            Vec3d vec3d = new Vec3d((double)rootBlock.func_177958_n() + 0.5, 0.0, (double)rootBlock.func_177952_p() + 0.5);
            if (!(vec3d.func_186679_c((double)trunkX + 1.0, 0.0, (double)trunkZ + 1.0) >= 9.0) || !world.func_175623_d(rootBlock.func_177984_a())) continue;
            int rootHeight = 1 + rand.nextInt(3);
            for (int yo = 0; yo < rootHeight && world.func_175623_d(pos = rootBlock.func_177981_b(1 + yo)); ++yo) {
                this.setBlock(world, pos, this.roots, true, trunkX, trunkY, trunkZ);
            }
        }
        return true;
    }

    private void generateTrunkCrossSection(World world, Random rand, int x, int y, int z, IBlockState log, int trunkX, int trunkY, int trunkZ) {
        for (int xo = 0; xo < 2; ++xo) {
            for (int zo = 0; zo < 2; ++zo) {
                this.setBlock(world, new BlockPos(x + xo, y, z + zo), log, false, trunkX, trunkY, trunkZ);
            }
        }
    }

    private int[] getDirOffset(int dir) {
        int[] offset = new int[2];
        switch (dir) {
            case 0: {
                offset[1] = -1;
                break;
            }
            case 1: {
                offset[0] = -1;
                offset[1] = -1;
                break;
            }
            case 2: {
                offset[0] = -1;
                break;
            }
            case 3: {
                offset[0] = -1;
                offset[1] = 1;
                break;
            }
            case 4: {
                offset[1] = 1;
                break;
            }
            case 5: {
                offset[0] = 1;
                offset[1] = 1;
                break;
            }
            case 6: {
                offset[0] = 1;
                break;
            }
            case 7: {
                offset[0] = 1;
                offset[1] = -1;
            }
        }
        return offset;
    }

    private List<BlockPos> generateRoot(World world, Random rand, BlockPos start, int dir, int trunkX, int trunkY, int trunkZ) {
        List<BlockPos> root = this.generateBranchPositions(rand, start, dir, 2 + rand.nextInt(2), 0.9, 0.8, (i, remainingBlocks) -> i < 2 ? 0 : (rand.nextInt((i - 2) * 2 + 2) == 0 ? 0 : -1), (i, length) -> true);
        for (BlockPos pos : root) {
            BlockPos rel = pos.func_177973_b((Vec3i)start);
            if (Math.abs(rel.func_177958_n()) + Math.abs(rel.func_177956_o()) + Math.abs(rel.func_177952_p()) < 1) continue;
            root.add(root.indexOf(pos), pos.func_177984_a());
            break;
        }
        BlockPos end = root.get(root.size() - 1);
        switch (dir) {
            case 0: {
                root.addAll(this.generateSubRootPositions(world, rand, end, 1));
                root.addAll(this.generateSubRootPositions(world, rand, end, 7));
                break;
            }
            case 1: {
                root.addAll(this.generateSubRootPositions(world, rand, end, 0));
                root.addAll(this.generateSubRootPositions(world, rand, end, 2));
                break;
            }
            case 2: {
                root.addAll(this.generateSubRootPositions(world, rand, end, 1));
                root.addAll(this.generateSubRootPositions(world, rand, end, 3));
                break;
            }
            case 3: {
                root.addAll(this.generateSubRootPositions(world, rand, end, 2));
                root.addAll(this.generateSubRootPositions(world, rand, end, 4));
                break;
            }
            case 4: {
                root.addAll(this.generateSubRootPositions(world, rand, end, 3));
                root.addAll(this.generateSubRootPositions(world, rand, end, 5));
                break;
            }
            case 5: {
                root.addAll(this.generateSubRootPositions(world, rand, end, 4));
                root.addAll(this.generateSubRootPositions(world, rand, end, 6));
                break;
            }
            case 6: {
                root.addAll(this.generateSubRootPositions(world, rand, end, 5));
                root.addAll(this.generateSubRootPositions(world, rand, end, 7));
                break;
            }
            case 7: {
                root.addAll(this.generateSubRootPositions(world, rand, end, 6));
                root.addAll(this.generateSubRootPositions(world, rand, end, 1));
            }
        }
        for (BlockPos pos : root) {
            this.setBlock(world, pos, this.log, true, trunkX, trunkY, trunkZ);
        }
        return root;
    }

    private List<BlockPos> generateSubRootPositions(World world, Random rand, BlockPos start, int dir) {
        return this.generateBranchPositions(rand, start, dir, 1 + rand.nextInt(4), 0.5, 1.0, (i, remainingBlocks) -> rand.nextInt(i * 2 + 1) == 0 ? 0 : -1, (i, length) -> true);
    }

    private List<BlockPos> generateSideBranch(World world, Random rand, BlockPos start, int dir, int trunkX, int trunkY, int trunkZ) {
        List<BlockPos> branch = this.generateSideBranchPositions(rand, start, dir);
        if (branch.size() > 3) {
            BlockPos end = branch.get(3);
            switch (dir) {
                case 0: {
                    branch.addAll(this.generateSideBranchPositions(rand, end, 1));
                    branch.addAll(this.generateSideBranchPositions(rand, end, 7));
                    break;
                }
                case 1: {
                    branch.addAll(this.generateSideBranchPositions(rand, end, 0));
                    branch.addAll(this.generateSideBranchPositions(rand, end, 2));
                    break;
                }
                case 2: {
                    branch.addAll(this.generateSideBranchPositions(rand, end, 1));
                    branch.addAll(this.generateSideBranchPositions(rand, end, 3));
                    break;
                }
                case 3: {
                    branch.addAll(this.generateSideBranchPositions(rand, end, 2));
                    branch.addAll(this.generateSideBranchPositions(rand, end, 4));
                    break;
                }
                case 4: {
                    branch.addAll(this.generateSideBranchPositions(rand, end, 3));
                    branch.addAll(this.generateSideBranchPositions(rand, end, 5));
                    break;
                }
                case 5: {
                    branch.addAll(this.generateSideBranchPositions(rand, end, 4));
                    branch.addAll(this.generateSideBranchPositions(rand, end, 6));
                    break;
                }
                case 6: {
                    branch.addAll(this.generateSideBranchPositions(rand, end, 5));
                    branch.addAll(this.generateSideBranchPositions(rand, end, 7));
                    break;
                }
                case 7: {
                    branch.addAll(this.generateSideBranchPositions(rand, end, 6));
                    branch.addAll(this.generateSideBranchPositions(rand, end, 1));
                }
            }
        }
        for (BlockPos pos : branch) {
            this.setBlock(world, pos, this.log, true, trunkX, trunkY, trunkZ);
        }
        return branch;
    }

    private List<BlockPos> generateSideBranchPositions(Random rand, BlockPos start, int dir) {
        return this.generateBranchPositions(rand, start, dir, 6 + rand.nextInt(5), 0.3, 0.6, (i, remainingBlocks) -> (double)i.intValue() < remainingBlocks / 2.0 ? 1 : ((double)i.intValue() >= remainingBlocks - 1.0 && rand.nextInt(2) == 0 ? -1 : 0), (i, length) -> true);
    }

    private List<BlockPos> generateTopBranch(World world, Random rand, BlockPos start, int dir, int trunkX, int trunkY, int trunkZ) {
        List<BlockPos> branch = this.generateBranchPositions(rand, start, dir, 5 + rand.nextInt(5), 0.1, 0.2, (i, remainingBlocks) -> (double)i.intValue() < remainingBlocks - 1.0 ? 1 : 0, (i, length) -> (double)i.intValue() >= length - 1.0);
        for (BlockPos pos : branch) {
            this.setBlock(world, pos, this.log, true, trunkX, trunkY, trunkZ);
        }
        return branch;
    }

    public List<BlockPos> generateBranchPositions(Random rand, BlockPos start, int dir, int length, double defaultCurveWeight, double directedCurveWeight, BiFunction<Integer, Double, Integer> heightFunction, BiFunction<Integer, Double, Boolean> forceMoveFunction) {
        double remainingBlocks = length;
        ArrayList<BlockPos> branchBlocks = new ArrayList<BlockPos>(length);
        BlockPos branch = start;
        double rx = rand.nextDouble() * defaultCurveWeight * 2.0 - defaultCurveWeight;
        double rz = rand.nextDouble() * defaultCurveWeight * 2.0 - defaultCurveWeight;
        int[] offset = this.getDirOffset(dir);
        if (offset[0] != 0) {
            rx = (double)offset[0] * directedCurveWeight;
        }
        if (offset[1] != 0) {
            rz = (double)offset[1] * directedCurveWeight;
        }
        branchBlocks.add(branch);
        int i = 0;
        while ((double)i < remainingBlocks) {
            int zo;
            int xo = rand.nextDouble() < Math.abs(rx) ? (int)Math.signum(rx) : 0;
            int n = zo = rand.nextDouble() < Math.abs(rz) ? (int)Math.signum(rz) : 0;
            if (zo == 0 && xo == 0 && forceMoveFunction.apply(i, remainingBlocks).booleanValue()) {
                if (rand.nextDouble() * Math.abs(rx) > rand.nextDouble() * Math.abs(rz)) {
                    xo = (int)Math.signum(rx);
                } else {
                    zo = (int)Math.signum(rz);
                }
            }
            if (Math.abs(xo) == Math.abs(zo) && xo != 0) {
                remainingBlocks -= 0.414;
            }
            branch = branch.func_177982_a(xo, heightFunction.apply(i, remainingBlocks).intValue(), zo);
            branchBlocks.add(branch);
            ++i;
        }
        return branchBlocks;
    }

    private void generateBranchLeaves(World world, Random rand, BlockPos start, List<BlockPos> branchBlocks, int trunkX, int trunkY, int trunkZ) {
        for (BlockPos branchBlock : branchBlocks) {
            int dist = (int)branchBlock.func_185332_f(start.func_177958_n(), start.func_177956_o(), start.func_177952_p());
            if (dist < 2) continue;
            block1: for (EnumFacing side : LEAVES_OFFSETS) {
                int leavesLength = 3 + (rand.nextInt(5) == 0 ? rand.nextInt(dist + 1) : rand.nextInt(dist / 2 + 1));
                for (int yo = 0; yo > -leavesLength; --yo) {
                    BlockPos leafPos = branchBlock.func_177972_a(side).func_177982_a(0, yo, 0);
                    IBlockState state = yo == 0 ? this.leavesTop : this.leavesMiddle;
                    if (!world.func_175623_d(leafPos)) continue block1;
                    if (yo == -leavesLength + 1 || yo < -1 && !world.func_175623_d(leafPos.func_177977_b())) {
                        state = this.leavesBottom;
                        this.setBlock(world, leafPos, state, true, trunkX, trunkY, trunkZ);
                        continue block1;
                    }
                    this.setBlock(world, leafPos, state, true, trunkX, trunkY, trunkZ);
                }
            }
        }
    }

    protected void setBlock(World world, BlockPos pos, IBlockState state, boolean registerSmallFacePositions, int trunkX, int trunkY, int trunkZ) {
        this.func_175903_a(world, pos, state);
        if (this.guard != null) {
            this.guard.setGuarded(world, pos, true);
        }
        if ((pos.func_177958_n() < trunkX || pos.func_177952_p() < trunkZ || pos.func_177958_n() > trunkX + 1 || pos.func_177952_p() > trunkZ + 1) && registerSmallFacePositions && this.location != null && state.func_177230_c() == BlockRegistry.LOG_SPIRIT_TREE) {
            this.location.addSmallFacePosition(pos);
        }
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])EnumFacing.field_176754_o);
        builder.add((Object)EnumFacing.UP);
        LEAVES_OFFSETS = builder.build();
    }
}

