/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import java.util.Random;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.common.block.container.BlockChestBetweenlands;
import thebetweenlands.common.block.container.BlockItemShelf;
import thebetweenlands.common.block.structure.BlockCompactedMudSlope;
import thebetweenlands.common.block.structure.BlockMudBrickSpikeTrap;
import thebetweenlands.common.block.structure.BlockSlabBetweenlands;
import thebetweenlands.common.block.structure.BlockStairsBetweenlands;
import thebetweenlands.common.world.gen.feature.structure.WorldGenSludgeWormDungeon;
import thebetweenlands.common.world.gen.feature.structure.utils.SludgeWormMazeBlockHelper;

public class SludgeWormMazeMicroBuilds {
    private SludgeWormMazeBlockHelper blockHelper;
    private final WorldGenSludgeWormDungeon dungeon;

    public SludgeWormMazeMicroBuilds(WorldGenSludgeWormDungeon dungeon) {
        this.dungeon = dungeon;
        this.blockHelper = new SludgeWormMazeBlockHelper(dungeon);
    }

    public void selectFeature(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        if (rand.nextInt(20) < 5) {
            this.buildWallPillarCentral(world, pos, facing, rand, level, layer);
        } else {
            int type = rand.nextInt(9);
            switch (type) {
                case 0: {
                    this.buildCryptBench1(world, pos, facing, rand, level, layer);
                    break;
                }
                case 1: {
                    this.buildWallPillarRoom(world, pos, facing, rand, level, layer);
                    break;
                }
                case 2: {
                    this.buildBigPillarCandle(world, pos, facing, rand, level, layer);
                    break;
                }
                case 3: {
                    this.buildWallPillarShelfRoom(world, pos, facing, rand, level, layer);
                    break;
                }
                case 4: {
                    this.buildBigPillarTableRoom(world, pos, facing, rand, level, layer);
                    break;
                }
                case 5: {
                    this.buildWallPillarRoomLowJamb(world, pos, facing, rand, level, layer);
                    break;
                }
                case 6: {
                    this.buildOpenShrineRoom(world, pos, facing, rand, level, layer);
                    break;
                }
                case 7: {
                    this.buildMudWallJamb(world, pos, facing, rand, level, layer);
                    break;
                }
                case 8: {
                    this.buildCubbyHole(world, pos, facing, rand, level, layer);
                }
            }
        }
    }

    public void spikeFeature(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        this.rotatedCubeVolume(world, rand, pos, 0, -1, 0, this.blockHelper.MUD_TILES_SPIKE_TRAP, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, -1, 1, this.blockHelper.MUD_TILES_SPIKE_TRAP, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, -1, -1, this.blockHelper.MUD_TILES_SPIKE_TRAP, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, -1, 1, this.blockHelper.MUD_TILES_SPIKE_TRAP, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, -1, -1, this.blockHelper.MUD_TILES_SPIKE_TRAP, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 1, 0, this.blockHelper.MUD_BRICKS_SPIKE_TRAP.func_177226_a((IProperty)BlockMudBrickSpikeTrap.field_176387_N, (Comparable)facing.func_176746_e()), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -2, 1, 0, this.blockHelper.MUD_BRICKS_SPIKE_TRAP.func_177226_a((IProperty)BlockMudBrickSpikeTrap.field_176387_N, (Comparable)facing.func_176734_d().func_176746_e()), 1, 1, 1, facing);
    }

    private void buildCryptBench1(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        this.rotatedCubeVolume(world, rand, pos, -1, 0, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 0, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 2, -1, this.blockHelper.getStairsForLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 2, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 2, -1, this.blockHelper.getStairsForLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 1, -1, this.blockHelper.getRandomLootUrn(rand, facing), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, -1, this.blockHelper.getRandomLitCandle(rand), 1, 1, 1, facing);
    }

    private void buildWallPillarRoom(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        this.rotatedCubeVolume(world, rand, pos, -1, 0, 1, this.blockHelper.MUD_BRICK_WALL, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 1, this.blockHelper.MUD_BRICK_WALL, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 0, 0, this.blockHelper.getRandomLootUrn(rand, facing), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, -1, this.blockHelper.getRandomLootUrn(rand, facing), 1, 1, 1, facing);
    }

    private void buildBigPillarCandle(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        this.rotatedCubeVolume(world, rand, pos, 0, 0, 0, this.blockHelper.MUD_FLOWER_POT_CANDLE_UNLIT, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 0, 1, this.blockHelper.getPillarsForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 1, 1, this.blockHelper.getPillarsForLevel(rand, level, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 2, 1, this.blockHelper.getPillarsForLevel(rand, level, 3), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 2, 1, this.blockHelper.getStairsForLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 2, 1, this.blockHelper.getStairsForLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
    }

    private void buildWallPillarShelfRoom(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        this.rotatedCubeVolume(world, rand, pos, -1, 0, 1, this.blockHelper.MUD_BRICK_WALL, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 1, this.blockHelper.MUD_BRICK_WALL, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 0, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 0, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 1, -1, this.blockHelper.ITEM_SHELF.func_177226_a((IProperty)BlockItemShelf.FACING, (Comparable)facing.func_176734_d()), 3, 2, 1, facing);
    }

    private void buildWallPillarCentral(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        this.rotatedCubeVolume(world, rand, pos, 0, 0, 1, this.blockHelper.MUD_BRICK_WALL, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 0, 0, this.blockHelper.CHEST.func_177226_a((IProperty)BlockChestBetweenlands.field_176459_a, (Comparable)facing.func_176734_d()), 1, 1, 1, facing);
    }

    private void buildBigPillarTableRoom(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 1, this.blockHelper.getPillarsForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, 1, this.blockHelper.getPillarsForLevel(rand, level, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 2, 1, this.blockHelper.getPillarsForLevel(rand, level, 3), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 2, 1, this.blockHelper.getPillarsForLevel(rand, level, 3), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 0, 1, this.blockHelper.getPillarsForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 1, 1, this.blockHelper.getPillarsForLevel(rand, level, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 2, 1, this.blockHelper.getPillarsForLevel(rand, level, 3), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 0, 0, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 0, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 1, 0, this.blockHelper.getRandomLootUrn(rand, facing), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 1, -1, this.blockHelper.getRandomLootUrn(rand, facing), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, -1, this.blockHelper.getRandomLitCandle(rand), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 2, 0, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 2, 0, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 2, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 2, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 0, -1, this.blockHelper.getStairsForLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, -1, this.blockHelper.getStairsForLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
    }

    private void buildWallPillarRoomLowJamb(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        this.rotatedCubeVolume(world, rand, pos, -1, 0, 1, this.blockHelper.MUD_BRICK_WALL, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 1, this.blockHelper.MUD_BRICK_WALL, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 2, 1, this.blockHelper.getMudBricksForLevel(rand, level, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 2, 1, this.blockHelper.getMudBricksForLevel(rand, level, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 2, 1, this.blockHelper.getMudBricksForLevel(rand, level, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 0, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 2, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 0, -1, this.blockHelper.getStairsForLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, -1, this.blockHelper.getStairsForLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 2, -1, this.blockHelper.getStairsForLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 2, -1, this.blockHelper.getStairsForLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 1, -1, this.blockHelper.getRandomLootUrn(rand, facing), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, -1, this.blockHelper.getRandomLootUrn(rand, facing), 1, 1, 1, facing);
    }

    private void buildOpenShrineRoom(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        this.rotatedCubeVolume(world, rand, pos, -1, 0, 1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 0, 0, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 0, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 1, 0, this.blockHelper.getRandomLitCandle(rand), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, 0, this.blockHelper.getRandomLitCandle(rand), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 0, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 1, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 1, -1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 2, -1, this.blockHelper.getRandomLootUrn(rand, facing), 1, 1, 1, facing);
    }

    private void buildMudWallJamb(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        this.rotatedCubeVolume(world, rand, pos, -1, 0, 1, this.blockHelper.MUD_BRICK_WALL, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 1, this.blockHelper.MUD_BRICK_WALL, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 2, 1, this.blockHelper.MUD_BRICK_WALL, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 0, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 0, 0, this.blockHelper.getStairsForLevel(rand, level, facing, BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 0, this.blockHelper.getStairsForLevel(rand, level, facing, BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 1, -1, this.blockHelper.getRandomLitCandle(rand), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
    }

    private void buildCubbyHole(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        this.rotatedCubeVolume(world, rand, pos, 0, 0, -1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 1, -1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 2, -1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 0, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, -1, this.blockHelper.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 1, -1, this.blockHelper.getRandomLootUrn(rand, facing), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, -1, this.blockHelper.getRandomLootUrn(rand, facing), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 2, 0, this.blockHelper.getStairsForLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 2, 0, this.blockHelper.getStairsForLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 2, 0, this.blockHelper.getStairsForLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 3, 1, this.blockHelper.getMudBricksForLevel(rand, level, 1), 1, 1, 1, facing);
    }

    public void addBarrisheeCubby(World world, BlockPos pos, EnumFacing facing, Random rand, int level) {
        for (int x = 0; x < 9; ++x) {
            for (int z = 0; z < 3; ++z) {
                int y;
                for (y = 1; y <= 3; ++y) {
                    if (x <= 0 || x >= 8 || z <= 0 || z >= 3) continue;
                    this.dungeon.func_175903_a(world, pos.func_177982_a(x, y, z), Blocks.field_150350_a.func_176223_P());
                }
                this.dungeon.func_175903_a(world, pos.func_177982_a(x, 0, z), this.blockHelper.getTilesForLevel(rand, 3));
                this.dungeon.func_175903_a(world, pos.func_177982_a(x, 4, z), this.blockHelper.getMudBricksForLevel(rand, 3, 1));
                if ((x == 0 || x == 8) && z > 0) {
                    for (y = 1; y <= 3; ++y) {
                        this.dungeon.func_175903_a(world, pos.func_177982_a(x, y, z), this.blockHelper.getMudBricksForLevel(rand, 3, y));
                    }
                }
                if (z != 0) continue;
                for (y = 1; y <= 3; ++y) {
                    this.dungeon.func_175903_a(world, pos.func_177982_a(x, y, 0), this.blockHelper.getMudBricksForLevel(rand, 3, y));
                }
            }
        }
        this.dungeon.func_175903_a(world, pos.func_177982_a(7, 0, 1), this.blockHelper.MUD_TILES_WATER);
        this.dungeon.func_175903_a(world, pos.func_177982_a(3, 0, 2), this.blockHelper.MUD_TILES_WATER);
        this.dungeon.func_175903_a(world, pos.func_177982_a(3, 0, 1), this.blockHelper.COMPACTED_MUD);
        this.dungeon.func_175903_a(world, pos.func_177982_a(2, 0, 1), this.blockHelper.COMPACTED_MUD);
        this.dungeon.func_175903_a(world, pos.func_177982_a(2, 0, 2), this.blockHelper.COMPACTED_MUD);
        this.dungeon.func_175903_a(world, pos.func_177982_a(3, 1, 1), this.blockHelper.TALL_SLUDGECREEP);
        this.dungeon.func_175903_a(world, pos.func_177982_a(2, 1, 1), this.blockHelper.getRandomMushroom(rand));
        this.dungeon.func_175903_a(world, pos.func_177982_a(2, 1, 2), this.blockHelper.TALL_SLUDGECREEP);
        this.dungeon.func_175903_a(world, pos.func_177982_a(5, 1, 1), this.blockHelper.getRandomLootUrn(rand, facing.func_176734_d()));
        this.dungeon.func_175903_a(world, pos.func_177982_a(1, 1, 1), this.blockHelper.CHEST.func_177226_a((IProperty)BlockChestBetweenlands.field_176459_a, (Comparable)facing.func_176735_f()));
        this.dungeon.func_175903_a(world, pos.func_177982_a(1, 1, 2), this.blockHelper.CHEST.func_177226_a((IProperty)BlockChestBetweenlands.field_176459_a, (Comparable)facing.func_176735_f()));
        this.dungeon.func_175903_a(world, pos.func_177982_a(1, 3, 1), this.blockHelper.getMudBricksForLevel(rand, level, 0));
        this.dungeon.func_175903_a(world, pos.func_177982_a(1, 3, 2), this.blockHelper.getMudBricksForLevel(rand, level, 0));
        this.dungeon.func_175903_a(world, pos.func_177982_a(1, 2, 1), this.blockHelper.getStairsForLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.TOP));
        this.dungeon.func_175903_a(world, pos.func_177982_a(1, 2, 2), this.blockHelper.getStairsForLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.TOP));
        this.dungeon.func_175903_a(world, pos.func_177982_a(2, 3, 1), this.blockHelper.getStairsForLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.TOP));
        this.dungeon.func_175903_a(world, pos.func_177982_a(2, 3, 2), this.blockHelper.getStairsForLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.TOP));
        this.dungeon.func_175903_a(world, pos.func_177982_a(2, 1, 2), this.blockHelper.GROUND_ITEM);
        this.blockHelper.setBattleAxe(world, rand, pos.func_177982_a(2, 1, 2));
    }

    public void buildCryptCrawlerWalkways(World world, BlockPos pos, EnumFacing facing, Random rand) {
        this.buildCryptCrawlerWalkwaysStairsNormal(world, pos.func_177982_a(20, -10, 1), facing, rand);
        this.buildCryptCrawlerWalkwaysStairsNormal(world, pos.func_177982_a(8, -10, 2), facing.func_176734_d(), rand);
        this.buildCryptCrawlerWalkwaysStairsNormal(world, pos.func_177982_a(25, -10, 2), facing.func_176734_d(), rand);
        this.buildCryptCrawlerWalkwaysStairsNormal(world, pos.func_177982_a(28, -16, 1), facing, rand);
        this.buildCryptCrawlerWalkwaysStairsNormal(world, pos.func_177982_a(8, -16, 2), facing, rand);
        this.buildCryptCrawlerWalkwaysStairsNormal(world, pos.func_177982_a(1, -10, 10), facing.func_176735_f(), rand);
        this.buildCryptCrawlerWalkwaysStairsNormal(world, pos.func_177982_a(2, -10, 22), facing.func_176734_d().func_176735_f(), rand);
        this.buildCryptCrawlerWalkwaysStairsNormal(world, pos.func_177982_a(1, -10, 25), facing.func_176735_f(), rand);
        this.buildCryptCrawlerWalkwaysStairsNormal(world, pos.func_177982_a(2, -16, 2), facing.func_176735_f(), rand);
        this.rotatedCubeVolume(world, rand, pos, 1, -18, 27, this.blockHelper.AIR, 1, 2, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, 14, -4, 1, this.blockHelper.COMPACTED_MUD, 1, 4, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 31, -4, 1, this.blockHelper.COMPACTED_MUD, 1, 4, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, -10, 1, this.blockHelper.COMPACTED_MUD, 1, 4, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 22, -10, 1, this.blockHelper.COMPACTED_MUD, 1, 4, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 31, -10, 1, this.blockHelper.COMPACTED_MUD, 1, 4, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, -16, 1, this.blockHelper.COMPACTED_MUD, 1, 4, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 31, -16, 1, this.blockHelper.COMPACTED_MUD, 1, 4, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, -18, 0, this.blockHelper.COMPACTED_MUD, 32, 19, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, -18, 1, this.blockHelper.COMPACTED_MUD, 1, 19, 31, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, -4, 16, this.blockHelper.COMPACTED_MUD, 2, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, -4, 31, this.blockHelper.COMPACTED_MUD, 2, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, -10, 8, this.blockHelper.COMPACTED_MUD, 2, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, -10, 24, this.blockHelper.COMPACTED_MUD, 2, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, -10, 31, this.blockHelper.COMPACTED_MUD, 2, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, -16, 31, this.blockHelper.COMPACTED_MUD, 2, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, -4, 1, this.blockHelper.ROOT, 1, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 14, -8, 1, this.blockHelper.ROOT, 1, 2, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 22, -14, 1, this.blockHelper.ROOT, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 21, -14, 2, this.blockHelper.ROOT, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 19, -16, 2, this.blockHelper.ROOT, 1, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, -8, 16, this.blockHelper.ROOT, 2, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, -16, 10, this.blockHelper.ROOT, 1, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, -14, 9, this.blockHelper.ROOT, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, -14, 8, this.blockHelper.ROOT, 1, 2, 1, facing);
    }

    public void buildCryptCrawlerWalkwaysStairsNormal(World world, BlockPos pos, EnumFacing facing, Random rand) {
        this.rotatedCubeVolume(world, rand, pos, 0, 0, 0, this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 0, 0, this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)facing.func_176735_f()).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 1, 0, this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -2, 1, 0, this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)facing.func_176735_f()).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -2, 2, 0, this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -3, 2, 0, this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)facing.func_176735_f()).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -3, 3, 0, this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -4, 3, 0, this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)facing.func_176735_f()).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -4, 4, 0, this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -5, 5, 0, this.blockHelper.COMPACTED_MUD_SLOPE.func_177226_a((IProperty)BlockCompactedMudSlope.field_176309_a, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)BlockCompactedMudSlope.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -4, 5, 0, this.blockHelper.AIR, 3, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -3, 4, 0, this.blockHelper.AIR, 3, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -2, 3, 0, this.blockHelper.AIR, 3, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -2, 0, 0, this.blockHelper.ROOT, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -3, 0, 0, this.blockHelper.ROOT, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -4, 0, 0, this.blockHelper.ROOT, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -5, 0, 0, this.blockHelper.ROOT, 1, 4, 1, facing);
    }

    public void buildCryptCrawlerBottomTunnels(World world, BlockPos pos, EnumFacing facing, Random rand) {
        this.rotatedCubeVolume(world, rand, pos, 6, 1, 1, this.blockHelper.AIR, 20, 3, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 2, 2, this.blockHelper.AIR, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 1, 3, this.blockHelper.COMPACTED_MUD, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 26, 2, 2, this.blockHelper.AIR, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 25, 1, 3, this.blockHelper.COMPACTED_MUD, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 0, 1, this.blockHelper.COMPACTED_MUD, 20, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 1, 4, this.blockHelper.COMPACTED_MUD, 20, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 1, 0, this.blockHelper.COMPACTED_MUD, 20, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 4, 1, this.blockHelper.COMPACTED_MUD, 20, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 1, 1, this.blockHelper.COMPACTED_MUD, 4, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 1, 2, this.blockHelper.COMPACTED_MUD, 2, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 22, 1, 1, this.blockHelper.COMPACTED_MUD, 4, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 24, 1, 2, this.blockHelper.COMPACTED_MUD, 2, 1, 1, facing);
        if (facing != EnumFacing.EAST) {
            this.rotatedCubeVolume(world, rand, pos, 13, 1, 3, this.blockHelper.COMPACTED_MUD, 6, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 14, 2, 3, this.blockHelper.COMPACTED_MUD, 4, 1, 1, facing);
        }
    }

    public void buildCryptCrawlerTunnelsConnect(World world, BlockPos pos, EnumFacing facing, Random rand) {
        this.rotatedCubeVolume(world, rand, pos, 1, 4, 9, this.blockHelper.AIR, 3, 1, 7, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 8, 31, this.blockHelper.COMPACTED_MUD, 8, 7, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 8, 28, this.blockHelper.COMPACTED_MUD, 1, 7, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 9, 28, this.blockHelper.COMPACTED_MUD, 3, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 8, 27, this.blockHelper.COMPACTED_MUD, 7, 1, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 9, 27, this.blockHelper.COMPACTED_MUD, 1, 5, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 9, 26, this.blockHelper.COMPACTED_MUD, 1, 6, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 8, 25, this.blockHelper.COMPACTED_MUD, 1, 5, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 9, 30, this.blockHelper.COMPACTED_MUD, 3, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 10, 30, this.blockHelper.COMPACTED_MUD, 4, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 11, 30, this.blockHelper.COMPACTED_MUD, 2, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 12, 29, this.blockHelper.COMPACTED_MUD, 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 13, 26, this.blockHelper.COMPACTED_MUD, 1, 1, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 14, 26, this.blockHelper.COMPACTED_MUD, 1, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 15, 27, this.blockHelper.COMPACTED_MUD, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 12, 23, this.blockHelper.COMPACTED_MUD, 3, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 11, 21, this.blockHelper.COMPACTED_MUD, 3, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 10, 19, this.blockHelper.COMPACTED_MUD, 3, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 9, 17, this.blockHelper.COMPACTED_MUD, 3, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 8, 15, this.blockHelper.COMPACTED_MUD, 3, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 7, 13, this.blockHelper.COMPACTED_MUD, 3, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 6, 11, this.blockHelper.COMPACTED_MUD, 3, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 5, 9, this.blockHelper.COMPACTED_MUD, 3, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 4, 7, this.blockHelper.COMPACTED_MUD, 3, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 8, 25, this.blockHelper.COMPACTED_MUD, 1, 7, 6, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 7, 25, this.blockHelper.COMPACTED_MUD, 1, 8, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 14, 25, this.blockHelper.COMPACTED_MUD, 3, 1, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 14, 29, this.blockHelper.COMPACTED_MUD, 4, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 14, 27, this.blockHelper.COMPACTED_MUD, 2, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 7, 22, this.blockHelper.COMPACTED_MUD, 4, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 6, 21, this.blockHelper.COMPACTED_MUD, 4, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 6, 20, this.blockHelper.COMPACTED_MUD, 3, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 5, 18, this.blockHelper.COMPACTED_MUD, 3, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 4, 15, this.blockHelper.COMPACTED_MUD, 6, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 4, 15, this.blockHelper.COMPACTED_MUD, 4, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 14, this.blockHelper.COMPACTED_MUD, 6, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 13, this.blockHelper.COMPACTED_MUD, 2, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 3, 13, this.blockHelper.COMPACTED_MUD, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 2, 12, this.blockHelper.COMPACTED_MUD, 2, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, 11, this.blockHelper.COMPACTED_MUD, 2, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, 10, this.blockHelper.COMPACTED_MUD, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 12, 26, this.blockHelper.COMPACTED_MUD, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 13, 28, this.blockHelper.COMPACTED_MUD, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 9, 27, this.blockHelper.COMPACTED_MUD, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 9, 29, this.blockHelper.COMPACTED_MUD, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 9, 29, this.blockHelper.COMPACTED_MUD, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 13, 25, this.blockHelper.COMPACTED_MUD, 3, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 7, 24, this.blockHelper.COMPACTED_MUD, 1, 6, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 8, 23, this.blockHelper.COMPACTED_MUD, 1, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 8, 22, this.blockHelper.COMPACTED_MUD, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 10, 22, this.blockHelper.COMPACTED_MUD, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 7, 21, this.blockHelper.COMPACTED_MUD, 1, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 7, 20, this.blockHelper.COMPACTED_MUD, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 6, 19, this.blockHelper.COMPACTED_MUD, 1, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 6, 18, this.blockHelper.COMPACTED_MUD, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 5, 17, this.blockHelper.COMPACTED_MUD, 1, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 5, 15, this.blockHelper.COMPACTED_MUD, 1, 3, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 4, 9, this.blockHelper.COMPACTED_MUD, 1, 2, 5, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 3, 14, this.blockHelper.COMPACTED_MUD, 1, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 6, 13, this.blockHelper.COMPACTED_MUD, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 4, 9, this.blockHelper.COMPACTED_MUD, 1, 1, 7, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 5, 11, this.blockHelper.COMPACTED_MUD, 1, 1, 7, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 6, 13, this.blockHelper.COMPACTED_MUD, 1, 1, 7, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 7, 15, this.blockHelper.COMPACTED_MUD, 1, 1, 7, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 8, 17, this.blockHelper.COMPACTED_MUD, 1, 1, 8, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 9, 19, this.blockHelper.COMPACTED_MUD, 1, 1, 6, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 10, 21, this.blockHelper.COMPACTED_MUD, 1, 1, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 11, 23, this.blockHelper.COMPACTED_MUD, 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 1, 15, this.blockHelper.AIR, 3, 3, 9, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 0, 15, this.blockHelper.COMPACTED_MUD, 4, 1, 9, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 0, 20, this.blockHelper.COMPACTED_MUD, 1, 1, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 0, 24, this.blockHelper.COMPACTED_MUD, 3, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 1, 14, this.blockHelper.COMPACTED_MUD, 3, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 1, 15, this.blockHelper.COMPACTED_MUD, 1, 2, 5, facing);
        this.rotatedCubeVolume(world, rand, pos, 9, 1, 20, this.blockHelper.COMPACTED_MUD, 1, 2, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 1, 23, this.blockHelper.COMPACTED_MUD, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 1, 24, this.blockHelper.COMPACTED_MUD, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 10, 1, 24, this.blockHelper.COMPACTED_MUD, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 1, 25, this.blockHelper.COMPACTED_MUD, 3, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 3, 15, this.blockHelper.COMPACTED_MUD, 1, 1, 9, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 3, 20, this.blockHelper.COMPACTED_MUD, 1, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 3, 24, this.blockHelper.COMPACTED_MUD, 2, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 4, 18, this.blockHelper.COMPACTED_MUD, 3, 1, 5, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, 12, this.blockHelper.COMPACTED_MUD, 2, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 2, 14, this.blockHelper.COMPACTED_MUD, 2, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 1, 13, this.blockHelper.COMPACTED_MUD_MIRAGE, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 1, 24, this.blockHelper.COMPACTED_MUD_MIRAGE, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 16, this.blockHelper.MUD_TILES_DECAY, 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 18, this.blockHelper.MUD_TILES, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 21, this.blockHelper.MUD_TILES, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 22, this.blockHelper.MUD_TILES_DECAY, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 0, 15, this.blockHelper.MUD_TILES, 1, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 0, 16, this.blockHelper.MUD_TILES_DECAY, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 0, 16, this.blockHelper.MUD_TILES_DECAY, 2, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 0, 17, this.blockHelper.MUD_TILES_DECAY, 2, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 0, 18, this.blockHelper.MUD_TILES_DECAY, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 0, 17, this.blockHelper.MUD_TILES, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 0, 18, this.blockHelper.MUD_TILES, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 0, 19, this.blockHelper.MUD_TILES_CRACKED, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 0, 20, this.blockHelper.MUD_TILES_DECAY, 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 0, 22, this.blockHelper.MUD_TILES, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 0, 23, this.blockHelper.MUD_TILES_DECAY, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 0, 19, this.blockHelper.MUD_TILES_DECAY, 1, 1, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 0, 24, this.blockHelper.MUD_TILES_DECAY, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 0, 19, this.blockHelper.MUD_TILES, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 0, 19, this.blockHelper.MUD_TILES, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 0, 20, this.blockHelper.MUD_TILES_DECAY, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 0, 21, this.blockHelper.MUD_TILES_CRACKED, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 0, 20, this.blockHelper.MUD_TILES, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 0, 20, this.blockHelper.MUD_TILES_DECAY, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 0, 20, this.blockHelper.MUD_TILES, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 0, 21, this.blockHelper.MUD_TILES_DECAY, 3, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 0, 22, this.blockHelper.MUD_TILES_DECAY, 2, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 0, 22, this.blockHelper.MUD_TILES_DECAY, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 0, 23, this.blockHelper.MUD_TILES_DECAY, 2, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 0, 23, this.blockHelper.MUD_BRICKS_CARVED_DECAY_4, 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 1, 15, this.blockHelper.MUD_BRICKS, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, 14, this.blockHelper.MUD_BRICKS, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 1, 16, this.blockHelper.MUD_BRICKS_CARVED_DECAY_4, 1, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 1, 19, this.blockHelper.MUD_BRICKS, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 3, 20, this.blockHelper.MUD_BRICKS, 1, 1, 5, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 24, this.blockHelper.MUD_BRICKS, 2, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 3, 24, this.blockHelper.MUD_BRICKS, 3, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 3, 22, this.blockHelper.MUD_BRICKS, 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 3, 15, this.blockHelper.MUD_BRICKS, 1, 1, 6, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 3, 14, this.blockHelper.MUD_BRICKS, 4, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 3, 14, this.blockHelper.MUD_BRICKS_CARVED_DECAY_1, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 15, this.blockHelper.MUD_BRICKS, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 3, 16, this.blockHelper.MUD_BRICKS, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 3, 17, this.blockHelper.MUD_BRICKS_CARVED_DECAY_1, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 3, 18, this.blockHelper.MUD_BRICKS_CARVED_DECAY_2, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 3, 15, this.blockHelper.MUD_BRICKS, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 3, 15, this.blockHelper.MUD_BRICKS, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 19, this.blockHelper.MUD_BRICKS, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 23, this.blockHelper.MUD_BRICKS, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 3, 23, this.blockHelper.MUD_BRICKS, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 3, 21, this.blockHelper.MUD_BRICKS_CARVED_DECAY_2, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 3, 19, this.blockHelper.MUD_BRICKS, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 2, 16, this.blockHelper.MUD_BRICKS_CARVED_DECAY_2, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 2, 18, this.blockHelper.MUD_BRICKS_CARVED_DECAY_3, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 2, 22, this.blockHelper.MUD_BRICKS_CARVED_DECAY_2, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 1, 23, this.blockHelper.MUD_BRICKS, 1, 2, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 2, 23, this.blockHelper.MUD_BRICKS_CARVED_DECAY_2, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 2, 24, this.blockHelper.MUD_BRICKS_CARVED_DECAY_1, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, 23, this.blockHelper.MUD_BRICKS_CARVED_DECAY_4, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, 24, this.blockHelper.MUD_BRICKS, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 2, 24, this.blockHelper.MUD_BRICKS_CARVED_DECAY_1, 2, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 1, 24, this.blockHelper.MUD_BRICKS_CARVED_DECAY_4, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 2, 20, this.blockHelper.MUD_BRICKS_CARVED_DECAY_3, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 1, 20, this.blockHelper.MUD_BRICKS_CARVED_DECAY_4, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 1, 19, this.blockHelper.MUD_BRICKS, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 1, 19, this.blockHelper.MUD_BRICKS_CARVED_DECAY_3, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 2, 19, this.blockHelper.MUD_BRICKS_CARVED_DECAY_1, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 1, 18, this.blockHelper.MUD_BRICKS_CARVED_EDGE_DECAY_4, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 2, 18, this.blockHelper.MUD_BRICKS_CARVED_DECAY_2, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 1, 17, this.blockHelper.MUD_BRICKS_CARVED_DECAY_3, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 2, 16, this.blockHelper.MUD_BRICKS_CARVED_DECAY_1, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 1, 15, this.blockHelper.MUD_BRICKS, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 1, 15, this.blockHelper.MUD_BRICKS_CARVED_DECAY_4, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 2, 15, this.blockHelper.MUD_BRICKS_CARVED_DECAY_2, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 1, 14, this.blockHelper.MUD_BRICKS, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 1, 14, this.blockHelper.MUD_BRICKS_CARVED_DECAY_2, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 2, 14, this.blockHelper.MUD_BRICKS, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 1, 14, this.blockHelper.MUD_BRICKS_CARVED_DECAY_3, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 2, 14, this.blockHelper.MUD_BRICKS_CARVED_DECAY_2, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 1, 14, this.blockHelper.MUD_BRICKS, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, 15, this.blockHelper.MUD_BRICKS_CARVED_DECAY_2, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 2, 15, this.blockHelper.MUD_BRICKS_CARVED, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, 19, this.blockHelper.MUD_BRICKS_CARVED_DECAY_3, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 2, 19, this.blockHelper.MUD_BRICKS_CARVED_DECAY_1, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 1, 23, this.blockHelper.MUD_BRICKS_CARVED_DECAY_1, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 1, 19, this.blockHelper.MUD_BRICKS_CARVED_DECAY_2, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 2, 19, this.blockHelper.MUD_BRICKS_CARVED, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 3, 19, this.blockHelper.MUD_BRICKS, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 2, 15, this.blockHelper.MUD_BRICK_WALL, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 18, this.blockHelper.MUD_BRICK_STAIRS_DECAY_1.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 22, this.blockHelper.MUD_BRICK_STAIRS.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 3, 18, this.blockHelper.MUD_BRICK_STAIRS.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 3, 22, this.blockHelper.MUD_BRICK_STAIRS.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 3, 18, this.blockHelper.MUD_BRICK_STAIRS.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 1, 14, this.blockHelper.MUD_BRICK_STAIRS_DECAY_3.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 3, 15, this.blockHelper.MUD_BRICK_STAIRS.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 3, 19, this.blockHelper.MUD_BRICK_STAIRS_DECAY_1.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 3, 23, this.blockHelper.MUD_BRICK_STAIRS_DECAY_2.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 1, 22, this.blockHelper.MUD_BRICK_STAIRS_DECAY_3.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 1, 24, this.blockHelper.MUD_BRICK_STAIRS_DECAY_3.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 3, 19, this.blockHelper.MUD_BRICK_STAIRS.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 3, 23, this.blockHelper.MUD_BRICK_STAIRS.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 2, 14, this.blockHelper.MUD_BRICK_STAIRS_DECAY_2.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176734_d()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 16, this.blockHelper.MUD_BRICK_STAIRS.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176734_d()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 3, 20, this.blockHelper.MUD_BRICK_STAIRS_DECAY_1.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176734_d()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 1, 15, this.blockHelper.MUD_BRICK_STAIRS_DECAY_2.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176734_d()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 20, this.blockHelper.MUD_BRICK_STAIRS.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176734_d()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 3, 16, this.blockHelper.MUD_BRICK_STAIRS_DECAY_1.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176734_d()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 3, 20, this.blockHelper.MUD_BRICK_STAIRS_DECAY_2.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176734_d()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 2, 14, this.blockHelper.MUD_BRICK_STAIRS.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176735_f()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 3, 15, this.blockHelper.MUD_BRICK_STAIRS.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176735_f()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 2, 24, this.blockHelper.MUD_BRICK_STAIRS.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176735_f()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 3, 24, this.blockHelper.MUD_BRICK_STAIRS_DECAY_1.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176735_f()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 3, 19, this.blockHelper.MUD_BRICK_STAIRS.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176735_f()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 1, 16, this.blockHelper.MUD_BRICK_STAIRS_DECAY_3.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176735_f()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 1, 21, this.blockHelper.MUD_BRICK_STAIRS_DECAY_3.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176735_f()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM), 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 1, 24, this.blockHelper.MUD_BRICK_STAIRS_DECAY_2.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing.func_176735_f()).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, 20, this.blockHelper.MUD_BRICK_SLAB_DECAY_3.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM)), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 1, 23, this.blockHelper.MUD_BRICK_SLAB_DECAY_3.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM)), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 3, 15, this.blockHelper.MUD_BRICK_SLAB.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP)), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 3, 16, this.blockHelper.MUD_BRICK_SLAB.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP)), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 3, 19, this.blockHelper.MUD_BRICK_SLAB.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP)), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 3, 23, this.blockHelper.MUD_BRICK_SLAB.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP)), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 3, 23, this.blockHelper.MUD_BRICK_SLAB.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP)), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 2, 17, this.blockHelper.MUD_BRICKS_ALCOVE_EAST, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 2, 21, this.blockHelper.MUD_BRICKS_ALCOVE_EAST, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 2, 17, this.blockHelper.MUD_BRICKS_ALCOVE_WEST, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 2, 21, this.blockHelper.MUD_BRICKS_ALCOVE_WEST, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 1, 15, this.blockHelper.getRandomLootUrn(rand, facing.func_176734_d()), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 1, 16, this.blockHelper.getRandomLootUrn(rand, facing.func_176746_e()), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 1, 20, this.blockHelper.getRandomLootUrn(rand, facing.func_176746_e()), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, 18, this.blockHelper.getRandomLootUrn(rand, facing.func_176735_f()), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1, 22, this.blockHelper.getRandomLootUrn(rand, facing.func_176735_f()), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 1, 25, this.blockHelper.AIR, 3, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 1, 26, this.blockHelper.AIR, 2, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 2, 25, this.blockHelper.AIR, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 2, 16, this.blockHelper.AIR, 1, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 1, 17, this.blockHelper.AIR, 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 1, 12, this.blockHelper.AIR, 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 2, 20, this.blockHelper.AIR, 1, 1, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 1, 21, this.blockHelper.AIR, 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 1, 24, this.blockHelper.AIR, 2, 2, 1, facing);
        this.blockHelper.placeArmourStandLoot(world, pos.func_177982_a(9, 1, 24), facing.func_176746_e(), rand);
        this.rotatedCubeVolume(world, rand, pos, 1, 5, 11, this.blockHelper.AIR, 3, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 6, 13, this.blockHelper.AIR, 2, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 5, 14, this.blockHelper.AIR, 2, 2, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 6, 18, this.blockHelper.AIR, 2, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 7, 15, this.blockHelper.AIR, 2, 1, 7, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 8, 17, this.blockHelper.AIR, 2, 1, 8, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 9, 19, this.blockHelper.AIR, 2, 1, 6, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 10, 21, this.blockHelper.AIR, 2, 1, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 8, 22, this.blockHelper.AIR, 1, 2, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 10, 23, this.blockHelper.AIR, 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 11, 23, this.blockHelper.AIR, 3, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 9, 25, this.blockHelper.AIR, 2, 4, 5, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 10, 25, this.blockHelper.AIR, 2, 3, 5, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 8, 25, this.blockHelper.AIR, 2, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 8, 26, this.blockHelper.AIR, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 9, 25, this.blockHelper.AIR, 1, 1, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 9, 25, this.blockHelper.AIR, 1, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 10, 27, this.blockHelper.AIR, 1, 4, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 10, 28, this.blockHelper.AIR, 1, 3, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 13, 29, this.blockHelper.AIR, 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 8, 26, this.blockHelper.AIR, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 9, 26, this.blockHelper.AIR, 1, 3, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 10, 29, this.blockHelper.AIR, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 12, 27, this.blockHelper.AIR, 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 13, 26, this.blockHelper.AIR, 4, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 13, 29, this.blockHelper.AIR, 3, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 11, 30, this.blockHelper.AIR, 2, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 14, 29, this.blockHelper.AIR, 2, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 12, 30, this.blockHelper.AIR, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 13, 30, this.blockHelper.AIR, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 8, 2, 22, this.blockHelper.COMPACTED_MUD, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 7, 3, 22, this.blockHelper.COMPACTED_MUD_SLAB.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP)), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 2, 20, this.blockHelper.DUNGEON_WALL_CANDLE_SOUTH, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 1, 15, this.blockHelper.GROUND_ITEM, 1, 1, 1, facing);
        this.blockHelper.setGreatSword(world, rand, pos.func_177982_a(6, 1, 15));
    }

    public void rotatedCubeVolume(World world, Random rand, BlockPos pos, int offsetA, int offsetB, int offsetC, IBlockState state, int sizeWidth, int sizeHeight, int sizeDepth, EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int xx = offsetA; xx < offsetA + sizeWidth; ++xx) {
                        for (int zz = offsetC; zz < offsetC + sizeDepth; ++zz) {
                            this.dungeon.func_175903_a(world, pos.func_177982_a(xx, yy, zz), state);
                        }
                    }
                }
                break;
            }
            case EAST: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int zz = -offsetA; zz > -offsetA - sizeWidth; --zz) {
                        for (int xx = offsetC; xx < offsetC + sizeDepth; ++xx) {
                            this.dungeon.func_175903_a(world, pos.func_177982_a(xx, yy, zz), state);
                        }
                    }
                }
                break;
            }
            case NORTH: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int xx = -offsetA; xx > -offsetA - sizeWidth; --xx) {
                        for (int zz = -offsetC; zz > -offsetC - sizeDepth; --zz) {
                            this.dungeon.func_175903_a(world, pos.func_177982_a(xx, yy, zz), state);
                        }
                    }
                }
                break;
            }
            case WEST: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int zz = offsetA; zz < offsetA + sizeWidth; ++zz) {
                        for (int xx = -offsetC; xx > -offsetC - sizeDepth; --xx) {
                            this.dungeon.func_175903_a(world, pos.func_177982_a(xx, yy, zz), state);
                        }
                    }
                }
                break;
            }
        }
    }
}

