/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.common.block.terrain.BlockCragrock;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.gen.biome.BiomeWeights;
import thebetweenlands.common.world.gen.biome.feature.BiomeFeature;
import thebetweenlands.common.world.gen.biome.generator.BiomeGenerator;

public class CoarseIslandsFeature
extends BiomeFeature {
    private final IBlockState cragrockDefault = BlockRegistry.CRAGROCK.func_176223_P().func_177226_a(BlockCragrock.VARIANT, (Comparable)((Object)BlockCragrock.EnumCragrockType.DEFAULT));
    private final IBlockState cragrockMossy1 = BlockRegistry.CRAGROCK.func_176223_P().func_177226_a(BlockCragrock.VARIANT, (Comparable)((Object)BlockCragrock.EnumCragrockType.MOSSY_1));
    private final IBlockState cragrockMossy2 = BlockRegistry.CRAGROCK.func_176223_P().func_177226_a(BlockCragrock.VARIANT, (Comparable)((Object)BlockCragrock.EnumCragrockType.MOSSY_2));
    private NoiseGeneratorPerlin islandNoiseGen;
    private double[] islandNoise = new double[256];
    private NoiseGeneratorPerlin cragNoiseGen;
    private double[] cragNoise = new double[256];

    @Override
    public void initializeGenerators(long seed, Biome biome) {
        Random rng = new Random(seed);
        this.islandNoiseGen = new NoiseGeneratorPerlin(rng, 4);
        this.cragNoiseGen = new NoiseGeneratorPerlin(rng, 5);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, Biome biome) {
        this.islandNoise = this.islandNoiseGen.func_151599_a(this.islandNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.048, 0.048, 1.0);
        this.cragNoise = this.cragNoiseGen.func_151599_a(this.cragNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.45, 0.45, 1.0);
    }

    public double getIslandNoiseAt(int inChunkX, int inChunkZ, float biomeWeight) {
        double islandNoise = this.islandNoise[inChunkX * 16 + inChunkZ] / (double)0.9f * (double)biomeWeight + (double)2.1f;
        return islandNoise;
    }

    public double getCragrockNoiseAt(int inChunkX, int inChunkZ) {
        double cragNoise = this.cragNoise[inChunkX * 16 + inChunkZ] / (double)2.1f + 2.0;
        return cragNoise;
    }

    public boolean isIslandAt(int inChunkX, int inChunkZ, float biomeWeight) {
        return this.getIslandNoiseAt(inChunkX, inChunkZ, biomeWeight) <= 0.0;
    }

    public boolean isIslandCragrockAt(int inChunkX, int inChunkZ) {
        return this.getCragrockNoiseAt(inChunkX, inChunkZ) <= 0.0;
    }

    @Override
    public void replaceStackBlocks(int x, int z, double baseBlockNoise, ChunkPrimer chunkPrimer, ChunkGeneratorBetweenlands chunkGenerator, Biome[] biomesForGeneration, Biome biome, BiomeWeights biomeWeights, BiomeGenerator.EnumGeneratorPass pass) {
        block13: {
            if (pass != BiomeGenerator.EnumGeneratorPass.PRE_REPLACE_BIOME_BLOCKS) break block13;
            float biomeWeight = biomeWeights.get(x, z, 2.0f, 12.0f);
            double islandNoise = this.getIslandNoiseAt(x, z, biomeWeight);
            double cragNoise = this.getCragrockNoiseAt(x, z);
            boolean isCrag = cragNoise <= 0.0;
            int layerHeight = 120;
            if (islandNoise <= 0.0 && chunkPrimer.func_177856_a(x, layerHeight, z).func_177230_c() == chunkGenerator.layerBlock) {
                int y;
                int yOff;
                int y2;
                Block currentBlock;
                int minHeight = 1;
                int heightVariation = 4;
                for (int yOff2 = 0; yOff2 < layerHeight && (currentBlock = chunkPrimer.func_177856_a(x, y2 = layerHeight - yOff2, z).func_177230_c()) == chunkGenerator.layerBlock; ++yOff2) {
                    if (isCrag) {
                        chunkPrimer.func_177855_a(x, y2, z, this.cragrockDefault);
                        continue;
                    }
                    chunkPrimer.func_177855_a(x, y2, z, chunkGenerator.baseBlockState);
                }
                int islandHeight = (int)Math.ceil(-islandNoise / 4.0 * (double)heightVariation);
                int maxHeight = islandHeight + (isCrag && -islandNoise / 4.0 * (double)heightVariation >= 1.25 ? 1 : 0);
                for (yOff = 0; yOff < maxHeight; ++yOff) {
                    y = minHeight + layerHeight + yOff;
                    if (isCrag) {
                        if (yOff == maxHeight - 2) {
                            chunkPrimer.func_177855_a(x, y, z, this.cragrockMossy2);
                            continue;
                        }
                        if (yOff == maxHeight - 1) {
                            chunkPrimer.func_177855_a(x, y, z, this.cragrockMossy1);
                            continue;
                        }
                        chunkPrimer.func_177855_a(x, y, z, this.cragrockDefault);
                        continue;
                    }
                    chunkPrimer.func_177855_a(x, y, z, chunkGenerator.baseBlockState);
                }
                for (yOff = 0; yOff < minHeight; ++yOff) {
                    y = layerHeight + yOff;
                    if (isCrag) {
                        if (yOff == minHeight - 1 && maxHeight >= 1) {
                            chunkPrimer.func_177855_a(x, y, z, this.cragrockMossy2);
                            continue;
                        }
                        chunkPrimer.func_177855_a(x, y, z, this.cragrockDefault);
                        continue;
                    }
                    chunkPrimer.func_177855_a(x, y, z, chunkGenerator.baseBlockState);
                }
            } else {
                int lowestBlock = 0;
                for (int yOff = 0; yOff < layerHeight; ++yOff) {
                    int y = layerHeight - yOff;
                    Block currentBlock = chunkPrimer.func_177856_a(x, y, z).func_177230_c();
                    if (currentBlock == chunkGenerator.layerBlock) continue;
                    lowestBlock = y;
                    break;
                }
                int y = lowestBlock;
                while ((double)y < CoarseIslandsFeature.lerp((float)layerHeight - (float)(layerHeight - lowestBlock) / 3.5f, lowestBlock, biomeWeight)) {
                    chunkPrimer.func_177855_a(x, y, z, chunkGenerator.baseBlockState);
                    ++y;
                }
            }
        }
    }
}

