/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.Iterator;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.event.TimedEnvironmentEvent;

public class EventHeavyRain
extends TimedEnvironmentEvent {
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "heavy_rain");

    public EventHeavyRain(BLEnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    public ResourceLocation getEventName() {
        return ID;
    }

    @Override
    public int getOffTime(Random rnd) {
        return rnd.nextInt(50000) + 60000;
    }

    @Override
    public int getOnTime(Random rnd) {
        return rnd.nextInt(5000) + 8000;
    }

    @Override
    public void setActive(boolean active) {
        if (active && !this.getRegistry().winter.isActive() || !active) {
            super.setActive(active);
        }
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (!world.field_72995_K && this.getRegistry().winter.isActive()) {
            this.setActive(false);
        }
        if (this.isActive() && world.field_73011_w instanceof WorldProviderBetweenlands && world.field_73012_v.nextInt(20) == 0 && !world.field_72995_K && world instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)world;
            Iterator iterator = worldServer.getPersistentChunkIterable(worldServer.func_184164_w().func_187300_b());
            while (iterator.hasNext()) {
                Chunk chunk = (Chunk)iterator.next();
                if (world.field_73012_v.nextInt(4) != 0) continue;
                int cbx = world.field_73012_v.nextInt(16);
                int cbz = world.field_73012_v.nextInt(16);
                BlockPos pos = chunk.func_177440_h(new BlockPos(chunk.func_76632_l().func_180334_c() + cbx, -999, chunk.func_76632_l().func_180333_d() + cbz));
                if (world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c() == BlockRegistry.PUDDLE || !BlockRegistry.PUDDLE.func_176196_c(world, pos)) continue;
                world.func_175656_a(pos, BlockRegistry.PUDDLE.func_176223_P());
            }
        }
    }
}

