/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import com.google.common.collect.ImmutableMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.world.World;
import thebetweenlands.api.environment.IEnvironmentEvent;
import thebetweenlands.api.environment.IRemotelyControllableEnvironmentEvent;
import thebetweenlands.api.network.IGenericDataManagerAccess;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.handler.EnvironmentEventOverridesHandler;
import thebetweenlands.common.network.datamanager.GenericDataManager;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;

public abstract class BLEnvironmentEvent
implements IEnvironmentEvent,
IRemotelyControllableEnvironmentEvent,
IGenericDataManagerAccess.IDataManagedObject {
    private final BLEnvironmentEventRegistry registry;
    private final World world;
    private NBTTagCompound nbtt = new NBTTagCompound();
    private boolean loaded = false;
    protected static final DataParameter<Boolean> ACTIVE = GenericDataManager.createKey(BLEnvironmentEvent.class, DataSerializers.field_187198_h);
    protected boolean hasNoRemoteState = false;
    protected boolean isStateFromRemoteOverridden = false;
    protected boolean isStateFromRemote = false;
    protected int remoteResetTicks = -1;
    protected final GenericDataManager dataManager;

    public BLEnvironmentEvent(BLEnvironmentEventRegistry registry) {
        this.registry = registry;
        this.world = registry.getWorld();
        this.dataManager = new GenericDataManager(this);
        this.initDataParameters();
    }

    protected void initDataParameters() {
        this.dataManager.register(ACTIVE, false);
    }

    @Override
    public BLEnvironmentEventRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void setActive(boolean active) {
        if (this.isStateFromRemote && active != this.isActive()) {
            this.isStateFromRemote = false;
            this.isStateFromRemoteOverridden = true;
        }
        this.dataManager.set(ACTIVE, active);
        if (active) {
            for (EntityPlayerMP player2 : this.getWorld().func_175661_b(EntityPlayerMP.class, player -> player.field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId)) {
                AdvancementCriterionRegistry.EVENT.trigger(player2, this.getEventName());
            }
        }
    }

    @Override
    public void update(World world) {
        if (!(world.field_72995_K || this.isStateFromRemoteOverridden || EnvironmentEventOverridesHandler.isRemoteDataAvailable() && !this.hasNoRemoteState)) {
            if (this.remoteResetTicks > 0) {
                --this.remoteResetTicks;
            }
            if (this.remoteResetTicks == 0) {
                this.updateNoStateFromRemote();
                this.resetActiveState();
                this.remoteResetTicks = -1;
            }
        }
    }

    @Override
    public void saveEventData() {
        NBTTagCompound nbt = this.getData();
        nbt.func_74768_a("remoteResetTicks", this.remoteResetTicks);
        nbt.func_74757_a("isStateFromRemote", this.isStateFromRemote);
        nbt.func_74757_a("isStateFromRemoteOverridden", this.isStateFromRemoteOverridden);
        nbt.func_74757_a("hasNoRemoteState", this.hasNoRemoteState);
    }

    @Override
    public void loadEventData() {
        NBTTagCompound nbt = this.getData();
        this.remoteResetTicks = nbt.func_74762_e("remoteResetTicks");
        this.isStateFromRemote = nbt.func_74767_n("isStateFromRemote");
        this.isStateFromRemoteOverridden = nbt.func_74767_n("isStateFromRemoteOverridden");
        this.hasNoRemoteState = nbt.func_74767_n("hasNoRemoteState");
    }

    @Override
    public void resetStateFromRemote() {
        this.resetActiveState();
    }

    @Override
    public boolean isCurrentStateFromRemote() {
        return this.isStateFromRemote;
    }

    @Override
    public void updateStateFromRemote(boolean value, int remoteResetTicks, ImmutableMap<String, String> data) {
        if (!this.isStateFromRemoteOverridden) {
            if (this.isActive() != value && !this.isStateFromRemote) {
                this.setActive(value);
            }
            this.remoteResetTicks = remoteResetTicks;
            this.isStateFromRemote = true;
        }
        this.hasNoRemoteState = false;
    }

    @Override
    public void updateNoStateFromRemote() {
        this.hasNoRemoteState = true;
        this.isStateFromRemoteOverridden = false;
        this.isStateFromRemote = false;
        this.remoteResetTicks = -1;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean isActive() {
        return this.dataManager.get(ACTIVE);
    }

    @Override
    public boolean isActiveAt(double x, double y, double z) {
        return this.isActive();
    }

    @Override
    public void resetActiveState() {
        if (this.isActive()) {
            this.setActive(false);
        }
    }

    @Override
    public void setLoaded() {
        this.loaded = true;
    }

    @Override
    public NBTTagCompound getData() {
        return this.nbtt;
    }

    @Override
    public final void writeToNBT(NBTTagCompound compound) {
        this.nbtt.func_74757_a("active", this.dataManager.get(ACTIVE).booleanValue());
        this.saveEventData();
        compound.func_74782_a("environmentEvent:" + this.getEventName(), (NBTBase)this.nbtt);
    }

    @Override
    public final void readFromNBT(NBTTagCompound compound) {
        this.nbtt = compound.func_74775_l("environmentEvent:" + this.getEventName());
        this.dataManager.set(ACTIVE, this.nbtt.func_74767_n("active"));
        this.loadEventData();
        this.loaded = true;
    }

    @Override
    public void setDefaults() {
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public String getLocalizationEventName() {
        return "event." + this.getEventName().func_110624_b() + "." + this.getEventName().func_110623_a() + ".name";
    }

    @Override
    public GenericDataManager getDataManager() {
        return this.dataManager;
    }

    @Override
    public boolean onParameterChange(DataParameter<?> key, Object value, boolean fromPacket) {
        if (fromPacket && key == ACTIVE) {
            this.setActive((Boolean)value);
            return true;
        }
        return false;
    }
}

