/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.ItemStack;
import thebetweenlands.api.recipes.IPestleAndMortarRecipe;

public class PestleAndMortarRecipe
implements IPestleAndMortarRecipe {
    private static final List<IPestleAndMortarRecipe> recipes = new ArrayList<IPestleAndMortarRecipe>();
    private final ItemStack output;
    private final ItemStack input;

    public static void addRecipe(ItemStack output, ItemStack input) {
        recipes.add(new PestleAndMortarRecipe(output, input));
    }

    public static void addRecipe(IPestleAndMortarRecipe recipe) {
        recipes.add(recipe);
    }

    public static void removeRecipe(IPestleAndMortarRecipe recipe) {
        recipes.remove(recipe);
    }

    @MethodsReturnNonnullByDefault
    public static ItemStack getResult(ItemStack input) {
        for (IPestleAndMortarRecipe recipe : recipes) {
            if (!recipe.matchesInput(input)) continue;
            return recipe.getOutput(input);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getInput(ItemStack output) {
        for (IPestleAndMortarRecipe recipe : recipes) {
            if (!recipe.matchesOutput(output)) continue;
            return recipe.getInputs();
        }
        return ItemStack.field_190927_a;
    }

    public static List<IPestleAndMortarRecipe> getRecipes() {
        return Collections.unmodifiableList(recipes);
    }

    public PestleAndMortarRecipe(ItemStack output, ItemStack input) {
        this.output = output.func_77946_l();
        this.input = input.func_77946_l();
        if (!(input instanceof ItemStack)) {
            throw new IllegalArgumentException("Input must be an ItemStack");
        }
        input = input.func_77946_l();
    }

    @Override
    public ItemStack getInputs() {
        return this.input.func_77946_l();
    }

    public boolean matches(ItemStack stacks) {
        if (stacks != null && this.areStacksTheSame(this.getInputs(), stacks)) {
            stacks = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesOutput(ItemStack stacks) {
        if (stacks != null && this.areStacksTheSame(this.output, stacks)) {
            stacks = null;
            return true;
        }
        return false;
    }

    private boolean areStacksTheSame(ItemStack stack, ItemStack target) {
        return PestleAndMortarRecipe.doesInputMatch(stack, target, false);
    }

    public static boolean doesInputMatch(ItemStack input, ItemStack toCheck, boolean matchSize) {
        if (input == null || toCheck == null) {
            return false;
        }
        if (!(input.func_77973_b() != toCheck.func_77973_b() || input.func_77952_i() != Short.MAX_VALUE && input.func_77952_i() != toCheck.func_77952_i() || matchSize && input.func_190916_E() != toCheck.func_190916_E())) {
            if (input.func_77942_o()) {
                return toCheck.func_77942_o() && input.func_77978_p().equals((Object)toCheck.func_77978_p());
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getOutput(ItemStack input) {
        return this.output;
    }

    @Override
    public boolean matchesInput(ItemStack stack) {
        return PestleAndMortarRecipe.doesInputMatch(this.input, stack, false);
    }
}

