/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.properties.EntityProperty;

public class EntityPropertyHasItem
implements EntityProperty {
    private final boolean hasItem;
    private final boolean combineStacks;
    private final boolean held;
    private final boolean armor;
    private final boolean main;
    private final ItemStack item;
    private final StackSizeMatcher sizeMatcher;

    public EntityPropertyHasItem(boolean hasItem, boolean combineStacks, ItemStack item, StackSizeMatcher sizeMatcher, boolean held, boolean armor, boolean main) {
        this.hasItem = hasItem;
        this.combineStacks = combineStacks;
        this.item = item;
        this.sizeMatcher = sizeMatcher;
        this.held = held;
        this.armor = armor;
        this.main = main;
    }

    public boolean func_186657_a(Random random, Entity entity) {
        int amount = -1;
        if (this.held) {
            for (ItemStack stack : entity.func_184214_aD()) {
                if (!this.doesItemMatch(stack)) continue;
                if (!this.combineStacks) {
                    if (!this.doesSizeMatch(stack.func_190916_E())) continue;
                    return this.hasItem;
                }
                ++amount;
            }
        }
        if (this.armor) {
            for (ItemStack stack : entity.func_184193_aE()) {
                if (!this.doesItemMatch(stack)) continue;
                if (!this.combineStacks) {
                    if (!this.doesSizeMatch(stack.func_190916_E())) continue;
                    return this.hasItem;
                }
                ++amount;
            }
        }
        if (this.main && entity instanceof EntityPlayer) {
            NonNullList inv = ((EntityPlayer)entity).field_71071_by.field_70462_a;
            for (ItemStack stack : inv) {
                if (!this.doesItemMatch(stack)) continue;
                if (!this.combineStacks) {
                    if (!this.doesSizeMatch(stack.func_190916_E())) continue;
                    return this.hasItem;
                }
                ++amount;
            }
        }
        if (this.combineStacks && amount != -1 && this.sizeMatcher.matcher.apply(this.item.func_190916_E(), amount + 1).booleanValue()) {
            return this.hasItem;
        }
        return !this.hasItem;
    }

    private boolean doesItemMatch(ItemStack stack) {
        if (this.item.func_190926_b() && stack.func_190926_b()) {
            return true;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b() == this.item.func_77973_b() && (this.item.func_77952_i() == Short.MAX_VALUE || this.item.func_77952_i() == stack.func_77952_i());
    }

    private boolean doesSizeMatch(int size) {
        return this.sizeMatcher == null || this.sizeMatcher.matcher.apply(this.item.func_190916_E(), size) != false;
    }

    public static class Serializer
    extends EntityProperty.Serializer<EntityPropertyHasItem> {
        public Serializer() {
            super(new ResourceLocation("thebetweenlands", "has_item"), EntityPropertyHasItem.class);
        }

        public JsonElement serialize(EntityPropertyHasItem property, JsonSerializationContext serializationContext) {
            JsonObject obj = new JsonObject();
            obj.add("has_item", (JsonElement)new JsonPrimitive(Boolean.valueOf(property.hasItem)));
            obj.add("combine_stacks", (JsonElement)new JsonPrimitive(Boolean.valueOf(property.combineStacks)));
            JsonObject itemJson = new JsonObject();
            itemJson.add("id", (JsonElement)new JsonPrimitive(property.item.func_77973_b().getRegistryName().toString()));
            if (property.item.func_77952_i() != Short.MAX_VALUE) {
                itemJson.add("meta", (JsonElement)new JsonPrimitive((Number)property.item.func_77952_i()));
            }
            if (property.item.func_190916_E() != 1) {
                itemJson.add("size", (JsonElement)new JsonPrimitive((Number)property.item.func_190916_E()));
            }
            obj.add("item", (JsonElement)itemJson);
            JsonArray inventories = new JsonArray();
            if (property.held) {
                inventories.add((JsonElement)new JsonPrimitive("held"));
            }
            if (property.armor) {
                inventories.add((JsonElement)new JsonPrimitive("armor"));
            }
            if (property.main) {
                inventories.add((JsonElement)new JsonPrimitive("main"));
            }
            obj.add("inventories", (JsonElement)inventories);
            if (property.sizeMatcher != null) {
                switch (property.sizeMatcher) {
                    case GREATER: {
                        obj.add("size_operator", (JsonElement)new JsonPrimitive(">"));
                        break;
                    }
                    case GREATER_EQ: {
                        obj.add("size_operator", (JsonElement)new JsonPrimitive(">="));
                        break;
                    }
                    case LESS: {
                        obj.add("size_operator", (JsonElement)new JsonPrimitive("<"));
                        break;
                    }
                    case LESS_EQ: {
                        obj.add("size_operator", (JsonElement)new JsonPrimitive("<="));
                        break;
                    }
                    case EQUAL: {
                        obj.add("size_operator", (JsonElement)new JsonPrimitive("="));
                    }
                }
            }
            return obj;
        }

        public EntityPropertyHasItem deserialize(JsonElement element, JsonDeserializationContext deserializationContext) {
            JsonObject obj = JsonUtils.func_151210_l((JsonElement)element, (String)this.func_186649_a().func_110623_a());
            boolean hasItem = JsonUtils.func_151216_b((JsonElement)obj.get("has_item"), (String)"has_item");
            boolean combineStacks = obj.has("combine_stacks") ? JsonUtils.func_151216_b((JsonElement)obj.get("combine_stacks"), (String)"combine_stacks") : false;
            JsonObject itemJson = JsonUtils.func_151210_l((JsonElement)obj.get("item"), (String)"item");
            Item item = JsonUtils.func_188172_b((JsonElement)itemJson.get("id"), (String)"id");
            int meta = itemJson.has("meta") ? JsonUtils.func_151215_f((JsonElement)itemJson.get("meta"), (String)"meta") : Short.MAX_VALUE;
            int size = itemJson.has("size") ? JsonUtils.func_151215_f((JsonElement)itemJson.get("size"), (String)"size") : 1;
            ItemStack stack = new ItemStack(item, size, meta);
            boolean held = false;
            boolean armor = false;
            boolean main = false;
            JsonArray inventories = JsonUtils.func_151207_m((JsonElement)obj.get("inventories"), (String)"inventories");
            block24: for (JsonElement inventoryType : inventories) {
                switch (inventoryType.getAsString()) {
                    case "held": {
                        held = true;
                        continue block24;
                    }
                    case "armor": {
                        armor = true;
                        continue block24;
                    }
                    case "main": {
                        main = true;
                        continue block24;
                    }
                }
                throw new JsonParseException("Invalid inventory type. Valid inventory types: held, armor, main");
            }
            StackSizeMatcher sizeMatcher = null;
            if (obj.has("size_operator")) {
                String sizeOperator;
                switch (sizeOperator = JsonUtils.func_151206_a((JsonElement)obj.get("size_operator"), (String)"size_operator")) {
                    case ">": {
                        sizeMatcher = StackSizeMatcher.GREATER;
                        break;
                    }
                    case "<": {
                        sizeMatcher = StackSizeMatcher.LESS;
                        break;
                    }
                    case ">=": {
                        sizeMatcher = StackSizeMatcher.GREATER_EQ;
                        break;
                    }
                    case "<=": {
                        sizeMatcher = StackSizeMatcher.LESS_EQ;
                        break;
                    }
                    case "=": {
                        sizeMatcher = StackSizeMatcher.EQUAL;
                        break;
                    }
                    default: {
                        throw new JsonParseException("Invalid size operator. Valid size operators: >, <, <=, >=, =");
                    }
                }
            }
            return new EntityPropertyHasItem(hasItem, combineStacks, stack, sizeMatcher, held, armor, main);
        }
    }

    public static enum StackSizeMatcher {
        GREATER((o, i) -> i > o),
        GREATER_EQ((o, i) -> i >= o),
        LESS((o, i) -> i < o),
        LESS_EQ((o, i) -> i <= o),
        EQUAL((o, i) -> i == o);

        public final BiFunction<Integer, Integer, Boolean> matcher;

        private StackSizeMatcher(BiFunction<Integer, Integer, Boolean> matcher) {
            this.matcher = matcher;
        }
    }
}

