/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.api.entity.IRingOfGatheringMinion;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityTarminion
extends EntityTameable
implements IEntityBL,
IRingOfGatheringMinion {
    public static final IAttribute MAX_TICKS_ATTRIB = new RangedAttribute(null, "bl.maxAliveTicks", 7200.0, 0.0, 2.147483647E9).func_111117_a("Maximum ticks until the Tar Minion despawns");
    private int despawnTicks = 0;
    protected boolean dropContentsWhenDead = true;

    public EntityTarminion(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.5f);
        this.field_70728_aV = 0;
        this.field_70178_ae = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 3.0f, 40.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]){

            protected void func_179446_a(EntityCreature ally, EntityLivingBase target) {
                if (!(target instanceof EntityTarminion)) {
                    super.func_179446_a(ally, target);
                }
            }
        });
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, false, false, entity -> entity instanceof IMob && (!(entity instanceof IEntityOwnable) || ((IEntityOwnable)entity).func_70902_q() != this.func_70902_q())));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.9);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110140_aT().func_111150_b(MAX_TICKS_ATTRIB);
    }

    public boolean func_70692_ba() {
        return false;
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_70909_n() {
        return true;
    }

    protected void func_180429_a(BlockPos pos, Block state) {
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_184185_a(SoundRegistry.TAR_BEAST_STEP, 0.8f, 1.5f);
        }
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.SQUISH;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            ++this.despawnTicks;
            if ((double)this.despawnTicks > this.func_110148_a(MAX_TICKS_ATTRIB).func_111126_e()) {
                this.func_70097_a(DamageSource.field_76377_j, this.func_110138_aP());
            }
        }
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0) {
            this.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z);
        }
    }

    public NBTTagCompound func_189511_e(NBTTagCompound nbt) {
        super.func_189511_e(nbt);
        nbt.func_74768_a("despawnTicks", this.despawnTicks);
        return nbt;
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.despawnTicks = nbt.func_74762_e("despawnTicks");
    }

    public void func_70106_y() {
        if (!this.field_70128_L && this.dropContentsWhenDead) {
            Vec3d vec;
            float rz;
            float ry;
            float rx;
            Object rnd;
            int i;
            if (this.func_70638_az() != null) {
                if (this.field_70170_p.field_72995_K) {
                    for (i = 0; i < 200; ++i) {
                        rnd = this.field_70170_p.field_73012_v;
                        rx = ((Random)rnd).nextFloat() * 1.0f - 0.5f;
                        ry = ((Random)rnd).nextFloat() * 1.0f - 0.5f;
                        rz = ((Random)rnd).nextFloat() * 1.0f - 0.5f;
                        vec = new Vec3d((double)rx, (double)ry, (double)rz);
                        vec = vec.func_72432_b();
                        BLParticles.SPLASH_TAR.spawn(this.field_70170_p, this.field_70165_t + (double)rx + (double)0.1f, this.field_70163_u + (double)ry, this.field_70161_v + (double)rz + (double)0.1f, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(vec.field_72450_a * (double)0.4f, vec.field_72448_b * (double)0.4f, vec.field_72449_c * (double)0.4f));
                    }
                } else {
                    for (int i2 = 0; i2 < 8; ++i2) {
                        this.func_184185_a(SoundRegistry.TAR_BEAST_STEP, 1.0f, (this.field_70146_Z.nextFloat() * 0.4f + 0.8f) * 0.8f);
                    }
                    List affectedEntities = this.field_70170_p.func_72872_a(EntityCreature.class, this.func_174813_aQ().func_72314_b(5.25, 5.25, 5.25));
                    for (EntityCreature e : affectedEntities) {
                        if (e == this || e.func_70032_d((Entity)this) > 5.25f || !e.func_70685_l((Entity)this) || e instanceof EntityTarminion) continue;
                        double dst = e.func_70032_d((Entity)this);
                        e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 4.0f);
                        e.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(20.0 + (1.0 - dst / 5.25) * 150.0), 1));
                    }
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_184610_a(false, 0, DamageSource.field_76377_j);
            }
            this.func_184185_a(SoundRegistry.TAR_BEAST_STEP, 2.5f, 0.5f);
            if (this.field_70170_p.field_72995_K) {
                for (i = 0; i < 100; ++i) {
                    rnd = this.field_70170_p.field_73012_v;
                    rx = ((Random)rnd).nextFloat() * 1.0f - 0.5f;
                    ry = ((Random)rnd).nextFloat() * 1.0f - 0.5f;
                    rz = ((Random)rnd).nextFloat() * 1.0f - 0.5f;
                    vec = new Vec3d((double)rx, (double)ry, (double)rz);
                    vec = vec.func_72432_b();
                    BLParticles.SPLASH_TAR.spawn(this.field_70170_p, this.field_70165_t + (double)rx + (double)0.1f, this.field_70163_u + (double)ry, this.field_70161_v + (double)rz + (double)0.1f, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(vec.field_72450_a * (double)0.2f, vec.field_72448_b * (double)0.2f, vec.field_72449_c * (double)0.2f));
                }
            }
        }
        super.func_70106_y();
    }

    public boolean func_70652_k(Entity entity) {
        super.func_70652_k(entity);
        return this.attack(entity);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76369_e && this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v)).func_177230_c() == BlockRegistry.TAR) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityCreature) {
            this.attack(source.func_76346_g());
        }
        return super.func_70097_a(source, amount);
    }

    protected boolean attack(Entity entity) {
        if (!this.field_70170_p.field_72995_K) {
            EntityLivingBase owner;
            if (this.field_70122_E) {
                double dx = entity.field_70165_t - this.field_70165_t;
                double dz = entity.field_70161_v - this.field_70161_v;
                float dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                this.field_70159_w = dx / (double)dist * 0.2 + this.field_70159_w * 0.2;
                this.field_70179_y = dz / (double)dist * 0.2 + this.field_70179_y * 0.2;
                this.field_70181_x = 0.3;
            }
            Object damageSource = (owner = this.func_70902_q()) != null ? new EntityDamageSourceIndirect("mob", (Entity)this, (Entity)owner) : DamageSource.func_76358_a((EntityLivingBase)this);
            entity.func_70097_a(damageSource, (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            if (entity instanceof EntityLivingBase && this.field_70170_p.field_73012_v.nextInt(4) == 0) {
                ((EntityLivingBase)entity).func_70604_c((EntityLivingBase)this);
            }
            this.func_184185_a(SoundRegistry.TAR_BEAST_STEP, 1.0f, 2.0f);
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, this.field_70170_p.func_175659_aa().func_151525_a() * 50, 0));
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, double x, double y, double z, Random rand) {
        for (int count = 0; count < 3; ++count) {
            double a = Math.toRadians(this.field_70761_aq);
            double offSetX = -Math.sin(a) * 0.0 + rand.nextDouble() * 0.1 - rand.nextDouble() * 0.1;
            double offSetZ = Math.cos(a) * 0.0 + rand.nextDouble() * 0.1 - rand.nextDouble() * 0.1;
            BLParticles.TAR_BEAST_DRIP.spawn(world, x + offSetX, y + 0.1, z + offSetZ);
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable entity) {
        return null;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.TARMINION;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    public void func_184174_b(boolean dropWhenDead) {
        this.dropContentsWhenDead = dropWhenDead;
    }

    public Entity func_184204_a(int dimensionIn) {
        this.dropContentsWhenDead = false;
        return super.func_184204_a(dimensionIn);
    }

    @Override
    public NBTTagCompound returnToRing(UUID userId) {
        return this.func_189511_e(new NBTTagCompound());
    }

    @Override
    public boolean returnFromRing(Entity user, NBTTagCompound nbt) {
        double prevX = this.field_70165_t;
        double prevY = this.field_70163_u;
        double prevZ = this.field_70161_v;
        float prevYaw = this.field_70177_z;
        float prevPitch = this.field_70125_A;
        this.func_70020_e(nbt);
        this.func_70012_b(prevX, prevY, prevZ, prevYaw, prevPitch);
        if (this.func_70089_S()) {
            this.field_70170_p.func_72838_d((Entity)this);
        } else if (this.field_70170_p instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)this.field_70170_p;
            LootTable lootTable = worldServer.func_184146_ak().func_186521_a(LootTableRegistry.TARMINION);
            LootContext.Builder contextBuilder = new LootContext.Builder(worldServer).func_186472_a((Entity)this);
            for (ItemStack loot : lootTable.func_186462_a(this.field_70170_p.field_73012_v, contextBuilder.func_186471_a())) {
                if (user instanceof EntityPlayer) {
                    if (((EntityPlayer)user).field_71071_by.func_70441_a(loot)) continue;
                    ((EntityPlayer)user).func_71019_a(loot, false);
                    continue;
                }
                user.func_70099_a(loot, 0.0f);
            }
        }
        return true;
    }

    @Override
    public boolean isRespawnedByAnimator() {
        return false;
    }

    @Override
    public UUID getRingOwnerId() {
        return this.func_184753_b();
    }
}

