/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.recruitment;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import thebetweenlands.api.capability.IPuppetCapability;
import thebetweenlands.api.capability.IPuppeteerCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.registries.CapabilityRegistry;

public class EntityPuppeteerCapability
extends EntityCapability<EntityPuppeteerCapability, IPuppeteerCapability, EntityPlayer>
implements IPuppeteerCapability {
    private int activatingTicks;
    private int activatingEntityId = -1;
    private Entity activatingEntity;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "puppeteer");
    }

    @Override
    protected Capability<IPuppeteerCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_PUPPETEER;
    }

    @Override
    protected Class<IPuppeteerCapability> getCapabilityClass() {
        return IPuppeteerCapability.class;
    }

    @Override
    protected EntityPuppeteerCapability getDefaultCapabilityImplementation() {
        return new EntityPuppeteerCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public List<Entity> getPuppets() {
        return ((EntityPlayer)this.getEntity()).func_130014_f_().func_175647_a(Entity.class, ((EntityPlayer)this.getEntity()).func_174813_aQ().func_72314_b(24.0, 24.0, 24.0), entity -> {
            IPuppetCapability cap = (IPuppetCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null);
            return cap != null && cap.getPuppeteer() == this.getEntity();
        });
    }

    @Override
    public void setActivatingEntity(Entity entity) {
        this.activatingEntityId = entity == null ? -1 : entity.func_145782_y();
        this.activatingEntity = entity;
        this.markDirty();
    }

    @Override
    public Entity getActivatingEntity() {
        if (this.activatingEntityId < 0) {
            this.activatingEntity = null;
        } else if (this.activatingEntity == null || !this.activatingEntity.func_70089_S() || this.activatingEntity.func_145782_y() != this.activatingEntityId) {
            this.activatingEntity = ((EntityPlayer)this.getEntity()).field_70170_p.func_73045_a(this.activatingEntityId);
        }
        return this.activatingEntity;
    }

    @Override
    public int getActivatingTicks() {
        return this.activatingTicks;
    }

    @Override
    public void setActivatingTicks(int ticks) {
        this.activatingTicks = ticks;
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("activatingEntityId", this.activatingEntityId);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.activatingEntityId = nbt.func_74762_e("activatingEntityId");
    }

    @Override
    public int getTrackingTime() {
        return 0;
    }
}

