/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.item.misc.ItemRuneDoorKey;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityDungeonDoorRunes;
import thebetweenlands.util.AdvancedStateMap;

public class BlockDungeonDoorRunes
extends BasicBlock
implements ITileEntityProvider,
BlockRegistry.IStateMappedBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool INVISIBLE = PropertyBool.func_177716_a((String)"invisible");
    public final boolean mimic;
    public final boolean barrishee;

    public BlockDungeonDoorRunes(boolean mimic, boolean barrishee) {
        this(Material.field_151576_e, mimic, barrishee);
    }

    public BlockDungeonDoorRunes(Material material, boolean mimic, boolean barrishee) {
        super(material);
        this.func_149722_s();
        this.func_149752_b(2000.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)INVISIBLE, (Comparable)Boolean.valueOf(false)));
        this.func_149713_g(255);
        this.field_149783_u = true;
        this.mimic = mimic;
        this.barrishee = barrishee;
    }

    @Nullable
    public static TileEntityDungeonDoorRunes getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDungeonDoorRunes) {
            return (TileEntityDungeonDoorRunes)tile;
        }
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (!((Boolean)this.func_176203_a(meta).func_177229_b((IProperty)INVISIBLE)).booleanValue()) {
            return new TileEntityDungeonDoorRunes(this.mimic, this.barrishee);
        }
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta & 7));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(facing.func_176740_k().func_176722_c() ? facing : EnumFacing.NORTH)).func_177226_a((IProperty)INVISIBLE, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)INVISIBLE)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)INVISIBLE, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, INVISIBLE});
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityDungeonDoorRunes tile;
        if (!((Boolean)state.func_177229_b((IProperty)INVISIBLE)).booleanValue() && (tile = BlockDungeonDoorRunes.getTileEntity((IBlockAccess)world, pos)) != null) {
            tile.breakAllDoorBlocks(state, (EnumFacing)state.func_177229_b((IProperty)FACING), false, true);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        IBlockState invisiBlock = this.func_176223_P().func_177226_a((IProperty)INVISIBLE, (Comparable)Boolean.valueOf(true));
        if (!((Boolean)state.func_177229_b((IProperty)INVISIBLE)).booleanValue()) {
            int y;
            if (state.func_177229_b((IProperty)FACING) == EnumFacing.WEST || state.func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
                for (int z = -1; z <= 1; ++z) {
                    for (y = -1; y <= 1; ++y) {
                        if (pos.func_177982_a(0, y, z) == pos) continue;
                        world.func_175656_a(pos.func_177982_a(0, y, z), invisiBlock.func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
                    }
                }
            }
            if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH || state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
                for (int x = -1; x <= 1; ++x) {
                    for (y = -1; y <= 1; ++y) {
                        if (pos.func_177982_a(x, y, 0) == pos) continue;
                        world.func_175656_a(pos.func_177982_a(x, y, 0), invisiBlock.func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
                    }
                }
            }
        }
        world.func_184138_a(pos, state, state, 3);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        int y;
        if (side == EnumFacing.WEST || side == EnumFacing.EAST) {
            for (int z = -1; z <= 1; ++z) {
                for (y = -1; y <= 1; ++y) {
                    if (world.func_180495_p(pos.func_177982_a(0, y, z)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(0, y, z))) continue;
                    return false;
                }
            }
        }
        if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
            for (int x = -1; x <= 1; ++x) {
                for (y = -1; y <= 1; ++y) {
                    if (world.func_180495_p(pos.func_177982_a(x, y, 0)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(x, y, 0))) continue;
                    return false;
                }
            }
        }
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            return false;
        }
        return this.func_176196_c(world, pos);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && !((Boolean)state.func_177229_b((IProperty)INVISIBLE)).booleanValue()) {
            TileEntityDungeonDoorRunes tile = BlockDungeonDoorRunes.getTileEntity((IBlockAccess)world, pos);
            if (tile != null && facing == state.func_177229_b((IProperty)FACING) && !tile.is_gate_entrance) {
                if (stack.func_77973_b() instanceof ItemRuneDoorKey) {
                    tile.top_state = tile.top_code;
                    tile.mid_state = tile.mid_code;
                    tile.bottom_state = tile.bottom_code;
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    world.func_184138_a(pos, state, state, 3);
                    return true;
                }
                if (player.field_71075_bZ.field_75098_d && player.func_70093_af()) {
                    tile.enterLockCode();
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.dungeon_door_runes.locked", new Object[0]), true);
                } else {
                    if (hitY >= 0.0625f && hitY < 0.375f && tile.bottom_rotate == 0) {
                        tile.cycleBottomState();
                    }
                    if (hitY >= 0.375f && hitY < 0.625f && tile.mid_rotate == 0) {
                        tile.cycleMidState();
                    }
                    if (hitY >= 0.625f && hitY <= 0.9375f && tile.top_rotate == 0) {
                        tile.cycleTopState();
                    }
                }
                world.func_184138_a(pos, state, state, 3);
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{INVISIBLE}).build();
    }
}

