/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.tile.TileEntityDungeonDoorCombination;

public class BlockDungeonDoorCombination
extends BasicBlock
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockDungeonDoorCombination() {
        this(Material.field_151576_e);
    }

    public BlockDungeonDoorCombination(Material material) {
        super(material);
        this.func_149711_c(0.4f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @Nullable
    public static TileEntityDungeonDoorCombination getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDungeonDoorCombination) {
            return (TileEntityDungeonDoorCombination)tile;
        }
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDungeonDoorCombination();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(facing.func_176740_k().func_176722_c() ? facing : EnumFacing.NORTH));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        return meta |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_184138_a(pos, state, state, 3);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityDungeonDoorCombination tile;
        if (!world.field_72995_K && player.field_71075_bZ.field_75098_d && (tile = BlockDungeonDoorCombination.getTileEntity((IBlockAccess)world, pos)) != null && facing == state.func_177229_b((IProperty)FACING)) {
            if (hitY >= 0.0625f && hitY < 0.375f) {
                tile.cycleBottomState();
            }
            if (hitY >= 0.375f && hitY < 0.625f) {
                tile.cycleMidState();
            }
            if (hitY >= 0.625f && hitY <= 0.9375f) {
                tile.cycleTopState();
            }
            world.func_184133_a(null, pos, SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_184138_a(pos, state, state, 3);
            return true;
        }
        return false;
    }
}

