/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.plant;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.plant.BlockSludgeDungeonPlant;
import thebetweenlands.common.registries.BlockRegistry;

public class BlockEdgePlant
extends BlockSludgeDungeonPlant
implements BlockRegistry.ICustomItemBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB PLANT_AABB_NORTH = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.25, 1.0);
    protected static final AxisAlignedBB PLANT_AABB_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 0.5);
    protected static final AxisAlignedBB PLANT_AABB_EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.25, 1.0);
    protected static final AxisAlignedBB PLANT_AABB_WEST = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockEdgePlant() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.1f);
        this.func_149647_a(BLCreativeTabs.PLANTS);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case SOUTH: {
                return PLANT_AABB_SOUTH;
            }
            case EAST: {
                return PLANT_AABB_EAST;
            }
            case WEST: {
                return PLANT_AABB_WEST;
            }
        }
        return PLANT_AABB_NORTH;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        boolean hasSupportBlock;
        if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, pos)) {
            hasSupportBlock = true;
        } else {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            hasSupportBlock = this.hasSupportBlock(worldIn, pos, facing);
        }
        return hasSupportBlock && super.func_180671_f(worldIn, pos, state);
    }

    protected boolean hasSupportBlock(World world, BlockPos pos, EnumFacing facing) {
        BlockPos supportPos = pos.func_177972_a(facing.func_176734_d());
        return world.func_180495_p(supportPos).isSideSolid((IBlockAccess)world, supportPos, facing);
    }

    @Override
    public boolean canSpreadTo(World world, BlockPos pos, IBlockState state, BlockPos targetPos, Random rand) {
        return world.func_175623_d(targetPos) && this.hasSupportBlock(world, targetPos, (EnumFacing)state.func_177229_b((IProperty)FACING));
    }

    @Override
    public void spreadTo(World world, BlockPos pos, IBlockState state, BlockPos targetPos, Random rand) {
        world.func_175656_a(targetPos, this.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
    }

    @Override
    public int getColorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerFoliage.func_77468_c();
    }

    @Override
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    @Override
    public ItemBlock getItemBlock() {
        return new ItemBlockEdgePlant(this);
    }

    private static class ItemBlockEdgePlant
    extends ItemBlock {
        private final BlockEdgePlant block;

        public ItemBlockEdgePlant(BlockEdgePlant block) {
            super((Block)block);
            this.block = block;
        }

        public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
            return this.block.func_180671_f(world, pos, newState) && super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        }
    }
}

