/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.misc;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityGroundItem;

public class BlockGroundItem
extends Block
implements BlockRegistry.ICustomItemBlock {
    public static AxisAlignedBB BOUNDING_AABB = new AxisAlignedBB((double)0.15f, 0.0, (double)0.15f, (double)0.85f, (double)0.45f, (double)0.85f);

    public BlockGroundItem() {
        super(Material.field_151578_c);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149711_c(0.1f);
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    public static void create(World world, BlockPos pos, ItemStack stack) {
        Block block = BlockRegistry.GROUND_ITEM;
        if (!world.field_72995_K && block.func_176196_c(world, pos)) {
            world.func_175656_a(pos, block.func_176223_P());
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityGroundItem) {
                ((TileEntityGroundItem)tileEntity).setStack(stack);
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    @Nullable
    public ItemBlock getItemBlock() {
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityGroundItem && !worldIn.field_72995_K) {
            ItemStack itemStack = ((TileEntityGroundItem)tileEntity).getStack();
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)itemStack);
            worldIn.func_175698_g(pos);
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public boolean canStay(World world, BlockPos pos) {
        IBlockState downState = world.func_180495_p(pos);
        return downState.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) || downState.func_193401_d((IBlockAccess)world, pos, EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canStay(worldIn, pos.func_177977_b())) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            this.func_180657_a(worldIn, null, pos, state, tileEntity, ItemStack.field_190927_a);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityGroundItem && !worldIn.field_72995_K && !((TileEntityGroundItem)te).getStack().func_190926_b()) {
            BlockGroundItem.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)((TileEntityGroundItem)te).getStack());
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canStay(worldIn, pos.func_177977_b());
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityGroundItem();
    }
}

