/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.util.QuadBuilder;

public class ModelRubberTapLiquid
implements IModel {
    private final int height;
    private final ResourceLocation fluidTexture;

    public ModelRubberTapLiquid(ResourceLocation fluidTexture, int height) {
        this.fluidTexture = fluidTexture;
        this.height = height;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableSet.of();
    }

    public Collection<ResourceLocation> getTextures() {
        if (this.height > 0) {
            return ImmutableSet.of((Object)this.fluidTexture);
        }
        return ImmutableSet.of();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap map = PerspectiveMapWrapper.getTransforms((IModelState)state);
        return new BakedModelRubberTapLiquid(format, state.apply(Optional.empty()), map, this.fluidTexture != null ? bakedTextureGetter.apply(this.fluidTexture) : null, this.height);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public ModelRubberTapLiquid process(ImmutableMap<String, String> customData) {
        JsonParser parser = new JsonParser();
        ResourceLocation fluidTexture = this.fluidTexture;
        if (customData.containsKey((Object)"fluid_texture")) {
            fluidTexture = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"fluid_texture")), (String)"fluid_texture"));
        }
        if (fluidTexture == null) {
            fluidTexture = TextureMap.field_174945_f;
        }
        int height = 0;
        if (customData.containsKey((Object)"fluid_height")) {
            String fluidHeightJsonStr = (String)customData.get((Object)"fluid_height");
            height = JsonUtils.func_151215_f((JsonElement)parser.parse(fluidHeightJsonStr), (String)"fluid_height");
        }
        return new ModelRubberTapLiquid(fluidTexture, height);
    }

    private static final class BakedModelRubberTapLiquid
    implements IBakedModel {
        protected final TRSRTransformation transformation;
        protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final TextureAtlasSprite fluidSprite;
        private final List<BakedQuad> quads;

        private BakedModelRubberTapLiquid(VertexFormat format, Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, TextureAtlasSprite fluidSprite, int height) {
            this.fluidSprite = fluidSprite;
            this.transformation = transformation.orElse(null);
            this.transforms = transforms;
            if (height > 0) {
                QuadBuilder builder = new QuadBuilder(format).setSprite(this.fluidSprite).setTransformation(this.transformation);
                double liquidHeight = 0.1 + 0.043333333333333335 * (double)height;
                builder.setCullFace(EnumFacing.UP);
                builder.addVertexInferUV(0.225, liquidHeight, 0.485);
                builder.addVertexInferUV(0.225, liquidHeight, 1.18);
                builder.addVertexInferUV(0.775, liquidHeight, 1.18);
                builder.addVertexInferUV(0.775, liquidHeight, 0.485);
                this.quads = (List)builder.build().culledQuads.get(EnumFacing.UP);
            } else {
                this.quads = ImmutableList.of();
            }
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (side == EnumFacing.UP) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.fluidSprite;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        }
    }
}

