/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import thebetweenlands.client.render.model.entity.ModelRopeNode;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.entity.EntityRopeNode;
import thebetweenlands.util.LightingUtil;

public class RenderRopeNode
extends Render<EntityRopeNode> {
    private Frustum frustum = new Frustum();
    protected static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/blocks/bulb_capped_mushroom.png");
    protected static final ModelRopeNode nodeModel = new ModelRopeNode();

    public RenderRopeNode(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityRopeNode ropeNode, double x, double y, double z, float yaw, float partialTicks) {
        Entity nextNode;
        double dstSq;
        this.func_180548_c(ropeNode);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
        LightingUtil.INSTANCE.setLighting(255);
        AxisAlignedBB boundingBox = ropeNode.func_174813_aQ().func_72317_d(-ropeNode.field_70165_t, -ropeNode.field_70163_u, -ropeNode.field_70161_v);
        if (ropeNode.getNextNode() == null) {
            boundingBox = boundingBox.func_72314_b(0.025, 0.025, 0.025);
            GlStateManager.func_179131_c((float)0.25f, (float)1.0f, (float)0.25f, (float)0.35f);
        }
        if (ShaderHelper.INSTANCE.isWorldShaderActive() && (dstSq = x * x + y * y + z * z) <= 256.0) {
            ShaderHelper.INSTANCE.require();
            double rx = ropeNode.field_70142_S + (ropeNode.field_70165_t - ropeNode.field_70142_S) * (double)partialTicks;
            double ry = ropeNode.field_70137_T + (ropeNode.field_70163_u - ropeNode.field_70137_T) * (double)partialTicks;
            double rz = ropeNode.field_70136_U + (ropeNode.field_70161_v - ropeNode.field_70136_U) * (double)partialTicks;
            float brightness = 1.0f - (float)Math.sqrt(dstSq) / 16.0f;
            ShaderHelper.INSTANCE.getWorldShader().addLight(new LightSource(rx, ry, rz, 1.25f, 1.5f * brightness, 2.0f * brightness, 4.0f * brightness));
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        nodeModel.func_78088_a(ropeNode, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        LightingUtil.INSTANCE.revert();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        double camPosX = this.interpolate(ropeNode.field_70142_S, ropeNode.field_70165_t, partialTicks) - x;
        double camPosY = this.interpolate(ropeNode.field_70137_T, ropeNode.field_70163_u, partialTicks) - y;
        double camPosZ = this.interpolate(ropeNode.field_70136_U, ropeNode.field_70161_v, partialTicks) - z;
        this.frustum.func_78547_a(camPosX, camPosY, camPosZ);
        Entity prevNode = ropeNode.getPreviousNode();
        if (prevNode != null && !this.field_76990_c.func_78713_a(prevNode).func_177071_a(prevNode, (ICamera)this.frustum, camPosX, camPosY, camPosZ)) {
            GlStateManager.func_179094_E();
            double renderOffsetX = this.interpolate(prevNode.field_70142_S - ropeNode.field_70142_S, prevNode.field_70165_t - ropeNode.field_70165_t, partialTicks);
            double renderOffsetY = this.interpolate(prevNode.field_70137_T - ropeNode.field_70137_T, prevNode.field_70163_u - ropeNode.field_70163_u, partialTicks);
            double renderOffsetZ = this.interpolate(prevNode.field_70136_U - ropeNode.field_70136_U, prevNode.field_70161_v - ropeNode.field_70161_v, partialTicks);
            GlStateManager.func_179137_b((double)renderOffsetX, (double)renderOffsetY, (double)renderOffsetZ);
            this.renderConnection(prevNode, ropeNode, tessellator, buffer, x, y, z, partialTicks);
            GlStateManager.func_179121_F();
        }
        if ((nextNode = ropeNode.getNextNode()) != null) {
            this.renderConnection(ropeNode, nextNode, tessellator, buffer, x, y, z, partialTicks);
        }
        GlStateManager.func_179121_F();
    }

    protected double interpolate(double prev, double now, double partialTicks) {
        return prev + (now - prev) * partialTicks;
    }

    protected void renderConnection(Entity node1, Entity node2, Tessellator tessellator, BufferBuilder buffer, double x, double y, double z, float partialTicks) {
        if (node2 != null) {
            double yMult;
            float percentage;
            float b;
            float g;
            float r;
            int i;
            double camPosX = this.interpolate(node1.field_70169_q - x, node1.field_70165_t - x, partialTicks);
            double camPosY = this.interpolate(node1.field_70167_r - y, node1.field_70163_u - y, partialTicks);
            double camPosZ = this.interpolate(node1.field_70166_s - z, node1.field_70161_v - z, partialTicks);
            double startX = x;
            double startY = y;
            double startZ = z;
            double endX = this.interpolate(node2.field_70169_q - camPosX, node2.field_70165_t - camPosX, partialTicks);
            double endY = this.interpolate(node2.field_70167_r - camPosY, node2.field_70163_u - camPosY, partialTicks);
            if (!(node2 instanceof EntityRopeNode)) {
                endY += (double)node2.func_70047_e() / 2.0;
            }
            double endZ = this.interpolate(node2.field_70166_s - camPosZ, node2.field_70161_v - camPosZ, partialTicks);
            double diffX = (float)(endX - startX);
            double diffY = (float)(endY - startY);
            double diffZ = (float)(endZ - startZ);
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            buffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (i = 0; i <= 24; ++i) {
                if (i % 2 == 0) {
                    r = 0.0f;
                    g = 0.4f;
                    b = 0.0f;
                } else {
                    r = 0.0f;
                    g = 0.28f;
                    b = 0.0f;
                }
                percentage = (float)i / 24.0f;
                yMult = endY < startY ? (double)percentage * Math.sqrt(percentage) : (double)(percentage * percentage);
                buffer.func_181662_b(x + diffX * (double)percentage + 0.0, y + diffY * (yMult + (double)percentage) * 0.5, z + diffZ * (double)percentage).func_181666_a(r, g, b, 1.0f).func_181675_d();
                buffer.func_181662_b(x + diffX * (double)percentage + 0.025, y + diffY * (yMult + (double)percentage) * 0.5 + 0.025, z + diffZ * (double)percentage).func_181666_a(r, g, b, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            buffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (i = 0; i <= 24; ++i) {
                if (i % 2 == 0) {
                    r = 0.0f;
                    g = 0.4f;
                    b = 0.0f;
                } else {
                    r = 0.0f;
                    g = 0.28f;
                    b = 0.0f;
                }
                percentage = (float)i / 24.0f;
                yMult = endY < startY ? (double)percentage * Math.sqrt(percentage) : (double)(percentage * percentage);
                buffer.func_181662_b(x + diffX * (double)percentage + 0.0, y + diffY * (yMult + (double)percentage) * 0.5 + 0.025, z + diffZ * (double)percentage).func_181666_a(r, g, b, 1.0f).func_181675_d();
                buffer.func_181662_b(x + diffX * (double)percentage + 0.025, y + diffY * (yMult + (double)percentage) * 0.5, z + diffZ * (double)percentage + 0.025).func_181666_a(r, g, b, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            GlStateManager.func_179089_o();
        }
    }

    protected ResourceLocation getEntityTexture(EntityRopeNode entity) {
        return TEXTURE;
    }
}

