/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiWinGame;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.api.audio.IEntitySound;
import thebetweenlands.api.entity.IEntityMusic;
import thebetweenlands.client.audio.SoundSystemOpenALAccess;
import thebetweenlands.client.audio.ambience.AmbienceManager;
import thebetweenlands.client.gui.menu.GuiBLMainMenu;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.SoundRegistry;

public class MusicHandler {
    public static final MusicHandler INSTANCE = new MusicHandler();
    private static final int MIN_WAIT = 3000;
    private static final int MAX_WAIT = 6000;
    private static final int MIN_WAIT_MENU = 20;
    private static final int MAX_WAIT_MENU = 600;
    private final SoundSystemOpenALAccess openAlAccess = new SoundSystemOpenALAccess();
    private List<Sound> musicDimTrackAccessors;
    private List<Sound> musicMenuTrackAccessors;
    private Minecraft mc = Minecraft.func_71410_x();
    private final Random RNG = new Random();
    private int timeUntilMusic = 100;
    private ISound currentSound;
    private Sound previousSound;
    private IntSet playingEntityMusicLayers = new IntOpenHashSet();
    private Int2ObjectMap<IEntitySound> entityMusicMap = new Int2ObjectOpenHashMap();
    private boolean hasBlMainMenu = false;
    private boolean isInBlMainMenu = false;

    private MusicHandler() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSoundSystemLoad(SoundLoadEvent event) {
        if (event.getManager() == this.mc.func_147118_V().field_147694_f) {
            this.openAlAccess.cleanup();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.getGui() != null && event.getGui().getClass() == GuiMainMenu.class) {
            this.hasBlMainMenu = false;
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            boolean isInMainMenu;
            if (this.mc.func_147118_V() != null && !this.openAlAccess.isErrored() && !this.openAlAccess.isInitialized()) {
                this.openAlAccess.init(this.mc.func_147118_V().field_147694_f);
            }
            EntityPlayer player = this.getPlayer();
            boolean bl = isInMainMenu = !(this.mc.field_71462_r instanceof GuiWinGame) && this.mc.field_71439_g == null && BetweenlandsConfig.GENERAL.blMainMenu;
            if (this.mc.field_71462_r instanceof GuiBLMainMenu) {
                this.hasBlMainMenu = true;
            }
            boolean bl2 = this.isInBlMainMenu = isInMainMenu && this.hasBlMainMenu;
            if (this.isInBlMainMenu || player != null && player.field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
                Int2ObjectOpenHashMap closestMusicEntityMap = new Int2ObjectOpenHashMap();
                if (this.mc.field_71441_e != null) {
                    for (Entity entity : this.mc.field_71441_e.field_72996_f) {
                        int layer;
                        Entity closest;
                        if (!(entity instanceof IEntityMusic) || (closest = (Entity)closestMusicEntityMap.get(layer = ((IEntityMusic)entity).getMusicLayer(player))) != null && !(entity.func_70032_d((Entity)player) < closest.func_70032_d((Entity)player)) || !((double)entity.func_70032_d((Entity)player) <= ((IEntityMusic)entity).getMusicRange(player)) || !((IEntityMusic)entity).isMusicActive(player)) continue;
                        closestMusicEntityMap.put(layer, (Object)((IEntityMusic)entity));
                    }
                }
                IntIterator it = this.playingEntityMusicLayers.iterator();
                while (it.hasNext()) {
                    int layer = it.nextInt();
                    IEntitySound sound = (IEntitySound)this.entityMusicMap.get(layer);
                    if (!this.mc.func_147118_V().func_147692_c((ISound)sound)) {
                        it.remove();
                        this.entityMusicMap.remove(layer);
                        continue;
                    }
                    if (((IEntityMusic)sound.getMusicEntity()).isMusicActive(player)) continue;
                    sound.stopEntityMusic();
                }
                if (!closestMusicEntityMap.isEmpty()) {
                    for (Int2ObjectMap.Entry entry : closestMusicEntityMap.int2ObjectEntrySet()) {
                        IEntitySound currentlyPlaying = (IEntitySound)this.entityMusicMap.get(entry.getIntKey());
                        if (currentlyPlaying == null) {
                            IEntitySound newSound = ((IEntityMusic)entry.getValue()).getMusicSound(player);
                            if (newSound == null) continue;
                            this.entityMusicMap.put(entry.getIntKey(), (Object)newSound);
                            this.playingEntityMusicLayers.add(entry.getIntKey());
                            this.mc.func_147118_V().func_147682_a((ISound)newSound);
                            continue;
                        }
                        if (currentlyPlaying.getMusicEntity() == entry.getValue() || !((IEntityMusic)entry.getValue()).canInterruptOtherEntityMusic(player)) continue;
                        currentlyPlaying.stopEntityMusic();
                    }
                }
                if (!this.entityMusicMap.isEmpty() || AmbienceManager.INSTANCE.shouldStopMusic()) {
                    if (this.mc.func_147118_V().func_147692_c(this.currentSound)) {
                        this.mc.func_147118_V().func_147683_b(this.currentSound);
                        this.currentSound = null;
                        this.timeUntilMusic = Math.min(MathHelper.func_76136_a((Random)this.RNG, (int)3000, (int)6000), this.timeUntilMusic);
                    }
                } else if (this.mc.field_71474_y.func_186711_a(SoundCategory.MUSIC) > 0.0f) {
                    if (this.currentSound != null) {
                        if (!this.isInBlMainMenu && SoundRegistry.BL_MUSIC_MENU.func_187503_a().equals((Object)this.currentSound.func_147650_b()) || this.isInBlMainMenu && SoundRegistry.BL_MUSIC_DIMENSION.func_187503_a().equals((Object)this.currentSound.func_147650_b())) {
                            this.mc.func_147118_V().func_147683_b(this.currentSound);
                            this.timeUntilMusic = MathHelper.func_76136_a((Random)this.RNG, (int)0, (int)((this.isInBlMainMenu ? 20 : 3000) / 2));
                        }
                        if (!this.mc.func_147118_V().func_147692_c(this.currentSound)) {
                            this.currentSound = null;
                            this.timeUntilMusic = Math.min(MathHelper.func_76136_a((Random)this.RNG, (int)(this.isInBlMainMenu ? 20 : 3000), (int)(this.isInBlMainMenu ? 600 : 6000)), this.timeUntilMusic);
                        }
                    }
                    this.timeUntilMusic = Math.min(this.timeUntilMusic, this.isInBlMainMenu ? 600 : 6000);
                    if (this.currentSound == null && this.timeUntilMusic-- <= 0) {
                        this.timeUntilMusic = Integer.MAX_VALUE;
                        this.playRandomSoundTrack();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        EntityPlayer player = this.getPlayer();
        if ((this.isInBlMainMenu || player != null && player.field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) && event.getSound().func_184365_d() == SoundCategory.MUSIC && !this.isBetweenlandsMusic(event.getSound())) {
            event.setResultSound(null);
        }
    }

    public boolean isBetweenlandsMusic(ISound sound) {
        if (SoundRegistry.BL_MUSIC_DIMENSION.func_187503_a().equals((Object)sound.func_147650_b())) {
            return true;
        }
        if (SoundRegistry.BL_MUSIC_MENU.func_187503_a().equals((Object)sound.func_147650_b())) {
            return true;
        }
        if (SoundRegistry.FORTRESS_BOSS_LOOP.func_187503_a().equals((Object)sound.func_147650_b())) {
            return true;
        }
        if (SoundRegistry.DREADFUL_PEAT_MUMMY_LOOP.func_187503_a().equals((Object)sound.func_147650_b())) {
            return true;
        }
        if (SoundRegistry.PIT_OF_DECAY_LOOP.func_187503_a().equals((Object)sound.func_147650_b())) {
            return true;
        }
        ArrayList<Sound> betweenlandsSoundTracks = new ArrayList<Sound>(this.getBetweenlandsMusicTracks());
        betweenlandsSoundTracks.addAll(this.getBetweenlandsMenuMusicTracks());
        for (Sound blSound : betweenlandsSoundTracks) {
            if (!blSound.func_188719_a().equals((Object)sound.func_147650_b())) continue;
            return true;
        }
        return false;
    }

    public List<Sound> getBetweenlandsMenuMusicTracks() {
        if (this.musicMenuTrackAccessors == null) {
            try {
                this.musicMenuTrackAccessors = new ArrayList<Sound>();
                SoundEventAccessor soundEventAccessor = this.mc.func_147118_V().func_184398_a(SoundRegistry.BL_MUSIC_MENU.func_187503_a());
                if (soundEventAccessor != null) {
                    List soundAccessors = soundEventAccessor.field_188716_a;
                    for (ISoundEventAccessor accessor : soundAccessors) {
                        if (!(accessor instanceof Sound)) continue;
                        this.musicMenuTrackAccessors.add((Sound)accessor);
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.musicMenuTrackAccessors;
    }

    public List<Sound> getBetweenlandsMusicTracks() {
        if (this.musicDimTrackAccessors == null) {
            try {
                this.musicDimTrackAccessors = new ArrayList<Sound>();
                SoundEventAccessor soundEventAccessor = this.mc.func_147118_V().func_184398_a(SoundRegistry.BL_MUSIC_DIMENSION.func_187503_a());
                if (soundEventAccessor != null) {
                    List soundAccessors = soundEventAccessor.field_188716_a;
                    for (ISoundEventAccessor accessor : soundAccessors) {
                        if (!(accessor instanceof Sound)) continue;
                        this.musicDimTrackAccessors.add((Sound)accessor);
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.musicDimTrackAccessors;
    }

    public void playRandomSoundTrack() {
        ArrayList<Sound> availableSounds = new ArrayList<Sound>(this.isInBlMainMenu ? this.getBetweenlandsMenuMusicTracks() : this.getBetweenlandsMusicTracks());
        if (!availableSounds.isEmpty()) {
            if (availableSounds.size() > 1 && this.previousSound != null) {
                availableSounds.remove(this.previousSound);
            }
            int weight = 0;
            for (Sound sound : availableSounds) {
                weight += sound.func_148721_a();
            }
            if (weight != 0) {
                ISound playingSound;
                Sound sound;
                int choice = this.RNG.nextInt(weight);
                Iterator entryIter = availableSounds.iterator();
                while ((choice -= (sound = (Sound)entryIter.next()).func_148721_a()) >= 0) {
                }
                this.previousSound = sound;
                PositionedSoundRecord parentSound = PositionedSoundRecord.func_184370_a((SoundEvent)(this.isInBlMainMenu ? SoundRegistry.BL_MUSIC_MENU : SoundRegistry.BL_MUSIC_DIMENSION));
                this.currentSound = playingSound = SoundWrapper.wrap((ISound)parentSound, sound);
                this.mc.func_147118_V().func_147682_a(playingSound);
            }
        }
    }

    @Nullable
    public EntityPlayer getPlayer() {
        return this.mc.field_71439_g;
    }

    public SoundSystemOpenALAccess getOpenALAccess() {
        return this.openAlAccess;
    }

    @Nullable
    public IEntitySound getEntityMusic(int layer) {
        return (IEntitySound)this.entityMusicMap.get(layer);
    }

    protected static class SoundWrapperTickable
    extends SoundWrapper
    implements ITickableSound {
        private final ITickableSound parent;

        private SoundWrapperTickable(ITickableSound parent, Sound sound) {
            super((ISound)parent, sound);
            this.parent = parent;
        }

        public void func_73660_a() {
            this.parent.func_73660_a();
        }

        public boolean func_147667_k() {
            return this.parent.func_147667_k();
        }
    }

    public static class SoundWrapper
    implements ISound {
        private final ISound parent;
        private final Sound sound;

        private SoundWrapper(ISound parent, Sound sound) {
            this.parent = parent;
            this.sound = sound;
        }

        public static ISound wrap(ISound parent, Sound sound) {
            if (parent instanceof ITickableSound) {
                return new SoundWrapperTickable((ITickableSound)parent, sound);
            }
            return new SoundWrapper(parent, sound);
        }

        public ResourceLocation func_147650_b() {
            return this.sound.func_188719_a();
        }

        public SoundEventAccessor func_184366_a(SoundHandler handler) {
            SoundEventAccessor parentAccessor = this.parent.func_184366_a(handler);
            ITextComponent subtitle = parentAccessor != null ? parentAccessor.func_188712_c() : null;
            SoundEventAccessor accessor = new SoundEventAccessor(this.sound.func_188719_a(), subtitle != null ? subtitle.func_150254_d() : null);
            return accessor;
        }

        public Sound func_184364_b() {
            return this.sound;
        }

        public SoundCategory func_184365_d() {
            return this.parent.func_184365_d();
        }

        public boolean func_147657_c() {
            return this.parent.func_147657_c();
        }

        public int func_147652_d() {
            return this.parent.func_147652_d();
        }

        public float func_147653_e() {
            return this.sound.func_188724_c();
        }

        public float func_147655_f() {
            return this.sound.func_188725_d();
        }

        public float func_147649_g() {
            return this.parent.func_147649_g();
        }

        public float func_147654_h() {
            return this.parent.func_147654_h();
        }

        public float func_147651_i() {
            return this.parent.func_147651_i();
        }

        public ISound.AttenuationType func_147656_j() {
            return this.parent.func_147656_j();
        }
    }
}

