/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.endergy.conduit;

import com.enderio.core.client.render.IconUtil;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.conduits.conduit.ItemConduitSubtype;
import crazypants.enderio.conduits.conduit.power.IPowerConduitData;
import crazypants.enderio.conduits.render.ConduitTexture;
import crazypants.enderio.conduits.render.ConduitTextureWrapper;
import crazypants.enderio.endergy.config.EndergyConfig;
import crazypants.enderio.endergy.init.EndergyObject;
import info.loenwind.autoconfig.factory.IValue;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class EndergyPowerConduitData
implements IPowerConduitData {
    private static final int OFFSET = 10;
    static final Data[] POSTFIX = new Data[]{new Data("_cobble", 0, 0), new Data("_iron", 0, 1), new Data("_alu", 0, 2), new Data("_gold", 0, 3), new Data("_copper", 1, 0), new Data("_silver", 1, 1), new Data("_electrum", 1, 2), new Data("_energetic_silver", 1, 3), new Data("_crystalline", 2, 0), new Data("_pink_slime", 2, 1), new Data("_melodic", 2, 2), new Data("_stellar", 2, 3)};
    private final int id;
    @Nonnull
    private final IConduitTexture icon;
    @Nonnull
    private final IConduitTexture core;

    static int damage2id(int dmg) {
        return dmg + 10;
    }

    static ItemConduitSubtype[] createSubTypes(IModObject modObject) {
        ItemConduitSubtype[] types = new ItemConduitSubtype[POSTFIX.length];
        for (int i = 0; i < POSTFIX.length; ++i) {
            types[i] = new ItemConduitSubtype(modObject.getUnlocalisedName() + POSTFIX[i], modObject.getRegistryName().toString() + POSTFIX[i]);
        }
        return types;
    }

    public EndergyPowerConduitData(int id, @Nonnull IConduitTexture icon, @Nonnull IConduitTexture core) {
        this.id = 10 + id;
        this.icon = icon;
        this.core = core;
    }

    public int getID() {
        return this.id;
    }

    @Nonnull
    public ItemStack createItemStackForSubtype() {
        return new ItemStack(EndergyObject.itemEndergyConduit.getItemNN(), 1, this.getIndex());
    }

    public int getMaxEnergyIO() {
        return (Integer)((IValue)EndergyConfig.maxIO.get(this.getIndex())).get();
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IConduitTexture getTextureForState(@Nonnull CollidableComponent component) {
        if (component.isCore()) {
            return this.core;
        }
        if ("ColorController".equals(component.data)) {
            return new ConduitTextureWrapper(IconUtil.instance.whiteTexture);
        }
        return this.icon;
    }

    private int getIndex() {
        return this.getID() - 10;
    }

    static {
        for (int i = 0; i < POSTFIX.length; ++i) {
            IPowerConduitData.Registry.register((IPowerConduitData)new EndergyPowerConduitData(i, (IConduitTexture)POSTFIX[i].armfile("blocks/power_conduit"), (IConduitTexture)POSTFIX[i].corefile("blocks/power_conduit_core")));
        }
    }

    private static class Data {
        @Nonnull
        final String postfix;
        final int file;
        final int idx;

        Data(@Nonnull String postfix, int file, int idx) {
            this.postfix = postfix;
            this.file = file;
            this.idx = idx;
        }

        @Nonnull
        ConduitTexture corefile(@Nonnull String key) {
            return new ConduitTexture(TextureRegistry.registerTexture((String)(key + "_endergy_" + this.file)), ConduitTexture.core((int)this.idx));
        }

        @Nonnull
        ConduitTexture armfile(@Nonnull String key) {
            return new ConduitTexture(TextureRegistry.registerTexture((String)(key + "_endergy_" + this.file)), ConduitTexture.arm((int)this.idx));
        }

        public String toString() {
            return this.postfix;
        }
    }
}

