/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public final class Util {
    public static final Map<Integer, String> PREFIXES;

    public static String hoursMinsSecsFromTicks(int ticks, char ... symbols) {
        int hours = ticks / 72000 % 24;
        int minutes = (ticks -= hours * 20 * 60 * 60) / 1200 % 60;
        int seconds = (ticks -= minutes * 20 * 60) / 20;
        if (hours > 0) {
            return String.format("%d%s%d%s%d%s", hours, Character.valueOf(symbols[0]), minutes, Character.valueOf(symbols[1]), seconds, Character.valueOf(symbols[2]));
        }
        if (minutes > 0) {
            return String.format("%d%s%d%s", minutes, Character.valueOf(symbols[1]), seconds, Character.valueOf(symbols[2]));
        }
        return String.format("%d%s", seconds, Character.valueOf(symbols[2]));
    }

    public static String metricPrefixise(int number) {
        String ret = number <= 1 ? "" : (number < 10000 ? String.valueOf(number) : (number < 1000000 ? String.valueOf(number / 1000) + "k" : (number < 1000000000 ? String.valueOf(number / 1000000) + "M" : String.valueOf(number / 1000000000) + "G")));
        return ret;
    }

    public static int blendColors(int colour1, int colour2, float ratio) {
        int[][] argb = new int[][]{{colour1 >> 24 & 0xFF, colour1 >> 16 & 0xFF, colour1 >> 8 & 0xFF, colour1 & 0xFF}, {colour2 >> 24 & 0xFF, colour2 >> 16 & 0xFF, colour2 >> 8 & 0xFF, colour2 & 0xFF}};
        int a = Math.round((1.0f - ratio) * (float)argb[0][0] + ratio * (float)argb[1][0]);
        int r = Math.round((1.0f - ratio) * (float)argb[0][1] + ratio * (float)argb[1][1]);
        int g = Math.round((1.0f - ratio) * (float)argb[0][2] + ratio * (float)argb[1][2]);
        int b = Math.round((1.0f - ratio) * (float)argb[0][3] + ratio * (float)argb[1][3]);
        return b | g << 8 | r << 16 | a << 24;
    }

    public static String getRomanNumeral(int number) {
        return String.join((CharSequence)"", Collections.nCopies(number, "I")).replace("IIIII", "V").replace("IIII", "IV").replace("VV", "X").replace("VIV", "IX").replace("XXXXX", "L").replace("XXXX", "XL").replace("LL", "C").replace("LXL", "XC").replace("CCCCC", "D").replace("CCCC", "CD").replace("DD", "M").replace("DCD", "CM");
    }

    public static void mergeItemStack(ItemStack stackToMerge, Collection<ItemStack> collection) {
        if (!stackToMerge.func_190926_b()) {
            boolean merged = false;
            for (ItemStack itemStack : collection) {
                if (!itemStack.func_77969_a(stackToMerge) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)stackToMerge)) continue;
                itemStack.func_190917_f(stackToMerge.func_190916_E());
                merged = true;
                break;
            }
            if (!merged) {
                collection.add(stackToMerge.func_77946_l());
            }
        }
    }

    public static boolean isHoldingItem(EntityPlayer player, Item item) {
        for (EnumHand hand : EnumHand.values()) {
            if (player.func_184586_b(hand).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    static {
        HashMap<Integer, String> tempPrefixes = new HashMap<Integer, String>();
        tempPrefixes.put(0, "");
        tempPrefixes.put(3, "k");
        tempPrefixes.put(6, "M");
        tempPrefixes.put(9, "G");
        tempPrefixes.put(12, "T");
        tempPrefixes.put(15, "P");
        tempPrefixes.put(-3, "m");
        PREFIXES = Collections.unmodifiableMap(tempPrefixes);
    }
}

