/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.trade;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import logictechcorp.libraryex.trade.Trade;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class TraderProfession<P extends TraderProfession<P, C>, C extends Career>
extends IForgeRegistryEntry.Impl<P> {
    private ResourceLocation name;
    private List<C> careers = new ArrayList<C>();

    public TraderProfession(ResourceLocation name) {
        this.name = name;
        this.setRegistryName(this.name);
    }

    public void registerCareer(C career) {
        if (((Career)career).getProfession() == this) {
            if (this.careers.contains(career)) {
                throw new IllegalArgumentException(String.format("Attempted to register the %s career, but it is already registered.", ((Career)career).getName()));
            }
        } else {
            throw new IllegalArgumentException(String.format("Attempted to register the %s career with the %s profession, instead of the %s profession.", new Object[]{((Career)career).getName(), this, ((Career)career).getProfession()}));
        }
        ((Career)career).setId(this.careers.size());
        this.careers.add(career);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public List<C> getCareers() {
        return this.careers;
    }

    public C getCareer(int id) {
        if (id < 0 || id > this.careers.size()) {
            return (C)((Career)this.careers.get(0));
        }
        return (C)((Career)this.careers.get(id));
    }

    public C getCareer(ResourceLocation careerName) {
        return (C)((Career)this.careers.stream().filter(career -> careerName.equals((Object)career.getName())).findFirst().orElse(null));
    }

    public C getRandomCareer(Random random) {
        return (C)((Career)this.careers.get(random.nextInt(this.careers.size())));
    }

    public static abstract class Career<P extends TraderProfession<P, C>, C extends Career<P, C>> {
        private ResourceLocation name;
        private P profession;
        private ResourceLocation lootTable;
        private ResourceLocation texture;
        private ResourceLocation alternateTexture;
        private int id;
        private final List<Trade> trades;

        protected Career(ResourceLocation name, P profession, ResourceLocation lootTable, ResourceLocation texture, ResourceLocation alternateTexture) {
            this.name = name;
            this.profession = profession;
            this.lootTable = lootTable;
            this.texture = texture;
            this.alternateTexture = alternateTexture;
            this.trades = new ArrayList<Trade>();
        }

        public void addTrade(Trade trade) {
            if (this.trades.stream().noneMatch(trade::equals)) {
                this.trades.add(trade);
            }
        }

        public void removeTrade(Trade trade) {
            this.trades.remove((Object)trade);
        }

        public ResourceLocation getName() {
            return this.name;
        }

        public P getProfession() {
            return this.profession;
        }

        public ResourceLocation getLootTable() {
            return this.lootTable;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public ResourceLocation getAlternateTexture() {
            return this.alternateTexture;
        }

        public int getId() {
            return this.id;
        }

        public List<Trade> getTrades() {
            return ImmutableList.copyOf(this.trades);
        }

        public List<Trade> getTradesForLevel(int tradeLevel) {
            return this.trades.stream().filter(k -> tradeLevel == k.getTradeLevel()).collect(Collectors.toList());
        }

        void setId(int id) {
            this.id = id;
        }
    }
}

