/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.trade;

import com.electronwill.nightconfig.core.Config;
import logictechcorp.libraryex.utility.ConfigHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class TradeStack {
    public static final TradeStack EMPTY = new TradeStack(ItemStack.field_190927_a, 0, 0);
    protected ItemStack stack;
    protected int minCount;
    protected int maxCount;

    public TradeStack(ItemStack stack, int minCount, int maxCount) {
        this.stack = stack;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public TradeStack(Item item, int meta, int minCount, int maxCount) {
        this(new ItemStack(item, 1, meta), minCount, maxCount);
    }

    public TradeStack(Item item, int minCount, int maxCount) {
        this(item, 0, minCount, maxCount);
    }

    public TradeStack(Block block, int meta, int minCount, int maxCount) {
        this(new ItemStack(block, 1, meta), minCount, maxCount);
    }

    public TradeStack(Block block, int minCount, int maxCount) {
        this(block, block.func_176201_c(block.func_176223_P()), minCount, maxCount);
    }

    public TradeStack(Config config, String path) {
        this.stack = ConfigHelper.getItemStack(config, path);
        this.minCount = (Integer)config.getOrElse(path + ".minCount", (Object)1);
        this.maxCount = (Integer)config.getOrElse(path + ".maxCount", (Object)this.stack.func_77976_d());
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }
}

