/*
 * Decompiled with CFR 0.152.
 */
package com.kjmaster.inventorygenerators.common.generators;

import com.kjmaster.inventorygenerators.InventoryGenerators;
import com.kjmaster.inventorygenerators.actuallyadditions.RiceBallCheck;
import com.kjmaster.inventorygenerators.common.CommonProxy;
import com.kjmaster.inventorygenerators.common.generators.ItemInventoryGenerator;
import com.kjmaster.inventorygenerators.tinkers.SlimeballChecks;
import com.kjmaster.kjlib.utils.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class ItemInvSlimeyGen
extends ItemInventoryGenerator {
    public ItemInvSlimeyGen() {
        super("inv_slimey_gen");
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.invgens.slimey"));
        this.addMoreInformation(stack, tooltip);
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        Item item = stack.func_77973_b();
        return !stack.func_190926_b() && CommonProxy.slimeThings.contains(item);
    }

    @Override
    public int calculateTime(ItemStack stack) {
        return !stack.func_190926_b() ? 20 : 0;
    }

    @Override
    public int calculatePower(ItemStack stack) {
        int minSend = 40;
        Item fuel = this.getFuel(stack).func_77973_b();
        if (Loader.isModLoaded((String)"tconstruct")) {
            if (SlimeballChecks.isBlueOrOrange(fuel)) {
                minSend = 40;
            } else if (SlimeballChecks.isBlood(fuel)) {
                minSend = 120;
            } else if (SlimeballChecks.isPurple(fuel)) {
                minSend = 120;
            }
        }
        if (Loader.isModLoaded((String)"actuallyadditions") && RiceBallCheck.isRiceball(fuel)) {
            minSend = 40;
        }
        if (fuel instanceof ItemBlock) {
            minSend = 360;
        }
        if (stack.func_190926_b()) {
            minSend = 0;
        }
        return Math.min(this.getMaxEnergyStored(stack) - this.getInternalEnergyStored(stack), minSend);
    }

    @Override
    public int getSend() {
        return 360;
    }

    @Override
    public void initModel() {
        super.initModel();
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        super.func_77659_a(world, player, hand);
        if (!player.func_70093_af()) {
            player.openGui((Object)InventoryGenerators.instance, 12, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        ItemStack stack = player.func_184586_b(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }
}

