/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.shapes;

import com.google.common.base.Predicate;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpCircle;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.spell.ILingeringModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverride;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceShape;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RayTrace;
import com.teamwizardry.wizardry.api.util.RenderUtils;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.common.module.shapes.IShapeOverrides;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="shape_zone")
public class ModuleShapeZone
implements IModuleShape,
ILingeringModule {
    private static final String ZONE_TICK = "zone_tick";

    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_aoe", "modifier_increase_potency", "modifier_extend_range", "modifier_extend_time"};
    }

    @Override
    public boolean ignoreResultsForRendering() {
        return true;
    }

    @Override
    public boolean shouldRunChildren() {
        return false;
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
        boolean overriden = overrides.onRunZone(world, spell, spellRing);
        if (overriden) {
            return true;
        }
        Vec3d targetPos = spell.getTarget(world);
        if (targetPos == null) {
            return false;
        }
        double maxPotency = spellRing.getModule() != null ? (double)spellRing.getModule().getAttributeRanges().get((Object)AttributeRegistry.POTENCY).max : 1.0;
        double minPotency = spellRing.getModule() != null ? (double)spellRing.getModule().getAttributeRanges().get((Object)AttributeRegistry.POTENCY).min : 1.0;
        double aoe = spellRing.getAttributeValue(world, AttributeRegistry.AREA, spell);
        double potency = Math.max(minPotency, (double)spellRing.getAttributeValue(world, AttributeRegistry.POTENCY, spell));
        double range = spellRing.getAttributeValue(world, AttributeRegistry.RANGE, spell);
        Vec3d min = targetPos.func_178786_a(aoe, range, aoe);
        Vec3d max = targetPos.func_72441_c(aoe, range, aoe);
        NBTTagCompound info = spell.getDataWithFallback(SpellData.DefaultKeys.COMPOUND, new NBTTagCompound());
        double zoneTick = 0.0;
        if (!NBTHelper.hasKey((NBTTagCompound)info, (String)ZONE_TICK)) {
            NBTHelper.setDouble((NBTTagCompound)info, (String)ZONE_TICK, (double)(maxPotency - potency));
        } else {
            double d;
            zoneTick = NBTHelper.getDouble((NBTTagCompound)info, (String)ZONE_TICK, (double)maxPotency);
            zoneTick -= 1.0;
            if (d < 0.0) {
                zoneTick = maxPotency - potency;
            }
            NBTHelper.setDouble((NBTTagCompound)info, (String)ZONE_TICK, (double)zoneTick);
        }
        spell.addData(SpellData.DefaultKeys.COMPOUND, info);
        if (zoneTick == 0.0) {
            if (!spellRing.taxCaster(world, spell, true)) {
                info.func_74780_a(ZONE_TICK, zoneTick);
                spell.addData(SpellData.DefaultKeys.COMPOUND, info);
                return false;
            }
            BlockPos target = new BlockPos(RandUtil.nextDouble(min.field_72450_a, max.field_72450_a), RandUtil.nextDouble(min.field_72448_b, max.field_72448_b), RandUtil.nextDouble(min.field_72449_c, max.field_72449_c));
            List entities = world.func_72839_b(null, new AxisAlignedBB(target));
            for (Entity entity : entities) {
                Vec3d vec = new Vec3d(RandUtil.nextDouble(min.field_72450_a, max.field_72450_a), RandUtil.nextDouble(min.field_72448_b, max.field_72448_b), RandUtil.nextDouble(min.field_72449_c, max.field_72449_c));
                SpellData copy = spell.copy();
                copy.processEntity(entity, false);
                copy.addData(SpellData.DefaultKeys.YAW, Float.valueOf(entity.field_70177_z));
                copy.addData(SpellData.DefaultKeys.PITCH, Float.valueOf(entity.field_70125_A));
                copy.addData(SpellData.DefaultKeys.ORIGIN, vec);
                if (spellRing.getChildRing() == null) continue;
                spellRing.getChildRing().runSpellRing(world, spell, true);
            }
            Vec3d pos = new Vec3d((Vec3i)target).func_72441_c(0.5, 0.5, 0.5);
            if (pos.func_72436_e(targetPos) > aoe * aoe) {
                return true;
            }
            SpellData copy = spell.copy();
            copy.addData(SpellData.DefaultKeys.ORIGIN, pos);
            copy.processBlock(target, EnumFacing.UP, pos);
            copy.addData(SpellData.DefaultKeys.YAW, Float.valueOf(RandUtil.nextFloat(-180.0f, 180.0f)));
            copy.addData(SpellData.DefaultKeys.PITCH, Float.valueOf(RandUtil.nextFloat(-50.0f, 50.0f)));
            if (spellRing.getChildRing() != null) {
                spellRing.getChildRing().runSpellRing(world, copy, true);
            }
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SpellData renderVisualization(@Nonnull World world, ModuleInstanceShape instance, @Nonnull SpellData data, @Nonnull SpellRing ring, float partialTicks) {
        Vec3d look = data.getData(SpellData.DefaultKeys.LOOK);
        Entity caster = data.getCaster(world);
        if (caster == null) {
            return data;
        }
        if (look == null) {
            return data;
        }
        double interpPosX = caster.field_70142_S + (caster.field_70165_t - caster.field_70142_S) * (double)partialTicks;
        double interpPosY = caster.field_70137_T + (caster.field_70163_u - caster.field_70137_T) * (double)partialTicks;
        double interpPosZ = caster.field_70136_U + (caster.field_70161_v - caster.field_70136_U) * (double)partialTicks;
        RayTraceResult result = new RayTrace(world, look, new Vec3d(interpPosX, interpPosY + (double)caster.func_70047_e(), interpPosZ), caster instanceof EntityLivingBase ? ((EntityLivingBase)caster).func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() : 5.0).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != caster)).setReturnLastUncollidableBlock(true).setIgnoreBlocksWithoutBoundingBoxes(true).trace();
        data.processTrace(result);
        BlockPos pos = data.getTargetPos();
        if (pos == null) {
            return data;
        }
        data.processTrace(result);
        Vec3d target = data.getTarget(world);
        if (target == null) {
            return data;
        }
        double aoe = ring.getAttributeValue(world, AttributeRegistry.AREA, data);
        RenderUtils.drawCircle(target, aoe, false, false);
        return data;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
        if (overrides.onRenderZone(world, spell, spellRing)) {
            return;
        }
        Vec3d target = spell.getTarget(world);
        if (target == null) {
            return;
        }
        if (RandUtil.nextInt(10) != 0) {
            return;
        }
        double aoe = spellRing.getAttributeValue(world, AttributeRegistry.AREA, spell);
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
        glitter.setCollision(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new InterpCircle(target, new Vec3d(0.0, 1.0, 0.0), (float)aoe, 1.0f, RandUtil.nextFloat()), (int)((int)(aoe * 25.0)), (int)10, (aFloat, particleBuilder) -> {
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.3f));
            glitter.setLifetime(RandUtil.nextInt(30, 50));
            glitter.setColorFunction((InterpFunction)new InterpColorHSV(spellRing.getPrimaryColor(), spellRing.getSecondaryColor()));
            glitter.setMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.01, 0.01)));
        });
    }

    @Override
    public int getLingeringTime(World world, SpellData spell, SpellRing spellRing) {
        return (int)spellRing.getAttributeValue(world, AttributeRegistry.DURATION, spell) * 10;
    }

    @ModuleOverride(value="shape_zone_run")
    public boolean onRunZone(World world, SpellData data, SpellRing shape) {
        return false;
    }

    @ModuleOverride(value="shape_zone_render")
    public boolean onRenderZone(World world, SpellData data, SpellRing shape) {
        return false;
    }
}

