/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.shapes;

import com.google.common.base.Predicate;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.spell.IContinuousModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.ContextSuper;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverride;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleOverrideSuper;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RayTrace;
import com.teamwizardry.wizardry.api.util.RenderUtils;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.common.module.shapes.IShapeOverrides;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="shape_beam")
@Mod.EventBusSubscriber(modid="wizardry")
public class ModuleShapeBeam
implements IModuleShape,
IContinuousModule {
    public static final String BEAM_OFFSET = "beam offset";
    public static final String BEAM_CAST = "beam cast";
    public static final HashMap<ItemStack, BeamTicker> beamTickMap = new HashMap();

    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_extend_range", "modifier_increase_potency"};
    }

    @Override
    public boolean ignoreResultsForRendering() {
        return true;
    }

    @Override
    public boolean shouldRunChildren() {
        return false;
    }

    @SubscribeEvent
    public static void tick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side == Side.SERVER) {
            return;
        }
        ItemStack stack = event.player.func_184614_ca();
        beamTickMap.keySet().removeIf(itemStack -> !ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)stack));
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d look = spell.getData(SpellData.DefaultKeys.LOOK);
        Vec3d position = spell.getOrigin(world);
        Entity caster = spell.getCaster(world);
        if (look == null || position == null || caster == null) {
            return false;
        }
        ItemStack stack = ((EntityLivingBase)caster).func_184614_ca();
        if (stack.func_190926_b()) {
            return true;
        }
        beamTickMap.putIfAbsent(stack, new BeamTicker());
        BeamTicker ticker = beamTickMap.get(stack);
        double range = spellRing.getAttributeValue(world, AttributeRegistry.RANGE, spell);
        double potency = spellRing.getAttributeValue(world, AttributeRegistry.POTENCY, spell);
        double beamOffset = ticker.ticks + potency;
        ticker.cast = false;
        if (beamOffset >= (double)ConfigValues.beamTimer) {
            beamOffset %= (double)ConfigValues.beamTimer;
            if (!spellRing.taxCaster(world, spell, true)) {
                ticker.ticks = beamOffset;
                return false;
            }
            IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
            overrides.onRunBeam(world, spell, spellRing);
            RayTraceResult trace = new RayTrace(world, look, position, range).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != caster)).setReturnLastUncollidableBlock(true).setIgnoreBlocksWithoutBoundingBoxes(true).trace();
            spell.processTrace(trace, look.func_186678_a(range));
            if (spellRing.getChildRing() != null) {
                spellRing.getChildRing().runSpellRing(world, spell, true);
            }
            ticker.cast = true;
            instance.sendRenderPacket(world, spell, spellRing);
        }
        ticker.ticks = beamOffset;
        return true;
    }

    @Override
    @NotNull
    public SpellData renderVisualization(@Nonnull World world, ModuleInstanceShape instance, @Nonnull SpellData data, @Nonnull SpellRing ring, float partialTicks) {
        Vec3d look = data.getData(SpellData.DefaultKeys.LOOK);
        Vec3d position = data.getOrigin(world);
        Entity caster = data.getCaster(world);
        if (look == null || position == null || caster == null) {
            return data;
        }
        double range = ring.getAttributeValue(world, AttributeRegistry.RANGE, data);
        double interpPosX = caster.field_70142_S + (caster.field_70165_t - caster.field_70142_S) * (double)partialTicks;
        double interpPosY = caster.field_70137_T + (caster.field_70163_u - caster.field_70137_T) * (double)partialTicks;
        double interpPosZ = caster.field_70136_U + (caster.field_70161_v - caster.field_70136_U) * (double)partialTicks;
        RayTraceResult result = new RayTrace(world, look, new Vec3d(interpPosX, interpPosY + (double)caster.func_70047_e(), interpPosZ), range).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != caster)).setReturnLastUncollidableBlock(true).setIgnoreBlocksWithoutBoundingBoxes(true).trace();
        data.processTrace(result, look.func_186678_a(range));
        Vec3d target = data.getTarget(world);
        if (target == null) {
            return data;
        }
        RenderUtils.drawCircle(target, 0.3, true, false);
        return data;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
        if (overrides.onRenderBeam(world, spell, spellRing)) {
            return;
        }
        Vec3d look = spell.getData(SpellData.DefaultKeys.LOOK);
        Vec3d position = spell.getOrigin(world);
        Entity caster = spell.getCaster(world);
        if (look == null || position == null || caster == null) {
            return;
        }
        ItemStack stack = ((EntityLivingBase)caster).func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        double range = spellRing.getAttributeValue(world, AttributeRegistry.RANGE, spell);
        RayTraceResult trace = new RayTrace(world, look, position, range).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != caster)).setReturnLastUncollidableBlock(true).setIgnoreBlocksWithoutBoundingBoxes(true).trace();
        Vec3d target = trace.field_72307_f;
        if (target == null) {
            return;
        }
        LibParticles.SHAPE_BEAM(world, target, spell.getOriginHand(world), RandUtil.nextBoolean() ? spellRing.getPrimaryColor() : spellRing.getSecondaryColor());
    }

    @ModuleOverride(value="shape_beam_render")
    public boolean onRenderBeam(World world, SpellData data, SpellRing shape) {
        return false;
    }

    @ModuleOverride(value="shape_beam_run")
    public void onRunBeam(World world, @ContextSuper ModuleOverrideSuper ovdSuper, SpellData data, SpellRing shape) {
    }

    public static class BeamTicker {
        boolean cast = false;
        double ticks = 0.0;

        BeamTicker() {
        }
    }
}

