/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell.module;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.SpellObjectManager;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorld;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorldCapability;
import com.teamwizardry.wizardry.api.events.SpellCastEvent;
import com.teamwizardry.wizardry.api.spell.ILingeringModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellDataTypes;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeModifier;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRange;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModule;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.IModuleEvent;
import com.teamwizardry.wizardry.api.spell.module.IModuleModifier;
import com.teamwizardry.wizardry.api.spell.module.IModuleShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleFactory;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEvent;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceModifier;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleRegistry;
import com.teamwizardry.wizardry.api.spell.module.ModuleType;
import com.teamwizardry.wizardry.api.util.DefaultHashMap;
import com.teamwizardry.wizardry.common.network.PacketRenderSpell;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ModuleInstance {
    protected final String moduleNBTKey;
    protected final ModuleFactory createdByFactory;
    protected final IModule moduleClass;
    protected final ResourceLocation icon;
    protected final List<AttributeModifier> attributeModifiers = new ArrayList<AttributeModifier>();
    protected Map<AttributeRegistry.Attribute, AttributeRange> attributeRanges;
    protected Color primaryColor;
    protected Color secondaryColor;
    protected ItemStack itemStack;
    protected ModuleInstanceModifier[] applicableModifiers = null;

    @Nullable
    public static ModuleInstance deserialize(NBTTagString tagString) {
        return ModuleRegistry.INSTANCE.getModule(tagString.func_150285_a_());
    }

    @Nullable
    public static ModuleInstance deserialize(String id) {
        return ModuleRegistry.INSTANCE.getModule(id);
    }

    protected ModuleInstance(IModule moduleClass, ModuleFactory createdByFactory, String moduleName, ResourceLocation icon, ItemStack itemStack, Color primaryColor, Color secondaryColor, DefaultHashMap<AttributeRegistry.Attribute, AttributeRange> attributeRanges) {
        this.moduleClass = moduleClass;
        this.createdByFactory = createdByFactory;
        this.moduleNBTKey = moduleName;
        this.icon = icon;
        this.itemStack = itemStack;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.attributeRanges = attributeRanges;
    }

    static ModuleInstance createInstance(IModule moduleClass, ModuleFactory createdByFactory, String subModuleID, ResourceLocation icon, ItemStack itemStack, Color primaryColor, Color secondaryColor, DefaultHashMap<AttributeRegistry.Attribute, AttributeRange> attributeRanges) {
        if (moduleClass instanceof IModuleEffect) {
            return new ModuleInstanceEffect((IModuleEffect)moduleClass, createdByFactory, subModuleID, icon, itemStack, primaryColor, secondaryColor, attributeRanges);
        }
        if (moduleClass instanceof IModuleModifier) {
            return new ModuleInstanceModifier((IModuleModifier)moduleClass, createdByFactory, subModuleID, icon, itemStack, primaryColor, secondaryColor, attributeRanges);
        }
        if (moduleClass instanceof IModuleEvent) {
            return new ModuleInstanceEvent((IModuleEvent)moduleClass, createdByFactory, itemStack, subModuleID, icon, primaryColor, secondaryColor, attributeRanges);
        }
        if (moduleClass instanceof IModuleShape) {
            return new ModuleInstanceShape((IModuleShape)moduleClass, createdByFactory, itemStack, subModuleID, icon, primaryColor, secondaryColor, attributeRanges);
        }
        throw new UnsupportedOperationException("Unknown module type.");
    }

    public final IModule getModuleClass() {
        return this.moduleClass;
    }

    public final ModuleFactory getFactory() {
        return this.createdByFactory;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public SpellData renderVisualization(@Nonnull World world, @Nonnull SpellData data, @Nonnull SpellRing ring, float partialTicks) {
        return this.standardRenderVisualization(data, ring, partialTicks);
    }

    public final SpellData standardRenderVisualization(@Nonnull SpellData data, @Nonnull SpellRing ring, float partialTicks) {
        return data;
    }

    @Nullable
    public final ItemStack getAvailableStack(Collection<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return null;
    }

    @Nullable
    public final IBlockState getSelectedBlockState(EntityLivingBase caster) {
        ItemStack hand = caster.func_184614_ca();
        if (hand.func_190926_b()) {
            return null;
        }
        if (NBTHelper.hasNBTEntry((ItemStack)hand, (String)"selected")) {
            NBTTagCompound compound = NBTHelper.getCompound((ItemStack)hand, (String)"selected");
            if (compound == null) {
                return null;
            }
            return NBTUtil.func_190008_d((NBTTagCompound)compound);
        }
        return null;
    }

    public final List<ItemStack> getAllOfStackFromInventory(@Nonnull EntityPlayer player, @Nonnull IBlockState state) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        World world = player.field_70170_p;
        ItemStack search = state.func_177230_c().func_185473_a(world, null, state);
        if (search.func_190926_b()) {
            return stacks;
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock) || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)search)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public final List<ItemStack> getAllOfStackFromInventory(@Nonnull EntityPlayer player, @Nonnull ItemStack search) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (search.func_190926_b()) {
            return stacks;
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock) || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)search)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public final int getCountOfStackFromInventory(@Nonnull EntityPlayer player, @Nonnull IBlockState state) {
        World world = player.field_70170_p;
        ItemStack search = state.func_177230_c().func_185473_a(world, null, state);
        List<ItemStack> stacks = this.getAllOfStackFromInventory(player, search);
        int count = 0;
        for (ItemStack stack : stacks) {
            count += stack.func_190916_E();
        }
        return count;
    }

    public final int getCountOfStackFromInventory(@Nonnull EntityPlayer player, @Nonnull ItemStack search) {
        List<ItemStack> stacks = this.getAllOfStackFromInventory(player, search);
        int count = 0;
        for (ItemStack stack : stacks) {
            count += stack.func_190916_E();
        }
        return count;
    }

    public final int getCountOfStacks(@Nonnull Collection<ItemStack> stacks) {
        int count = 0;
        for (ItemStack stack : stacks) {
            count += stack.func_190916_E();
        }
        return count;
    }

    public abstract ModuleType getModuleType();

    public final String getNBTKey() {
        return this.moduleNBTKey;
    }

    public final String getReferenceModuleID() {
        return this.createdByFactory.getReferenceModuleID();
    }

    public final String toString() {
        return this.getNBTKey();
    }

    @Nonnull
    public final String getReadableName() {
        return LibrarianLib.PROXY.translate(this.getNameKey(), new Object[0]);
    }

    @Nonnull
    public final String getNameKey() {
        return "wizardry.spell." + this.moduleNBTKey + ".name";
    }

    @Nonnull
    public final String getDescription() {
        return LibrarianLib.PROXY.translate(this.getDescriptionKey(), new Object[0]);
    }

    @Nonnull
    public final IBlockState getCachableBlockstate(@Nonnull World world, @Nonnull BlockPos targetBlock, @Nonnull SpellData data) {
        IBlockState state;
        SpellDataTypes.BlockStateCache cacheData = data.getData(SpellData.DefaultKeys.BLOCKSTATE_CACHE);
        if (cacheData != null && cacheData.getBlockStateCache() != null) {
            Map<BlockPos, IBlockState> cache = cacheData.getBlockStateCache();
            if (cache.containsKey(targetBlock)) {
                return cache.get(targetBlock);
            }
            state = world.func_180495_p(targetBlock);
            cache.put(targetBlock, state);
            data.addData(SpellData.DefaultKeys.BLOCKSTATE_CACHE, new SpellDataTypes.BlockStateCache(cache));
        } else {
            HashMap<BlockPos, IBlockState> cache = new HashMap<BlockPos, IBlockState>();
            state = world.func_180495_p(targetBlock);
            cache.put(targetBlock, state);
            data.addData(SpellData.DefaultKeys.BLOCKSTATE_CACHE, new SpellDataTypes.BlockStateCache(cache));
        }
        return state;
    }

    public List<String> getDetailedInfo() {
        ArrayList<String> detailedInfo = new ArrayList<String>();
        for (AttributeRegistry.Attribute attribute : this.attributeRanges.keySet()) {
            if (!attribute.hasDetailedText()) continue;
            detailedInfo.addAll(this.getDetailedInfo(attribute));
        }
        return detailedInfo;
    }

    @Nonnull
    public final List<String> getDetailedInfo(AttributeRegistry.Attribute attribute) {
        ArrayList<String> detailedInfo = new ArrayList<String>();
        String infoKey = this.getDescriptionKey() + ".";
        String rangeKey = "wizardry.misc.attribute_range";
        detailedInfo.add(LibrarianLib.PROXY.translate(infoKey + attribute.getShortName(), new Object[0]));
        detailedInfo.add("    " + LibrarianLib.PROXY.translate(rangeKey, new Object[0]) + this.attributeRanges.get(attribute));
        return detailedInfo;
    }

    @Nullable
    public ModuleInstanceModifier[] applicableModifiers() {
        if (this.applicableModifiers == null) {
            LinkedList<ModuleInstanceModifier> applicableModifiersList = new LinkedList<ModuleInstanceModifier>();
            String[] modifierNames = this.moduleClass.compatibleModifiers();
            if (modifierNames != null) {
                block0: for (ModuleInstance mod : ModuleRegistry.INSTANCE.modules) {
                    for (String modifier : modifierNames) {
                        if (!mod.getNBTKey().equals(modifier) || !(mod instanceof ModuleInstanceModifier)) continue;
                        applicableModifiersList.add((ModuleInstanceModifier)mod);
                        continue block0;
                    }
                }
            }
            this.applicableModifiers = applicableModifiersList.toArray(new ModuleInstanceModifier[applicableModifiersList.size()]);
        }
        return this.applicableModifiers;
    }

    @Nonnull
    public final String getDescriptionKey() {
        return "wizardry.spell." + this.moduleNBTKey + ".desc";
    }

    @Nonnull
    public final Color getPrimaryColor() {
        return this.primaryColor;
    }

    public final double getBurnoutFill() {
        return this.attributeRanges.get((Object)AttributeRegistry.BURNOUT).min;
    }

    public final int getCooldownTime() {
        return (int)this.attributeRanges.get((Object)AttributeRegistry.COOLDOWN).min;
    }

    public final int getChargeupTime() {
        return (int)this.attributeRanges.get((Object)AttributeRegistry.CHARGEUP).min;
    }

    public final ItemStack getItemStack() {
        return this.itemStack;
    }

    public final double getManaDrain() {
        return this.attributeRanges.get((Object)AttributeRegistry.MANA).min;
    }

    public final double getPowerMultiplier() {
        return this.attributeRanges.get((Object)AttributeRegistry.POWER_MULTI).min;
    }

    public final double getManaMultiplier() {
        return this.attributeRanges.get((Object)AttributeRegistry.MANA_MULTI).min;
    }

    public final double getBurnoutMultiplier() {
        return this.attributeRanges.get((Object)AttributeRegistry.BURNOUT_MULTI).min;
    }

    @Nonnull
    public final Color getSecondaryColor() {
        return this.secondaryColor;
    }

    public List<AttributeModifier> getAttributeModifiers() {
        return this.attributeModifiers;
    }

    public Map<AttributeRegistry.Attribute, AttributeRange> getAttributeRanges() {
        return this.attributeRanges;
    }

    public final void addAttribute(AttributeModifier attribute) {
        this.attributeModifiers.add(attribute);
    }

    public final void addAttributeRange(AttributeRegistry.Attribute attribute, AttributeRange range) {
        this.attributeRanges.put(attribute, range);
    }

    public boolean ignoreResultsForRendering() {
        return false;
    }

    public boolean shouldRunChildren() {
        return true;
    }

    public boolean run(@Nonnull World world, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderSpell(@Nonnull World world, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
    }

    public final boolean castSpell(@Nonnull World world, @Nonnull SpellData data, @Nonnull SpellRing ring) {
        boolean success;
        if (world.field_72995_K) {
            return true;
        }
        boolean ranOnce = false;
        NBTTagList list = data.getDataWithFallback(SpellData.DefaultKeys.TAG_LIST, new NBTTagList());
        for (NBTBase base : list) {
            if (!(base instanceof NBTTagString) || !((NBTTagString)base).func_150285_a_().equals(ring.getUniqueID().toString())) continue;
            ranOnce = true;
            break;
        }
        if (this.moduleClass instanceof ILingeringModule && !ranOnce) {
            WizardryWorld worldCap = WizardryWorldCapability.get(world);
            list.func_74742_a((NBTBase)new NBTTagString(ring.getUniqueID().toString()));
            data.addData(SpellData.DefaultKeys.TAG_LIST, list);
            boolean bl = success = this.internalCastSpell(world, data, ring) && ((ILingeringModule)((Object)this.moduleClass)).runOnStart(world, data, ring);
            if (success) {
                worldCap.getSpellObjectManager().addLingering(new SpellObjectManager.LingeringObject(world, data, ring), ((ILingeringModule)((Object)this.moduleClass)).getLingeringTime(world, data, ring));
            }
        } else {
            success = this.internalCastSpell(world, data, ring);
        }
        if (success || this.ignoreResultsForRendering()) {
            this.sendRenderPacket(world, data, ring);
        }
        return success;
    }

    private boolean internalCastSpell(@Nonnull World world, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        SpellCastEvent event = new SpellCastEvent(world, spellRing, spell);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled() && this.run(world, spell, spellRing);
    }

    public final void sendRenderPacket(@Nonnull World world, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d target = spell.getTargetWithFallback(world);
        if (target != null) {
            PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketRenderSpell(spell, spellRing), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), target.field_72450_a, target.field_72448_b, target.field_72449_c, 256.0));
        }
    }

    @Nonnull
    public final NBTTagString serialize() {
        return new NBTTagString(this.getNBTKey());
    }

    public ResourceLocation getIconLocation() {
        if (this.icon == null) {
            return new ResourceLocation("wizardry", "textures/gui/worktable/icons/" + this.getNBTKey() + ".png");
        }
        return this.icon;
    }
}

