/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell;

import com.google.common.collect.ArrayListMultimap;
import com.teamwizardry.wizardry.Wizardry;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaManager;
import com.teamwizardry.wizardry.api.item.BaublesSupport;
import com.teamwizardry.wizardry.api.spell.IContinuousModule;
import com.teamwizardry.wizardry.api.spell.IOverrideCooldown;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeModifier;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRange;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.attribute.Operation;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceModifier;
import com.teamwizardry.wizardry.api.spell.module.ModuleOverrideHandler;
import com.teamwizardry.wizardry.api.util.FixedPointUtils;
import com.teamwizardry.wizardry.init.ModItems;
import com.teamwizardry.wizardry.init.ModSounds;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.tuple.Pair;

public class SpellRing
implements INBTSerializable<NBTTagCompound> {
    private NBTTagCompound serializedTag = null;
    private NBTTagCompound informationTag = new NBTTagCompound();
    @Nonnull
    private ArrayListMultimap<Operation, AttributeModifierSpellRing> compileTimeModifiers = ArrayListMultimap.create();
    @Nonnull
    private Color primaryColor = Color.WHITE;
    @Nonnull
    private Color secondaryColor = Color.WHITE;
    @Nullable
    private ModuleInstance module;
    @Nullable
    private SpellRing parentRing = null;
    @Nullable
    private SpellRing childRing = null;
    private ModuleOverrideHandler lazy_overrideHandler = null;
    @Nonnull
    private UUID uniqueID = UUID.randomUUID();

    private SpellRing() {
    }

    SpellRing(@Nonnull ModuleInstance module) {
        this.setModule(module);
    }

    public static SpellRing deserializeRing(NBTTagCompound compound) {
        SpellRing lastRing;
        SpellRing ring = new SpellRing();
        ring.deserializeNBT(compound);
        for (lastRing = ring; lastRing != null && lastRing.getChildRing() != null; lastRing = lastRing.getChildRing()) {
        }
        if (lastRing != null) {
            lastRing.updateColorChain();
        }
        return ring;
    }

    private static NBTTagCompound sortInformationTag(Map<String, Float> informationMap) {
        ArrayList<Pair> sortedInformationList = new ArrayList<Pair>(informationMap.size());
        informationMap.forEach((key, val) -> sortedInformationList.add(Pair.of((Object)key, (Object)Float.valueOf(FixedPointUtils.doubleToFixed(val.floatValue())))));
        sortedInformationList.sort(Comparator.comparing(Pair::getKey));
        NBTTagCompound newInformationTag = new NBTTagCompound();
        for (Pair entry : sortedInformationList) {
            FixedPointUtils.setFixedToNBT(newInformationTag, (String)entry.getKey(), ((Float)entry.getValue()).floatValue());
        }
        return newInformationTag;
    }

    private static NBTTagCompound sortInformationTag(NBTTagCompound informationNbt) {
        ArrayList<Pair> sortedInformationList = new ArrayList<Pair>(informationNbt.func_186856_d());
        for (String key : informationNbt.func_150296_c()) {
            sortedInformationList.add(Pair.of((Object)key, (Object)Float.valueOf(FixedPointUtils.getFixedFromNBT(informationNbt, key))));
        }
        sortedInformationList.sort(Comparator.comparing(Pair::getKey));
        NBTTagCompound newInformationTag = new NBTTagCompound();
        for (Pair entry : sortedInformationList) {
            FixedPointUtils.setFixedToNBT(newInformationTag, (String)entry.getKey(), ((Float)entry.getValue()).floatValue());
        }
        return newInformationTag;
    }

    private static NBTTagList sortModifierList(List<NBTTagCompound> modifierList) {
        NBTTagList attribs = new NBTTagList();
        modifierList.sort(SpellRing::compareModifierCompounds);
        for (NBTTagCompound modifierCompound : modifierList) {
            attribs.func_74742_a((NBTBase)modifierCompound);
        }
        return attribs;
    }

    private static int compareModifierCompounds(NBTTagCompound nbt1, NBTTagCompound nbt2) {
        int op2;
        int op1 = nbt1.func_74762_e("operation");
        if (op1 != (op2 = nbt2.func_74762_e("operation"))) {
            return op1 - op2 > 0 ? 1 : -1;
        }
        return nbt1.func_74779_i("attribute").compareTo(nbt2.func_74779_i("attribute"));
    }

    public void runSpellRing(@Nonnull World world, SpellData data, boolean makeSpellIndependant) {
        boolean success;
        SpellData modifData;
        if (this.module == null) {
            return;
        }
        SpellRing modifRing = makeSpellIndependant ? this.changeUUID() : this;
        SpellData spellData = modifData = makeSpellIndependant ? data.copy() : data;
        if (modifData.getCaster(world) != null) {
            modifData.processCastTimeModifiers(modifData.getCaster(world), modifRing);
        }
        if ((success = this.module.castSpell(world, modifData, modifRing)) && this.module.shouldRunChildren() && this.getChildRing() != null) {
            this.getChildRing().runSpellRing(world, modifData, makeSpellIndependant);
        }
    }

    public final double getTrueAttributeValue(AttributeRegistry.Attribute attribute) {
        if (this.module == null) {
            return 0.0;
        }
        double current = FixedPointUtils.getDoubleFromNBT(this.informationTag, attribute.getNbtName());
        AttributeRange range = this.module.getAttributeRanges().get(attribute);
        return MathHelper.func_151237_a((double)current, (double)range.min, (double)range.max);
    }

    public boolean taxCaster(@Nonnull World world, SpellData data, double multiplier, boolean failSound) {
        Vec3d origin;
        Entity caster = data.getCaster(world);
        if (caster == null) {
            return false;
        }
        double manaDrain = this.getManaDrain(data) * multiplier;
        double burnoutFill = this.getBurnoutFill(data) * multiplier;
        boolean fail = false;
        try (ManaManager.CapManagerBuilder mgr = ManaManager.forObject(caster);){
            if (mgr.getMana() < manaDrain) {
                fail = true;
            }
            mgr.removeMana(manaDrain);
            mgr.addBurnout(burnoutFill);
        }
        if (fail && failSound && (origin = data.getOriginWithFallback(world)) != null) {
            world.func_184133_a(null, new BlockPos(origin), (SoundEvent)ModSounds.SPELL_FAIL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        return !fail;
    }

    public boolean taxCaster(@Nonnull World world, SpellData data, boolean failSound) {
        return this.taxCaster(world, data, 1.0, failSound);
    }

    public boolean isContinuous() {
        if (this.module != null) {
            return this.module.getModuleClass() instanceof IContinuousModule;
        }
        return false;
    }

    public final Set<SpellRing> getAllChildRings() {
        HashSet<SpellRing> childRings = new HashSet<SpellRing>();
        if (this.childRing == null) {
            return childRings;
        }
        for (SpellRing tempModule = this.childRing; tempModule != null; tempModule = tempModule.getChildRing()) {
            childRings.add(tempModule);
        }
        return childRings;
    }

    public final float getAttributeValue(World world, AttributeRegistry.Attribute attribute, SpellData data) {
        if (this.module == null) {
            return 0.0f;
        }
        float current = FixedPointUtils.getDoubleFromNBT(this.informationTag, attribute.getNbtName());
        AttributeRange range = this.module.getAttributeRanges().get(attribute);
        current = MathHelper.func_76131_a((float)current, (float)range.min, (float)range.max);
        current = data.getCastTimeValue(attribute, current);
        current = (float)((double)current * this.getPlayerBurnoutMultiplier(world, data));
        current = (float)((double)current * this.getPowerMultiplier());
        return current;
    }

    @Nullable
    public SpellRing getChildRing() {
        return this.childRing;
    }

    void processModifiers() {
        HashMap<String, Float> informationMap = new HashMap<String, Float>();
        if (this.module != null) {
            this.module.getAttributeRanges().forEach((attribute, range) -> informationMap.put(attribute.getNbtName(), Float.valueOf(range.min)));
        }
        for (Operation op : Operation.values()) {
            if (!this.compileTimeModifiers.containsKey((Object)op)) continue;
            for (AttributeModifier modifier : this.compileTimeModifiers.get((Object)op)) {
                if (!informationMap.containsKey(modifier.getAttribute().getNbtName())) continue;
                float current = informationMap.get(modifier.getAttribute().getNbtName()).floatValue();
                float newValue = modifier.apply(current);
                informationMap.put(modifier.getAttribute().getNbtName(), Float.valueOf(newValue));
                if (!ConfigValues.debugInfo) continue;
                Wizardry.LOGGER.info(this.module == null ? "<null module>" : this.module.getNBTKey() + ": Attribute: " + modifier.getAttribute() + ": " + current + "-> " + newValue);
            }
        }
        this.informationTag = SpellRing.sortInformationTag(informationMap);
    }

    @Nullable
    public SpellRing getParentRing() {
        return this.parentRing;
    }

    public SpellRing changeUUID() {
        this.uniqueID = UUID.randomUUID();
        return this;
    }

    void setChildRing(@Nonnull SpellRing childRing) {
        this.childRing = childRing;
    }

    @Nullable
    public ModuleInstance getModule() {
        return this.module;
    }

    void setParentRing(@Nullable SpellRing parentRing) {
        this.parentRing = parentRing;
    }

    @Nonnull
    public Color getPrimaryColor() {
        return this.primaryColor;
    }

    @Nonnull
    public synchronized ModuleOverrideHandler getOverrideHandler() {
        if (this.lazy_overrideHandler == null) {
            this.lazy_overrideHandler = this.parentRing != null ? this.parentRing.getOverrideHandler() : new ModuleOverrideHandler(this);
        }
        return this.lazy_overrideHandler;
    }

    @Nonnull
    public Color getSecondaryColor() {
        return this.secondaryColor;
    }

    void setModule(@Nonnull ModuleInstance module) {
        this.module = module;
        this.setPrimaryColor(module.getPrimaryColor());
        this.setSecondaryColor(module.getSecondaryColor());
    }

    void updateColorChain() {
        if (this.getParentRing() == null) {
            return;
        }
        this.getParentRing().setPrimaryColor(this.getPrimaryColor());
        this.getParentRing().setSecondaryColor(this.getSecondaryColor());
        this.getParentRing().updateColorChain();
    }

    public double getPowerMultiplier() {
        return this.getTrueAttributeValue(AttributeRegistry.POWER_MULTI);
    }

    public double getManaMultiplier() {
        return this.getTrueAttributeValue(AttributeRegistry.MANA_MULTI);
    }

    public double getBurnoutMultiplier() {
        return this.getTrueAttributeValue(AttributeRegistry.BURNOUT_MULTI);
    }

    void setPrimaryColor(@Nonnull Color primaryColor) {
        this.primaryColor = primaryColor;
        this.updateColorChain();
    }

    void setSecondaryColor(@Nonnull Color secondaryColor) {
        this.secondaryColor = secondaryColor;
    }

    public double getManaDrain(SpellData data) {
        float value = FixedPointUtils.getDoubleFromNBT(this.informationTag, AttributeRegistry.MANA.getNbtName());
        if (data != null) {
            value = data.getCastTimeValue(AttributeRegistry.MANA, value);
        }
        return (double)value * this.getManaMultiplier();
    }

    public double getBurnoutFill(SpellData data) {
        float value = FixedPointUtils.getDoubleFromNBT(this.informationTag, AttributeRegistry.BURNOUT.getNbtName());
        if (data != null) {
            value = data.getCastTimeValue(AttributeRegistry.BURNOUT, value);
        }
        return (double)value * this.getBurnoutMultiplier();
    }

    void addModifier(ModuleInstanceModifier moduleModifier) {
        moduleModifier.getAttributeModifiers().forEach(modifier -> this.compileTimeModifiers.put((Object)modifier.getOperation(), (Object)new AttributeModifierSpellRing((AttributeModifier)modifier)));
    }

    void addModifier(AttributeModifier attributeModifier) {
        this.compileTimeModifiers.put((Object)attributeModifier.getOperation(), (Object)new AttributeModifierSpellRing(attributeModifier));
    }

    public int getChargeUpTime() {
        return (int)FixedPointUtils.getDoubleFromNBT(this.informationTag, AttributeRegistry.CHARGEUP.getNbtName());
    }

    public int getCooldownTime(@Nullable World world, @Nullable SpellData data) {
        if (this.module != null && data != null && world != null && this.module.getModuleClass() instanceof IOverrideCooldown) {
            return ((IOverrideCooldown)((Object)this.module.getModuleClass())).getNewCooldown(world, data, this);
        }
        return (int)FixedPointUtils.getDoubleFromNBT(this.informationTag, AttributeRegistry.COOLDOWN.getNbtName());
    }

    @Nullable
    public String getModuleReadableName() {
        return this.module != null ? this.module.getReadableName() : null;
    }

    public NBTTagCompound getInformationTag() {
        return this.informationTag;
    }

    public int getCooldownTime() {
        return this.getCooldownTime(null, null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (SpellRing ring = this; ring != null; ring = ring.getChildRing()) {
            builder.append(ring.getModuleReadableName()).append(ring.getChildRing() == null ? "" : " > ");
        }
        return builder.toString();
    }

    public double getPlayerBurnoutMultiplier(World world, SpellData data) {
        Entity caster = data.getCaster(world);
        if (caster == null || caster instanceof EntityLivingBase && BaublesSupport.getItem((EntityLivingBase)caster, ModItems.CREATIVE_HALO, ModItems.FAKE_HALO, ModItems.REAL_HALO).func_190926_b()) {
            return 1.0;
        }
        double multiplier = ManaManager.getBurnout(caster) / ManaManager.getMaxBurnout(caster);
        double burnoutLimit = 0.5;
        return Math.min(1.0, 1.0 - (multiplier - burnoutLimit) / (1.0 - burnoutLimit));
    }

    @Nonnull
    public UUID getUniqueID() {
        return this.uniqueID;
    }

    public NBTTagCompound serializeNBT() {
        if (this.serializedTag == null) {
            this.serializedTag = this.internalSerializeNBT();
        }
        return this.serializedTag;
    }

    private NBTTagCompound internalSerializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        if (!this.compileTimeModifiers.isEmpty()) {
            ArrayList<NBTTagCompound> modifierList = new ArrayList<NBTTagCompound>(this.compileTimeModifiers.size());
            this.compileTimeModifiers.forEach((op, modifier) -> {
                NBTTagCompound modifierCompound = new NBTTagCompound();
                modifierCompound.func_74768_a("operation", modifier.getOperation().ordinal());
                modifierCompound.func_74778_a("attribute", modifier.getAttribute().getNbtName());
                FixedPointUtils.setFixedToNBT(modifierCompound, "modifier", modifier.getModifierFixed());
                modifierList.add(modifierCompound);
            });
            NBTTagList attribs = SpellRing.sortModifierList(modifierList);
            compound.func_74782_a("modifiers", (NBTBase)attribs);
        }
        compound.func_74782_a("extra", (NBTBase)this.informationTag);
        compound.func_74778_a("primary_color", String.valueOf(this.primaryColor.getRGB()));
        compound.func_74778_a("secondary_color", String.valueOf(this.secondaryColor.getRGB()));
        if (this.childRing != null) {
            compound.func_74782_a("child_ring", (NBTBase)this.childRing.serializeNBT());
        }
        if (this.module != null) {
            compound.func_74778_a("module", this.module.getNBTKey());
        }
        compound.func_74778_a("uuid", this.uniqueID.toString());
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("module")) {
            this.module = ModuleInstance.deserialize(nbt.func_74779_i("module"));
        }
        if (nbt.func_74764_b("extra")) {
            this.informationTag = SpellRing.sortInformationTag(nbt.func_74775_l("extra"));
        }
        if (nbt.func_74764_b("primary_color")) {
            this.primaryColor = Color.decode(nbt.func_74779_i("primary_color"));
        }
        if (nbt.func_74764_b("secondary_color")) {
            this.secondaryColor = Color.decode(nbt.func_74779_i("secondary_color"));
        }
        if (nbt.func_74764_b("modifiers")) {
            this.compileTimeModifiers.clear();
            for (NBTBase base : nbt.func_150295_c("modifiers", 10)) {
                NBTTagCompound modifierCompound;
                if (!(base instanceof NBTTagCompound) || !(modifierCompound = (NBTTagCompound)base).func_74764_b("operation") || !modifierCompound.func_74764_b("attribute") || !modifierCompound.func_74764_b("modifier")) continue;
                Operation operation = Operation.values()[modifierCompound.func_74762_e("operation") % Operation.values().length];
                AttributeRegistry.Attribute attribute = AttributeRegistry.getAttributeFromName(modifierCompound.func_74779_i("attribute"));
                float modifierFixed = FixedPointUtils.getFixedFromNBT(modifierCompound, "modifier");
                this.compileTimeModifiers.put((Object)operation, (Object)new AttributeModifierSpellRing(attribute, modifierFixed, operation));
            }
        }
        if (nbt.func_74764_b("child_ring")) {
            SpellRing childRing = SpellRing.deserializeRing(nbt.func_74775_l("child_ring"));
            childRing.setParentRing(this);
            this.setChildRing(childRing);
        }
        if (nbt.func_74764_b("uuid")) {
            this.uniqueID = UUID.fromString(nbt.func_74779_i("uuid"));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpellRing ring = (SpellRing)o;
        return Objects.equals(this.uniqueID, ring.uniqueID);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueID);
    }

    private static class AttributeModifierSpellRing
    extends AttributeModifier {
        private float modifierFixed;

        public AttributeModifierSpellRing(AttributeModifier modifier) {
            this(modifier.getAttribute(), modifier.getModifier(), modifier.getOperation());
        }

        public AttributeModifierSpellRing(AttributeRegistry.Attribute attribute, float modifier, Operation op) {
            super(attribute, modifier, op);
            this.modifierFixed = FixedPointUtils.doubleToFixed(modifier);
        }

        public AttributeModifierSpellRing(AttributeRegistry.Attribute attribute, long modifierFixed, Operation op) {
            super(attribute, FixedPointUtils.fixedToDouble(modifierFixed), op);
        }

        public float getModifierFixed() {
            return this.modifierFixed;
        }

        @Override
        public void setModifier(float newValue) {
            this.modifierFixed = FixedPointUtils.doubleToFixed(newValue);
            super.setModifier(newValue);
        }

        @Override
        public AttributeModifier copy() {
            return new AttributeModifierSpellRing(this.getAttribute(), this.modifierFixed, this.getOperation());
        }
    }
}

